/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.resource.cache;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.media.ExifInterface;
import android.provider.MediaStore;
import android.util.Log;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.resource.compress.AbstractCompressRequest;
import com.sea_monster.core.resource.compress.IResourceCompressHandler;
import com.sea_monster.core.resource.io.IFileSysHandler;
import com.sea_monster.core.resource.model.CompressOptions;
import com.sea_monster.core.resource.model.CompressedResource;
import com.sea_monster.core.resource.model.LocalMicroResource;
import com.sea_monster.core.resource.model.Resource;
import com.sea_monster.core.utils.ImageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import uk.co.senab.bitmapcache.BitmapLruCache;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class ResourceCacheWrapper {
    BitmapLruCache mCache;
    Context mContext;
    IFileSysHandler mFileSysHandler;
    IResourceCompressHandler mCompressHandler;
    private Map<CompressedResource, AbstractCompressRequest> mCompressMapping;

    private BitmapFactory.Options obtainOptions() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        return options;
    }

    public ResourceCacheWrapper(Context context, BitmapLruCache cache, IFileSysHandler fileSysHandler, IResourceCompressHandler compressHandler) {
        this.mCache = cache;
        this.mContext = context;
        this.mFileSysHandler = fileSysHandler;
        this.mCompressHandler = compressHandler;
        this.mCompressMapping = new HashMap<CompressedResource, AbstractCompressRequest>();
    }

    public boolean contains(Resource resource) {
        return this.mCache.contains(resource.getUri().toString());
    }

    public boolean containsInDiskCache(Resource resource) {
        return this.mCache.containsInDiskCache(resource.getUri().toString());
    }

    public boolean containsInMemoryCache(Resource resource) {
        return this.mCache.containsInMemoryCache(resource.getUri().toString());
    }

    public CacheableBitmapDrawable get(Resource res) {
        return this.mCache.get(res.getUri().toString(), this.obtainOptions());
    }

    public CacheableBitmapDrawable put(Resource resource, Bitmap bitmap) {
        return this.mCache.put(resource.getUri().toString(), bitmap);
    }

    public void put(Resource resource, InputStream stream) {
        this.mCache.putOrigin(resource.getUri().toString(), stream);
    }

    public CacheableBitmapDrawable getFromDiskCache(Resource res) {
        return this.mCache.getFromDiskCache(res.getUri().toString(), this.obtainOptions());
    }

    public File getFileFromDiskCache(Resource res) {
        return this.mCache.getFileFromDiskCache(res.getUri().toString());
    }

    public CacheableBitmapDrawable getFromMemoryCache(Resource res) {
        return this.mCache.getFromMemoryCache(res.getUri().toString());
    }

    public BitmapDrawable buildCompareBitmap(CompressedResource res) throws IOException {
        Log.d((String)"buildCompareBitmap", (String)res.getUri().toString());
        final CompressedResource resource = res;
        CompressOptions options = null;
        options = this.getCompressOptions(resource);
        InputStream stream = null;
        stream = res.getUri().getScheme().equals("file") ? new FileInputStream(res.getOriResource().getUri().getPath()) : (res.getUri().getScheme().equals("content") ? this.mContext.getContentResolver().openInputStream(res.getUri()) : this.mFileSysHandler.getInputStream(res.getOriResource().getUri()));
        if (!this.mCompressMapping.containsKey(resource)) {
            AbstractCompressRequest compressRequest = new AbstractCompressRequest(resource.getOriResource(), stream, options){

                @Override
                public void onFailure(BaseException e) {
                    ResourceCacheWrapper.this.mCompressMapping.remove(resource);
                    e.printStackTrace();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onComplete(Bitmap obj) {
                    ResourceCacheWrapper.this.mCompressMapping.remove(resource);
                    Bitmap bitmap = obj;
                    synchronized (bitmap) {
                        ResourceCacheWrapper.this.mCache.put(resource.getUri().toString(), obj);
                    }
                }
            };
            this.mCompressMapping.put(resource, compressRequest);
            try {
                if (options.isCrop()) {
                    this.mCompressHandler.compressResourceWithCrop(compressRequest);
                } else {
                    this.mCompressHandler.compressResource(compressRequest);
                }
            }
            catch (Exception e) {
                compressRequest.onFailure(new BaseException(e));
            }
            return this.mCache.get(res.getUri().toString());
        }
        return null;
    }

    public BitmapDrawable buildCompareBitmap(LocalMicroResource res) {
        Log.d((String)"buildCompareBitmap", (String)res.getUri().toString());
        Bitmap result = null;
        Bitmap bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)this.mContext.getContentResolver(), (long)res.getImageId(), (int)3, (BitmapFactory.Options)this.obtainOptions());
        try {
            ExifInterface exifInterface = new ExifInterface(res.getUri().getPath());
            int orientation = exifInterface.getAttributeInt("Orientation", 0);
            if (orientation > 1) {
                Matrix matrix = new Matrix();
                int w = bitmap.getWidth();
                int h = bitmap.getHeight();
                switch (orientation) {
                    case 6: {
                        matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 3: {
                        matrix.setRotate(180.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 8: {
                        matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                        break;
                    }
                    case 2: {
                        matrix.preScale(-1.0f, 1.0f);
                        break;
                    }
                    case 4: {
                        matrix.preScale(1.0f, -1.0f);
                        break;
                    }
                    case 5: {
                        matrix.setRotate(90.0f, (float)w / 2.0f, (float)h / 2.0f);
                        matrix.preScale(1.0f, -1.0f);
                        break;
                    }
                    case 7: {
                        matrix.setRotate(270.0f, (float)w / 2.0f, (float)h / 2.0f);
                        matrix.preScale(1.0f, -1.0f);
                    }
                }
                result = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            } else {
                result = bitmap;
            }
        }
        catch (IOException e) {
            result = bitmap;
            e.printStackTrace();
        }
        return this.mCache.put(res.getUri().toString(), result);
    }

    public CompressOptions getCompressOptions(CompressedResource resource) throws IOException {
        InputStream stream;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        if (resource.getOriResource().getUri().getScheme().equals("file")) {
            resource.getOriResource().setOrientaion(ImageUtils.getOrientation(resource.getOriResource().getUri().getPath()));
            stream = new FileInputStream(resource.getOriResource().getUri().getPath());
        } else if (resource.getOriResource().getUri().getScheme().equals("content")) {
            Cursor cursor = this.mContext.getContentResolver().query(resource.getOriResource().getUri(), new String[]{"_data"}, null, null, null);
            cursor.moveToFirst();
            String path = cursor.getString(0);
            cursor.close();
            resource.getOriResource().setOrientaion(ImageUtils.getOrientation(path));
            stream = this.mContext.getContentResolver().openInputStream(resource.getOriResource().getUri());
        } else {
            resource.getOriResource().setOrientaion(ImageUtils.getOrientation(this.mFileSysHandler.getFile(resource.getOriResource().getUri())));
            stream = this.mFileSysHandler.getInputStream(resource.getOriResource().getUri());
        }
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        int oriHeight = options.outHeight;
        int oriWidth = options.outWidth;
        CompressOptions compressOption = new CompressOptions(resource.getWidth(), resource.getHeight(), oriWidth, oriHeight, resource.getOriResource().getOrientaion(), resource.isCrop());
        return compressOption;
    }

    public File getCompressFile(CompressedResource res, String target) throws IOException {
        Bitmap bitmap = null;
        final CompressedResource resource = res;
        CompressOptions options = this.getCompressOptions(resource);
        InputStream stream = null;
        stream = res.getUri().getScheme().equals("file") ? new FileInputStream(res.getOriResource().getUri().getPath()) : this.mFileSysHandler.getInputStream(res.getOriResource().getUri());
        if (!this.mCompressMapping.containsKey(res)) {
            AbstractCompressRequest compressRequest = new AbstractCompressRequest(resource.getOriResource(), stream, options){

                @Override
                public void onFailure(BaseException e) {
                    ResourceCacheWrapper.this.mCompressMapping.remove(resource);
                    ResourceCacheWrapper.this.mFileSysHandler.delFile(resource.getUri());
                    e.printStackTrace();
                }

                @Override
                public void onComplete(Bitmap obj) {
                    ResourceCacheWrapper.this.mCompressMapping.remove(resource);
                }
            };
            this.mCompressMapping.put(resource, compressRequest);
            bitmap = options.isCrop() ? this.mCompressHandler.compressResourceWithCrop(compressRequest) : this.mCompressHandler.compressResource(compressRequest);
            if (bitmap == null) {
                return null;
            }
            File file = new File(target);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)new FileOutputStream(file));
            bitmap.recycle();
            return file;
        }
        return null;
    }
}

