/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.resource;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.StoreStatusCallback;
import com.sea_monster.core.resource.cache.ResourceCacheWrapper;
import com.sea_monster.core.resource.io.ResourceRemoteWrapper;
import com.sea_monster.core.resource.model.CompressedResource;
import com.sea_monster.core.resource.model.LocalMicroResource;
import com.sea_monster.core.resource.model.LocalResource;
import com.sea_monster.core.resource.model.RequestResource;
import com.sea_monster.core.resource.model.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Observer;
import uk.co.senab.bitmapcache.CacheableBitmapDrawable;

public class ResourceManager {
    private static final String TAG = "RemoteResourceManager";
    private final boolean DEBUG = false;
    private Context mContext;
    private ResourceRemoteWrapper mRemoteWrapper;
    private ResourceCacheWrapper mCacheWrapper;
    private static ResourceManager sS;

    public static void init(Context context, ResourceRemoteWrapper remoteWrapper, ResourceCacheWrapper cacheWrapper) {
        sS = new ResourceManager(context, remoteWrapper, cacheWrapper);
    }

    public static ResourceManager getInstance() {
        return sS;
    }

    private ResourceManager(Context context, ResourceRemoteWrapper remoteWrapper, ResourceCacheWrapper cacheWrapper) {
        this.mContext = context;
        this.mRemoteWrapper = remoteWrapper;
        this.mCacheWrapper = cacheWrapper;
    }

    public boolean containsInMemoryCache(Resource resource) {
        return this.mCacheWrapper.containsInMemoryCache(resource);
    }

    public boolean containsInCache(Resource resource) {
        return this.mCacheWrapper.contains(resource);
    }

    public boolean containsInDisk(Resource resource) {
        return this.mRemoteWrapper.exists(resource);
    }

    public void removeFromDisk(Resource resource) {
        this.mRemoteWrapper.remove(resource);
    }

    public Uri getFileUri(Resource res) {
        return this.mRemoteWrapper.getFileUri(res);
    }

    public File getFile(Resource res) {
        return this.mRemoteWrapper.getFile(res.getUri());
    }

    public void addObserver(Observer observer) {
        this.mRemoteWrapper.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.mRemoteWrapper.deleteObserver(observer);
    }

    public BitmapDrawable getDrawableCache(Resource resource) {
        return this.mCacheWrapper.getFromMemoryCache(resource);
    }

    public BitmapDrawable getDrawable(Resource resource) {
        CacheableBitmapDrawable drawable2;
        block26: {
            drawable2 = null;
            drawable2 = this.mCacheWrapper.get(resource);
            if (this.mCacheWrapper.contains(resource)) {
                drawable2 = this.mCacheWrapper.get(resource);
                return drawable2;
            }
            if (resource instanceof LocalMicroResource) {
                drawable2 = this.mCacheWrapper.buildCompareBitmap((LocalMicroResource)resource);
            } else {
                if (resource instanceof LocalResource) {
                    throw new RuntimeException("NOT support use compress item");
                }
                if (resource instanceof RequestResource) {
                    if (this.mRemoteWrapper.exists(resource)) {
                        try {
                            this.mCacheWrapper.put(resource, this.mRemoteWrapper.getBitmap(resource));
                            return new BitmapDrawable(this.mContext.getResources(), this.mRemoteWrapper.getBitmap(resource));
                        }
                        catch (BaseException e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            this.mRemoteWrapper.request(resource);
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                } else if (resource instanceof CompressedResource) {
                    try {
                        CompressedResource compressedResource = (CompressedResource)resource;
                        if (compressedResource.getOriResource() instanceof LocalResource) {
                            drawable2 = this.mCacheWrapper.buildCompareBitmap(compressedResource);
                            break block26;
                        }
                        if (this.mRemoteWrapper.exists(compressedResource.getOriResource())) {
                            drawable2 = this.mCacheWrapper.buildCompareBitmap(compressedResource);
                            break block26;
                        }
                        try {
                            this.mRemoteWrapper.request(compressedResource.getOriResource());
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (this.mRemoteWrapper.exists(resource)) {
                    try {
                        this.mCacheWrapper.put(resource, this.mRemoteWrapper.getBitmap(resource));
                        return new BitmapDrawable(this.mContext.getResources(), this.mRemoteWrapper.getBitmap(resource));
                    }
                    catch (BaseException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.mRemoteWrapper.request(resource);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return drawable2;
    }

    public AbstractHttpRequest<File> requestResource(Resource resource) throws URISyntaxException {
        return this.mRemoteWrapper.request(resource);
    }

    public AbstractHttpRequest<File> requestResource(Resource resource, StoreStatusCallback callback) throws URISyntaxException {
        return this.mRemoteWrapper.request(resource, callback);
    }

    public void cancelRequest(Resource resource) {
        this.mRemoteWrapper.cancel(resource);
    }

    public BitmapDrawable getCompressBitmap(CompressedResource resource) throws IOException {
        return this.mCacheWrapper.buildCompareBitmap(resource);
    }

    public BitmapDrawable getCompressBitmap(LocalMicroResource resource) {
        return this.mCacheWrapper.buildCompareBitmap(resource);
    }

    public void compressImageToFile(CompressedResource resource, File file) throws IOException {
        this.mCacheWrapper.getCompressFile(resource, file.getPath());
    }

    public void put(Resource resource, Bitmap bitmap) {
        this.mCacheWrapper.put(resource, bitmap);
    }

    public File getCacheFile(Resource resource) {
        return this.mCacheWrapper.getFileFromDiskCache(resource);
    }

    public void put(Resource resource, InputStream stream) {
        this.mCacheWrapper.put(resource, stream);
    }
}

