/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.network.entity;

import com.sea_monster.core.exception.HttpException;
import com.sea_monster.core.exception.InternalException;
import com.sea_monster.core.network.MultipartUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.UUID;
import org.apache.http.NameValuePair;
import org.apache.http.entity.AbstractHttpEntity;

public class MultipartEntity
extends AbstractHttpEntity {
    private String mBoundary = UUID.randomUUID().toString();
    private byte[] content;
    private byte[] fileSeparator;
    private byte[] endSeparator;
    private byte[] mStream;
    private InputStream inputStream;

    public MultipartEntity(List<? extends NameValuePair> parameters, byte[] imgStream, String name, String fileName, String charset) throws HttpException {
        if (parameters != null) {
            String formDataString = null;
            try {
                formDataString = MultipartUtils.getFormDataContent(parameters, this.mBoundary);
            }
            catch (IllegalArgumentException e) {
                throw new HttpException(e);
            }
            try {
                this.content = formDataString.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new HttpException(e);
            }
        }
        try {
            this.fileSeparator = MultipartUtils.getFileSeparator(this.mBoundary, name, fileName).getBytes(charset);
            this.endSeparator = MultipartUtils.getEndSeparator(this.mBoundary).getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpException(e);
        }
        this.mStream = imgStream;
        this.setContentType(MultipartUtils.getContentType(this.mBoundary));
    }

    public MultipartEntity(List<? extends NameValuePair> parameters, String charset) throws InternalException {
        if (parameters != null) {
            try {
                String formDataString = null;
                try {
                    formDataString = MultipartUtils.getFormDataContent(parameters, this.mBoundary);
                }
                catch (IllegalArgumentException e) {
                    throw new InternalException(2003, (Throwable)e);
                }
                try {
                    this.content = formDataString.getBytes(charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new InternalException(2003, (Throwable)e);
                }
                this.endSeparator = MultipartUtils.getEndSeparator(this.mBoundary).getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        this.setContentType(MultipartUtils.getContentType(this.mBoundary));
    }

    public MultipartEntity(List<? extends NameValuePair> parameters, InputStream inputStream, String name, String fileName, String charset) throws InternalException {
        if (parameters != null) {
            String formDataString = null;
            try {
                formDataString = MultipartUtils.getFormDataContent(parameters, this.mBoundary);
            }
            catch (IllegalArgumentException e) {
                throw new InternalException(2003, (Throwable)e);
            }
            try {
                this.content = formDataString.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException(2003, (Throwable)e);
            }
        }
        try {
            this.fileSeparator = MultipartUtils.getFileSeparator(this.mBoundary, name, fileName).getBytes(charset);
            this.endSeparator = MultipartUtils.getEndSeparator(this.mBoundary).getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException(2003, (Throwable)e);
        }
        this.inputStream = inputStream;
        this.setContentType(MultipartUtils.getContentType(this.mBoundary));
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        int length = 0;
        try {
            length = this.inputStream != null ? (this.content == null ? 0 : this.content.length) + this.fileSeparator.length + this.endSeparator.length + (this.mStream == null ? 0 : this.mStream.length) + this.inputStream.available() : (this.content == null ? 0 : this.content.length) + this.endSeparator.length;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return length;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        return null;
    }

    public void writeTo(OutputStream outstream) throws IOException {
        if (this.content != null) {
            outstream.write(this.content);
        }
        if (this.fileSeparator != null && this.fileSeparator.length > 0) {
            outstream.write(this.fileSeparator);
        }
        if (this.inputStream != null) {
            if (this.mStream == null || this.mStream.length == 0) {
                int bytesRead = 0;
                byte[] buf = new byte[4096];
                while ((bytesRead = this.inputStream.read(buf)) != -1) {
                    outstream.write(buf, 0, bytesRead);
                }
            } else {
                outstream.write(this.mStream);
            }
        }
        outstream.write(this.endSeparator);
        outstream.flush();
    }

    public boolean isStreaming() {
        return false;
    }
}

