/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.network;

import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;

public class MultipartUtils {
    public static final String CONTENT_TYPE = "multipart/form-data; boundary=";
    public static final String PARAMETER_SEPARATOR = "\r\n--";

    public static String getContentType(String boundary) {
        return String.format(CONTENT_TYPE + boundary, new Object[0]);
    }

    public static boolean isEncoded(HttpEntity entity) {
        Header contentType = entity.getContentType();
        return contentType != null && contentType.getValue().equalsIgnoreCase(CONTENT_TYPE);
    }

    public static String getFormDataContent(List<? extends NameValuePair> parameters, String boundary) throws IllegalArgumentException {
        if (parameters == null || parameters.size() == 0) {
            throw new IllegalArgumentException("parameters error");
        }
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            result.append(String.format("\r\n--%1$s\r\nContent-Disposition: form-data; name=\"%2$s\"\r\n\r\n%3$s", boundary, nameValuePair.getName(), nameValuePair.getValue()));
        }
        return result.toString();
    }

    public static String getFileSeparator(String boundary, String name, String fileName) {
        return String.format("\r\n--%1$s\r\nContent-Disposition: form-data; name=\"%2$s\"; filename=\"%3$s\"\r\nContent-Type: application/octet-stream\r\n\r\n", boundary, name, fileName);
    }

    public static String getEndSeparator(String boundary) {
        return PARAMETER_SEPARATOR + boundary;
    }

    public static String getFormDataContent(String contentType, List<? extends NameValuePair> parameters, String boundary) {
        if (parameters == null || parameters.size() == 0) {
            throw new IllegalArgumentException("parameters error");
        }
        StringBuilder result = new StringBuilder();
        for (NameValuePair nameValuePair : parameters) {
            result.append(String.format("\r\n--%1$s\r\nContent-Disposition: form-data; name=\"%2$s\"\r\n\r\n%3$s\r\n\r\n%4$s", boundary, nameValuePair.getName(), nameValuePair.getValue(), boundary));
        }
        return result.toString();
    }
}

