/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.sea_monster.core.common.PriorityRunnable;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.exception.HttpException;
import com.sea_monster.core.exception.InternalException;
import com.sea_monster.core.exception.PackException;
import com.sea_monster.core.exception.ParseException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.HttpHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.BasicPooledConnAdapter;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class DefaultHttpHandler
implements HttpHandler {
    DefaultHttpClient client;
    Map<Integer, PriorityRequestRunnable<?>> requestMap = new HashMap();
    ThreadPoolExecutor executor;
    Context context;

    public DefaultHttpHandler(Context context, ThreadPoolExecutor executor) {
        this.executor = executor;
        this.context = context;
        SchemeRegistry supportedSchemes = new SchemeRegistry();
        PlainSocketFactory sf = PlainSocketFactory.getSocketFactory();
        supportedSchemes.register(new Scheme("http", (SocketFactory)sf, 80));
        supportedSchemes.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
        BasicHttpParams params = new BasicHttpParams();
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)5);
        ConnPerRouteBean bean = new ConnPerRouteBean(5);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)bean);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
        ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, supportedSchemes);
        this.client = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
    }

    protected final HttpParams createHttpParams(int networkType) {
        BasicHttpParams params = new BasicHttpParams();
        switch (networkType) {
            case 1: {
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
                break;
            }
            case 0: {
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
                break;
            }
            default: {
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
            }
        }
        return params;
    }

    protected final HttpParams createHttpParams(int networkType, String proxyUri, int port) {
        BasicHttpParams params = new BasicHttpParams();
        HttpHost host = new HttpHost(proxyUri, port);
        params.setParameter("http.route.default-proxy", (Object)host);
        switch (networkType) {
            case 1: {
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
                break;
            }
            case 0: {
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
                break;
            }
            default: {
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> int executeRequest(AbstractHttpRequest<T> request) {
        PriorityRequestRunnable<T> runnable = new PriorityRequestRunnable<T>(request);
        Map<Integer, PriorityRequestRunnable<?>> map = this.requestMap;
        synchronized (map) {
            this.requestMap.put(request.getCallId(), runnable);
        }
        if (this.executor.getQueue().size() >= 25) {
            this.executor.getRejectedExecutionHandler().rejectedExecution(runnable, this.executor);
        } else {
            this.executor.execute(runnable);
        }
        return request.getCallId();
    }

    @Override
    public void cancelRequest(AbstractHttpRequest<?> id2) {
        PriorityRequestRunnable<?> request = this.requestMap.get(id2);
        if (request != null) {
            if (request.getUriRequest() != null) {
                request.getUriRequest().abort();
            } else {
                this.executor.getQueue().remove(request);
                request.getRequest().cancelRequest(new InternalException("Request Canceled"));
            }
        }
    }

    @Override
    public void cancelRequest() {
        this.executor.getQueue().clear();
        ArrayList requests = new ArrayList();
        for (Map.Entry<Integer, PriorityRequestRunnable<?>> entry : this.requestMap.entrySet()) {
            if (entry.getValue() == null) continue;
            requests.add(entry.getValue());
        }
        for (PriorityRequestRunnable priorityRequestRunnable : requests) {
            if (priorityRequestRunnable.getUriRequest() != null) {
                priorityRequestRunnable.getUriRequest().abort();
                continue;
            }
            priorityRequestRunnable.getRequest().cancelRequest(new InternalException(2001, "Request Canceled"));
        }
        this.requestMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeRequestSync(AbstractHttpRequest<T> request) throws BaseException {
        T result;
        block35: {
            int currentNetworkType;
            HttpUriRequest uriRequest;
            int port = 0;
            String host = null;
            result = null;
            try {
                uriRequest = request.obtainRequest();
            }
            catch (InternalException e) {
                throw e;
            }
            catch (PackException e) {
                throw e;
            }
            NetworkInfo networkInfo = ((ConnectivityManager)this.context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || networkInfo.getState() != NetworkInfo.State.CONNECTED) {
                throw new InternalException(3001, uriRequest.toString());
            }
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> proxies = proxySelector.select(uriRequest.getURI());
            if (proxies != null && proxies.size() > 0) {
                for (Proxy proxy : proxies) {
                    if (proxy.address() == null || !(proxy.address() instanceof InetSocketAddress)) continue;
                    InetSocketAddress socketAddress = (InetSocketAddress)proxy.address();
                    host = socketAddress.getHostName();
                    port = socketAddress.getPort();
                    break;
                }
            }
            if ((currentNetworkType = networkInfo.getType()) == 0 && host != null && host.length() > 0 && port > 0) {
                uriRequest.setParams(this.createHttpParams(currentNetworkType, host, port));
            } else {
                uriRequest.setParams(this.createHttpParams(currentNetworkType));
            }
            if (request.getResStream() != null && currentNetworkType == 0) {
                uriRequest.getParams().setIntParameter("http.socket.timeout", 40000);
            }
            uriRequest.addHeader("Accept-Encoding", "gzip");
            BasicHttpContext context = new BasicHttpContext();
            BasicPooledConnAdapter adapter = null;
            try {
                context.setAttribute("http.authscheme-registry", (Object)this.client.getAuthSchemes());
                context.setAttribute("http.cookiespec-registry", (Object)this.client.getCookieSpecs());
                context.setAttribute("http.cookie-store", (Object)this.client.getCookieStore());
                context.setAttribute("http.auth.credentials-provider", (Object)this.client.getCredentialsProvider());
                Object response = this.client.execute(uriRequest, (HttpContext)context);
                adapter = (BasicPooledConnAdapter)context.getAttribute("http.connection");
                if (response.getStatusLine().getStatusCode() == 200) {
                    Header codingHeader;
                    long length;
                    Header lenHeader = response.getFirstHeader("Content-Length");
                    if (lenHeader != null && (length = Long.parseLong(lenHeader.getValue())) > 20000L && adapter instanceof BasicPooledConnAdapter) {
                        int timeout = 0;
                        timeout = currentNetworkType == 1 ? ((timeout = (int)(length / 10L)) > 20000 ? timeout : 20000) : ((timeout = (int)(length / 2L)) > 20000 ? timeout : 20000);
                        adapter.setSocketTimeout(timeout);
                    }
                    result = (codingHeader = response.getFirstHeader("Content-Encoding")) != null && codingHeader.getValue().equalsIgnoreCase("gzip") ? (T)request.getParser().parseGzip(response.getEntity(), request.getStatusCallback()) : (T)request.getParser().parse(response.getEntity(), request.getStatusCallback());
                    break block35;
                }
                response.getEntity().consumeContent();
                InternalException exception = new InternalException(response.getStatusLine().getStatusCode(), uriRequest.getRequestLine().toString());
                int statue = response.getStatusLine().getStatusCode();
                throw exception;
            }
            catch (ClientProtocolException e) {
                throw new HttpException(e);
            }
            catch (ConnectTimeoutException e) {
                throw new HttpException(e);
            }
            catch (ConnectException e) {
                throw new HttpException(e);
            }
            catch (SocketTimeoutException e) {
                throw new HttpException(e);
            }
            catch (SocketException e) {
                throw new HttpException(e);
            }
            catch (IOException e) {
                throw new HttpException(e);
            }
            catch (ParseException e) {
                throw e;
            }
            catch (InternalException e) {
                throw e;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw new InternalException(3001, "NullPointerException");
            }
            catch (IllegalStateException e) {
                request.onFailure(new HttpException(e));
            }
            finally {
                Map<Integer, PriorityRequestRunnable<?>> map = this.requestMap;
                synchronized (map) {
                    this.requestMap.remove(request.getCallId());
                }
                if (adapter != null) {
                    adapter.releaseConnection();
                }
                this.client.getConnectionManager().closeIdleConnections(0L, TimeUnit.SECONDS);
            }
        }
        return result;
    }

    public class PriorityRequestRunnable<T>
    extends PriorityRunnable {
        private AbstractHttpRequest<T> request;
        private HttpUriRequest uriRequest;

        public PriorityRequestRunnable(AbstractHttpRequest<T> request) {
            super(request.getPriority());
            this.request = request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            HttpResponse httpResponse;
            int currentNetworkType;
            int port = 0;
            String host = null;
            try {
                this.uriRequest = this.request.obtainRequest();
            }
            catch (InternalException e) {
                this.request.onFailure(e);
                return;
            }
            catch (PackException e) {
                this.request.onFailure(e);
                return;
            }
            NetworkInfo networkInfo = ((ConnectivityManager)DefaultHttpHandler.this.context.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo == null || networkInfo.getState() != NetworkInfo.State.CONNECTED) {
                this.request.onFailure(new InternalException(3001, this.uriRequest.toString()));
                return;
            }
            ProxySelector proxySelector = ProxySelector.getDefault();
            List<Proxy> proxies = proxySelector.select(this.uriRequest.getURI());
            if (proxies != null && proxies.size() > 0) {
                for (Proxy proxy : proxies) {
                    if (proxy.address() == null || !(proxy.address() instanceof InetSocketAddress)) continue;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
                    host = inetSocketAddress.getHostName();
                    port = inetSocketAddress.getPort();
                    break;
                }
            }
            if ((currentNetworkType = networkInfo.getType()) == 0 && host != null && host.length() > 0 && port > 0) {
                this.uriRequest.setParams(DefaultHttpHandler.this.createHttpParams(currentNetworkType, host, port));
            } else {
                this.uriRequest.setParams(DefaultHttpHandler.this.createHttpParams(currentNetworkType));
            }
            if (this.request.getResStream() != null && currentNetworkType == 0) {
                this.uriRequest.getParams().setIntParameter("http.socket.timeout", 40000);
            }
            this.uriRequest.addHeader("Accept-Encoding", "gzip");
            BasicHttpContext context = new BasicHttpContext();
            BasicPooledConnAdapter adapter = null;
            try {
                context.setAttribute("http.authscheme-registry", (Object)DefaultHttpHandler.this.client.getAuthSchemes());
                context.setAttribute("http.cookiespec-registry", (Object)DefaultHttpHandler.this.client.getCookieSpecs());
                context.setAttribute("http.cookie-store", (Object)DefaultHttpHandler.this.client.getCookieStore());
                context.setAttribute("http.auth.credentials-provider", (Object)DefaultHttpHandler.this.client.getCredentialsProvider());
                httpResponse = DefaultHttpHandler.this.client.execute(this.uriRequest, (HttpContext)context);
                adapter = (BasicPooledConnAdapter)context.getAttribute("http.connection");
                if (httpResponse.getStatusLine().getStatusCode() == 200) {
                    Header codingHeader;
                    long length;
                    Header lenHeader = httpResponse.getFirstHeader("Content-Length");
                    if (lenHeader != null && (length = Long.parseLong(lenHeader.getValue())) > 20000L && adapter instanceof BasicPooledConnAdapter) {
                        int timeout = 0;
                        timeout = currentNetworkType == 1 ? ((timeout = (int)(length / 10L)) > 20000 ? timeout : 20000) : ((timeout = (int)(length / 2L)) > 20000 ? timeout : 20000);
                        adapter.setSocketTimeout(timeout);
                    }
                    Object result = (codingHeader = httpResponse.getFirstHeader("Content-Encoding")) != null && codingHeader.getValue().equalsIgnoreCase("gzip") ? this.request.getParser().parseGzip(httpResponse.getEntity(), this.request.getStatusCallback()) : this.request.getParser().parse(httpResponse.getEntity(), this.request.getStatusCallback());
                    this.request.onComplete(result);
                    return;
                }
                if (httpResponse.getStatusLine().getStatusCode() == 301 || httpResponse.getStatusLine().getStatusCode() == 302) {
                    Header locationHeader = httpResponse.getFirstHeader("location");
                    if (locationHeader != null) {
                        String location = locationHeader.getValue();
                        System.out.println("The page was redirected to:" + location);
                        try {
                            this.request.setUri(new URI(location));
                            this.run();
                            return;
                        }
                        catch (URISyntaxException e) {
                            this.request.onFailure(new HttpException(e));
                            return;
                        }
                    }
                    System.err.println("Location field value is null.");
                    Log.e((String)"HTTP", (String)EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                    httpResponse.getEntity().consumeContent();
                    InternalException exception = new InternalException(httpResponse.getStatusLine().getStatusCode(), this.uriRequest.getRequestLine().toString());
                    int statue = httpResponse.getStatusLine().getStatusCode();
                    this.request.onFailure(exception);
                    return;
                }
                Log.e((String)"HTTP", (String)EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            }
            catch (ClientProtocolException clientProtocolException) {
                this.request.onFailure(new HttpException(clientProtocolException));
                return;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                this.request.onFailure(new HttpException(connectTimeoutException));
                return;
            }
            catch (ConnectException connectException) {
                this.request.onFailure(new HttpException(connectException));
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.request.onFailure(new HttpException(socketTimeoutException));
                return;
            }
            catch (SocketException socketException) {
                this.request.onFailure(new HttpException(socketException));
                return;
            }
            catch (IOException iOException) {
                this.request.onFailure(new HttpException(iOException));
                return;
            }
            catch (ParseException parseException) {
                this.request.onFailure(parseException);
                return;
            }
            catch (InternalException internalException) {
                int code = internalException.getGeneralCode();
                this.request.onFailure(internalException);
                return;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                this.request.onFailure(new InternalException(3001, "NullPointerException"));
                return;
            }
            catch (IllegalStateException illegalStateException) {
                this.request.onFailure(new HttpException(illegalStateException));
                return;
            }
            finally {
                Map<Integer, PriorityRequestRunnable<?>> map = DefaultHttpHandler.this.requestMap;
            }
            httpResponse.getEntity().consumeContent();
            InternalException exception = new InternalException(httpResponse.getStatusLine().getStatusCode(), this.uriRequest.getRequestLine().toString());
            int statue = httpResponse.getStatusLine().getStatusCode();
            this.request.onFailure(exception);
            return;
        }

        public AbstractHttpRequest<T> getRequest() {
            return this.request;
        }

        public HttpUriRequest getUriRequest() {
            return this.uriRequest;
        }
    }
}

