/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.network;

import android.content.Context;
import android.util.Log;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.ApiCallback;
import com.sea_monster.core.network.ApiReqeust;
import com.sea_monster.core.network.HttpHandler;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class BaseApi {
    protected HttpHandler handler;
    protected Context context;
    protected Map<WeakReference<ApiCallback>, List<AbstractHttpRequest>> callMap;

    public BaseApi(HttpHandler handler, Context context) {
        this.handler = handler;
        this.context = context;
        this.callMap = new HashMap<WeakReference<ApiCallback>, List<AbstractHttpRequest>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void recordRequest(WeakReference<ApiCallback> callback, AbstractHttpRequest request) {
        Map<WeakReference<ApiCallback>, List<AbstractHttpRequest>> map = this.callMap;
        synchronized (map) {
            if (this.callMap.containsKey(callback)) {
                this.callMap.get(callback).add(request);
            } else {
                ArrayList<AbstractHttpRequest> requests = new ArrayList<AbstractHttpRequest>();
                requests.add(request);
                this.callMap.put(callback, requests);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <T extends ApiCallback> void releaseRequest(WeakReference<T> callback, AbstractHttpRequest request) {
        Map<WeakReference<ApiCallback>, List<AbstractHttpRequest>> map = this.callMap;
        synchronized (map) {
            List<AbstractHttpRequest> callIds;
            if (callback == null) {
                Log.d((String)"Api", (String)"Null");
            }
            if ((callIds = this.callMap.get(callback)) != null && callIds.contains(request)) {
                int index = callIds.indexOf(request);
                callIds.remove(index);
                if (callIds.size() == 0) {
                    this.callMap.remove(callback);
                }
            }
        }
    }

    public void cancelReqeust(AbstractHttpRequest<?> callId) {
        this.handler.cancelRequest(callId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelReqeust(ApiCallback callback) {
        List<AbstractHttpRequest> requests = null;
        Map<WeakReference<ApiCallback>, List<AbstractHttpRequest>> map = this.callMap;
        synchronized (map) {
            for (WeakReference<ApiCallback> weakCallback : this.callMap.keySet()) {
                if (weakCallback.get() == null || weakCallback.get() != callback) continue;
                requests = this.callMap.get(weakCallback);
            }
        }
        if (requests != null && requests.size() > 0) {
            ArrayList<AbstractHttpRequest> ids = new ArrayList<AbstractHttpRequest>();
            for (AbstractHttpRequest callId : requests) {
                ids.add(callId);
            }
            for (AbstractHttpRequest request : requests) {
                this.handler.cancelRequest(request);
            }
        }
    }

    protected class DefaultApiReqeust<T extends Serializable>
    extends ApiReqeust<T> {
        private WeakReference<ApiCallback<T>> weakCallback;

        public DefaultApiReqeust(int method, URI uri, ApiCallback<T> callback) {
            super(method, uri);
            this.weakCallback = new WeakReference<ApiCallback<ApiCallback<T>>>(callback);
        }

        public DefaultApiReqeust(int method, URI uri, List<NameValuePair> params, ApiCallback<T> callback) {
            super(method, uri, params);
            this.weakCallback = new WeakReference<ApiCallback<ApiCallback<T>>>(callback);
        }

        public DefaultApiReqeust(int method, URI uri, List<NameValuePair> params, InputStream stream, ApiCallback<T> callback) {
            super(method, uri, params, stream);
            this.weakCallback = new WeakReference<ApiCallback<ApiCallback<T>>>(callback);
        }

        public DefaultApiReqeust(int method, URI uri, InputStream stream, ApiCallback<T> callback) {
            super(method, uri, stream);
            this.weakCallback = new WeakReference<ApiCallback<ApiCallback<T>>>(callback);
        }

        public DefaultApiReqeust(int method, URI uri, List<NameValuePair> params, InputStream stream, String resName, ApiCallback<T> callback) {
            super(method, uri, params, stream, resName);
            this.weakCallback = new WeakReference<ApiCallback<ApiCallback<T>>>(callback);
        }

        public DefaultApiReqeust(int method, URI uri, List<NameValuePair> params, InputStream stream, String name, String fileName, ApiCallback<T> callback) {
            super(method, uri, params, stream, name, fileName);
            this.weakCallback = new WeakReference<ApiCallback<ApiCallback<T>>>(callback);
        }

        public DefaultApiReqeust(int method, URI uri, InputStream stream, String resName, ApiCallback<T> callback) {
            super(method, uri, stream, resName);
            this.weakCallback = new WeakReference<ApiCallback<ApiCallback<T>>>(callback);
        }

        @Override
        public void onComplete(AbstractHttpRequest<T> request, T obj) {
            BaseApi.this.releaseRequest(this.weakCallback, request);
            if (this.weakCallback.get() != null && !this.weakCallback.enqueue()) {
                ((ApiCallback)this.weakCallback.get()).onComplete(request, obj);
            }
        }

        @Override
        public void onFailure(AbstractHttpRequest<T> request, BaseException e) {
            BaseApi.this.releaseRequest(this.weakCallback, request);
            if (this.weakCallback.get() != null && !this.weakCallback.enqueue()) {
                ((ApiCallback)this.weakCallback.get()).onFailure(request, e);
            }
        }
    }
}

