/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.network;

import android.util.Log;
import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.network.AbstractHttpRequest;
import com.sea_monster.core.network.ApiCallback;
import com.sea_monster.core.network.AuthType;
import com.sea_monster.core.network.packer.AbsEntityPacker;
import com.sea_monster.core.network.parser.IEntityParser;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;

public abstract class ApiReqeust<T extends Serializable>
implements ApiCallback<T> {
    private URI uri;
    private List<NameValuePair> params;
    private InputStream resStream;
    private int method;
    private String resName;
    private String fileName;
    public static final int GET_METHOD = 1;
    public static final int POST_METHOD = 2;
    public static final int PUT_METHOD = 3;

    public ApiReqeust(int method, URI uri, List<NameValuePair> params) {
        if (method == 1) {
            this.method = method;
            StringBuilder path = new StringBuilder(uri.toString());
            path.append("?");
            int i = 0;
            int n = 0;
            if (params != null) {
                n = params.size();
            }
            for (NameValuePair nameValuePair : params) {
                path.append(String.format("%1$s=%2$s", nameValuePair.getName(), URLEncoder.encode(nameValuePair.getValue())));
                if (n <= ++i) continue;
                path.append("&");
            }
            try {
                this.uri = new URI(path.toString());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            Log.d((String)"url", (String)path.toString());
            this.params = null;
        } else {
            this.method = method;
            this.uri = uri;
            this.params = params;
        }
    }

    public ApiReqeust(int method, URI uri) {
        this.method = method;
        this.uri = uri;
    }

    public ApiReqeust(int method, URI uri, List<NameValuePair> params, InputStream resStream) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.resStream = resStream;
    }

    public ApiReqeust(int method, URI uri, List<NameValuePair> params, InputStream resStream, String resName) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.resStream = resStream;
        this.resName = resName;
    }

    public ApiReqeust(int method, URI uri, List<NameValuePair> params, InputStream resStream, String name, String fileName) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.resStream = resStream;
        this.resName = name;
        this.fileName = fileName;
    }

    public ApiReqeust(int method, URI uri, InputStream resStream) {
        this.method = method;
        this.uri = uri;
        this.resStream = resStream;
    }

    public ApiReqeust(int method, URI uri, InputStream resStream, String resName) {
        this.method = method;
        this.uri = uri;
        this.resStream = resStream;
        this.resName = resName;
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public List<NameValuePair> getParams() {
        return this.params;
    }

    public void setParams(List<NameValuePair> params) {
        this.params = params;
    }

    public String getResName() {
        return this.resName;
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    public InputStream getResStream() {
        return this.resStream;
    }

    public void setResStream(InputStream resStream) {
        this.resStream = resStream;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("URI:%1$s\n", this.uri.toString()));
        int i = 0;
        for (NameValuePair pair : this.params) {
            stringBuilder.append(String.format("Params($1$d):%2$s\n", i++, pair.getValue().toString()));
        }
        return super.toString();
    }

    public AbstractHttpRequest<T> obtainRequest(IEntityParser<T> parser, AuthType consumer) {
        return this.obtainRequest(parser, consumer, false);
    }

    public AbstractHttpRequest<T> obtainRequest(IEntityParser<T> parser, final AuthType consumer, boolean isMulitPart) {
        final ApiReqeust request = this;
        AbstractHttpRequest httpRequest = new AbstractHttpRequest<T>(this.method, this.uri, this.params, 1, isMulitPart){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processReadyRequest(HttpRequest request2) {
                if (consumer != null) {
                    try {
                        AuthType authType = consumer;
                        synchronized (authType) {
                            consumer.signRequest(request2, ApiReqeust.this.params);
                        }
                    }
                    catch (InvalidKeyException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onComplete(T obj) {
                request.onComplete(this, obj);
            }

            @Override
            public void onFailure(BaseException e) {
                request.onFailure(this, e);
            }
        };
        httpRequest.setParser(parser);
        if (request.resStream != null) {
            httpRequest.setResStream(this.resStream);
        }
        if (request.resName != null) {
            httpRequest.setResName(request.resName);
        }
        if (request.fileName != null) {
            httpRequest.setFileName(request.fileName);
        }
        return httpRequest;
    }

    public AbstractHttpRequest<T> obtainRequest(IEntityParser<T> parser, AbsEntityPacker<?> packer, final AuthType consumer) {
        final ApiReqeust request = this;
        AbstractHttpRequest httpRequest = new AbstractHttpRequest<T>(this.method, this.uri, this.params, 1){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void processReadyRequest(HttpRequest request2) {
                if (consumer != null) {
                    try {
                        AuthType authType = consumer;
                        synchronized (authType) {
                            consumer.signRequest(request2, ApiReqeust.this.params);
                        }
                    }
                    catch (InvalidKeyException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchAlgorithmException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void onComplete(T obj) {
                request.onComplete(this, obj);
            }

            @Override
            public void onFailure(BaseException e) {
                request.onFailure(this, e);
            }
        };
        httpRequest.setParser(parser);
        httpRequest.setPacker(packer);
        if (request.resStream != null) {
            httpRequest.setResStream(this.resStream);
        }
        if (request.resName != null) {
            httpRequest.setResName(request.resName);
        }
        if (request.fileName != null) {
            httpRequest.setFileName(request.fileName);
        }
        return httpRequest;
    }
}

