/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.network;

import com.sea_monster.core.exception.BaseException;
import com.sea_monster.core.exception.InternalException;
import com.sea_monster.core.exception.PackException;
import com.sea_monster.core.network.HttpRequestProcess;
import com.sea_monster.core.network.StatusCallback;
import com.sea_monster.core.network.entity.GzipEntity;
import com.sea_monster.core.network.entity.MultipartEntity;
import com.sea_monster.core.network.packer.AbsEntityPacker;
import com.sea_monster.core.network.parser.IEntityParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONException;

public abstract class AbstractHttpRequest<T>
implements HttpRequestProcess<T> {
    public static final int NORMAL = 0;
    public static final int LOW = -1;
    public static final int HIGH = 1;
    private int callId;
    private int priority;
    private URI uri;
    private List<NameValuePair> params;
    private InputStream resStream;
    private boolean isMultiPart;
    private String resName;
    private String fileName;
    private int method;
    private IEntityParser<?> parser;
    private AbsEntityPacker<?> packer;
    private boolean supportGzip = false;
    private Map<String, Object> attrs;
    private StatusCallback<?> statusCallback;
    public static final int GET_METHOD = 1;
    public static final int POST_METHOD = 2;
    public static final int PUT_METHOD = 3;

    public StatusCallback<?> getStatusCallback() {
        return this.statusCallback;
    }

    public void setStatusCallback(StatusCallback<?> statusCallback) {
        this.statusCallback = statusCallback;
    }

    public boolean isSupportGzip() {
        return this.supportGzip;
    }

    public void setSupportGzip(boolean supportGzip) {
        this.supportGzip = supportGzip;
    }

    public AbstractHttpRequest(int method, URI uri, List<NameValuePair> params, int priority, boolean isMultiPart) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.callId = new Random().nextInt();
        this.priority = priority;
        this.isMultiPart = isMultiPart;
    }

    public AbstractHttpRequest(int method, URI uri, List<NameValuePair> params, IEntityParser<?> parser) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.parser = parser;
        this.callId = new Random().nextInt();
        this.priority = 0;
        this.isMultiPart = false;
    }

    public AbstractHttpRequest(int method, URI uri, List<NameValuePair> params) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.callId = new Random().nextInt();
        this.priority = 0;
        this.isMultiPart = false;
    }

    public AbstractHttpRequest(int method, URI uri, List<NameValuePair> params, IEntityParser<?> parser, int priority) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.parser = parser;
        this.callId = new Random().nextInt();
        this.priority = priority;
        this.isMultiPart = false;
    }

    public AbstractHttpRequest(int method, URI uri, List<NameValuePair> params, int priority) {
        this.method = method;
        this.uri = uri;
        this.params = params;
        this.callId = new Random().nextInt();
        this.priority = priority;
        this.isMultiPart = false;
    }

    public void cancelRequest(BaseException e) {
        this.onFailure(e);
    }

    public int getMethod() {
        return this.method;
    }

    public void setMethod(int method) {
        this.method = method;
    }

    public int getCallId() {
        return this.callId;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public List<NameValuePair> getParamsMap() {
        return this.params;
    }

    public void setParamsMap(List<NameValuePair> params) {
        this.params = params;
    }

    public IEntityParser<?> getParser() {
        return this.parser;
    }

    public void setParser(IEntityParser<?> parser) {
        this.parser = parser;
    }

    public AbsEntityPacker<?> getPacker() {
        return this.packer;
    }

    public void setPacker(AbsEntityPacker<?> packer) {
        this.packer = packer;
    }

    public void setResStream(InputStream inputStream) {
        this.resStream = inputStream;
    }

    public void setResName(String resName) {
        this.resName = resName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public InputStream getResStream() {
        return this.resStream;
    }

    public void putAttr(String name, Object obj) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, Object>();
        }
        this.attrs.put(name, obj);
    }

    public boolean containsAttr(String name) {
        if (this.attrs == null) {
            return false;
        }
        return this.attrs.containsKey(name);
    }

    public <K> K getAttr(String name) {
        if (this.attrs == null) {
            return null;
        }
        if (!this.attrs.containsKey(name)) {
            return null;
        }
        return (K)this.attrs.get(name);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("CallId:%1$d\n", this.callId));
        stringBuilder.append(String.format("URI:%1$s\n", this.uri.toString()));
        int i = 0;
        for (NameValuePair pair : this.params) {
            stringBuilder.append(String.format("Params($1$d):%2$s\n", i++, pair.getValue().toString()));
        }
        return super.toString();
    }

    public HttpUriRequest obtainRequest() throws InternalException, PackException {
        if (this.method == 1) {
            HttpGet request = new HttpGet(this.uri);
            this.processReadyRequest((HttpRequest)request);
            return request;
        }
        HttpPost request = new HttpPost(this.uri);
        this.processReadyRequest((HttpRequest)request);
        if (this.params != null && this.params.size() > 0 || this.resStream != null || this.packer != null) {
            try {
                Object entity = null;
                if (this.resStream != null) {
                    entity = this.resName != null ? (this.fileName != null ? new MultipartEntity(this.params, this.resStream, this.resName, this.fileName, "UTF-8") : new MultipartEntity(this.params, this.resStream, this.resName, "photo.jpg", "UTF-8")) : new MultipartEntity(this.params, this.resStream, "FileData", "photo.jpg", "UTF-8");
                } else if (this.packer != null) {
                    try {
                        entity = this.packer.pack();
                    }
                    catch (IOException e) {
                        throw new PackException(e);
                    }
                    catch (JSONException e) {
                        throw new PackException(e);
                    }
                } else if (this.params != null && this.params.size() > 0) {
                    entity = this.isMultiPart ? new MultipartEntity(this.params, "UTF-8") : new UrlEncodedFormEntity(this.params, "UTF-8");
                }
                if (this.supportGzip) {
                    request.setEntity((HttpEntity)new GzipEntity((HttpEntity)entity));
                } else {
                    request.setEntity(entity);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new PackException(e);
            }
            catch (InternalException e) {
                throw e;
            }
        }
        request.getParams().toString();
        return request;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public void processReadyRequest(HttpRequest request) {
    }
}

