/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.exception;

import com.sea_monster.core.exception.BaseException;
import java.util.HashMap;

public class InternalException
extends BaseException {
    public static final int NETWORK_DISABLED = 3001;
    public static final int DISCARD_TASK = 2001;
    public static final int MODEL_INCOMPLETE = 2002;
    public static final int ENTITY_BUILD_EXP = 2003;
    public static final int IMAGE_GET_FAIL = 2004;
    public static final int UNLOGIN_EXP = 2005;
    public static final int VALID_EXCEPTION_CODE = 2100;
    public static final int DEF_NETWORK_CODE = 1024;
    public static final int DEF_LOGIC_CODE = 2048;
    public static final int DEF_OTHER_CODE = 3072;
    public static final int DEF_SERVICE_CODE = 4096;
    public static final String DEFAULT_NETWORK_EXP_MESSAGE = "\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38";
    public static final String DEFAULT_LOGIC_EXP_MESSAGE = "\u64cd\u4f5c\u5931\u8d25";
    public static final String DEFAULT_OTHER_EXP_MESSAGE = "\u64cd\u4f5c\u5931\u8d25";
    public static final String DEFAULT_SERVICE_EXP_MESSAGE = "\u670d\u52a1\u5668\u5f02\u5e38";
    public static final String DEFAULT_EXP_MESSAGE = "\u64cd\u4f5c\u5931\u8d25";
    private static HashMap<Integer, String> codeMapping = new HashMap();
    private int code;
    private static final long serialVersionUID = 1L;

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public InternalException(int code, String message) {
        super(message);
        this.code = code;
    }

    public InternalException(int code, Throwable throwable) {
        super(throwable);
        this.code = code;
    }

    public InternalException(String message) {
        super(message);
    }

    @Override
    public String toString() {
        if (codeMapping.containsKey(this.code)) {
            return codeMapping.get(this.code);
        }
        if (this.code >= 0 && this.code < 1024) {
            return DEFAULT_NETWORK_EXP_MESSAGE;
        }
        if (this.code >= 1024 && this.code < 2048) {
            return "\u64cd\u4f5c\u5931\u8d25";
        }
        if (this.code >= 2048 && this.code < 3072) {
            return "\u64cd\u4f5c\u5931\u8d25";
        }
        if (this.code >= 3072 && this.code < 4096) {
            return DEFAULT_SERVICE_EXP_MESSAGE;
        }
        return "\u64cd\u4f5c\u5931\u8d25";
    }

    public int getGeneralCode() {
        if (codeMapping.containsKey(this.code)) {
            return this.code;
        }
        if (this.code >= 0 && this.code < 1024) {
            return 1024;
        }
        if (this.code >= 1024 && this.code < 2048) {
            return 2048;
        }
        if (this.code >= 2048 && this.code < 3072) {
            return 3072;
        }
        if (this.code >= 3072 && this.code < 4096) {
            return 4096;
        }
        return 0;
    }

    public boolean isSpecial() {
        return !codeMapping.containsKey(this.code);
    }

    public String getCustomErrorMessage(int specialCode, String specialMessage) {
        if (specialCode == this.code) {
            return specialMessage;
        }
        return this.toString();
    }

    static {
        codeMapping.put(400, "\u8bf7\u6c42\u65e0\u6548");
        codeMapping.put(401, "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u6ce8\u9500\u5e10\u53f7\u540e\u91cd\u65b0\u767b\u5f55");
        codeMapping.put(403, "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u6ce8\u9500\u5e10\u53f7\u540e\u91cd\u65b0\u767b\u5f55");
        codeMapping.put(404, "\u8bf7\u6c42\u5931\u8d25");
        codeMapping.put(500, "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        codeMapping.put(501, "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        codeMapping.put(502, "\u670d\u52a1\u5668\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        codeMapping.put(503, "\u670d\u52a1\u5668\u6b63\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        codeMapping.put(504, "\u670d\u52a1\u5668\u8bf7\u6c42\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        codeMapping.put(4001, "\u8bf7\u6c42\u7684\u53c2\u6570\u9519\u8bef");
        codeMapping.put(4002, "\u53d1\u5e03//\u66f4\u65b0\u5185\u5bb9\u9519\u8bef");
        codeMapping.put(4003, "XML\u89e3\u6790\u9519\u8bef");
        codeMapping.put(4004, "\u4f20\u56fe\u7247\u9519\u8bef");
        codeMapping.put(4005, "\u4e0a\u4f20\u56fe\u7247\u5927\u5c0f\u9519\u8bef");
        codeMapping.put(4007, "\u56fe\u7247\u538b\u7f29\u9519\u8bef");
        codeMapping.put(4008, "\u7528\u6237\u4e0d\u5b58\u5728");
        codeMapping.put(4010, "\u8bf7\u6c42\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        codeMapping.put(4011, "URL\u9519\u8bef");
        codeMapping.put(4012, "\u5185\u5bb9\u5305\u542b\u975e\u6cd5\u8bcd");
        codeMapping.put(4013, "\u4e0d\u80fd\u91cd\u590d\u7ed1\u5b9a\u670d\u52a1");
        codeMapping.put(40002, "\u8bf7\u6c42\u65e0\u6548");
        codeMapping.put(3001, "\u5f53\u524d\u7f51\u7edc\u4e0d\u53ef\u7528");
        codeMapping.put(2001, "\u8bf7\u6c42\u88ab\u820d\u5f03");
        codeMapping.put(2002, "\u4fdd\u5b58\u5bf9\u8c61\u4fe1\u606f\u4e0d\u5168");
        codeMapping.put(2003, "\u6d88\u606f\u4f53\u521b\u5efa\u5931\u8d25");
        codeMapping.put(2004, "\u56fe\u7247\u83b7\u53d6\u5931\u8d25");
        codeMapping.put(2005, "\u7528\u6237\u5c1a\u672a\u767b\u9646");
    }
}

