/*
 * Decompiled with CFR 0.152.
 */
package com.sea_monster.core.common;

import com.sea_monster.core.common.Observer;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class Observable {
    protected long mStatus;
    boolean mChanged = false;
    public static final byte STATIE_MASK = 3;
    public static final byte STATIE_EMPTY = 0;
    private List<Entity> mEnters = new ArrayList<Entity>(8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(byte type, Observer observer) {
        List<Entity> list = this.mEnters;
        synchronized (list) {
            int index = this.entityIndex(observer);
            if (index == -1) {
                Entity entity = new Entity();
                entity.statusMask = this.setStatus(0L, type, (byte)3);
                entity.mWeakObserver = new WeakReference<Observer>(observer);
                this.mEnters.add(entity);
            } else {
                Entity entity = this.mEnters.get(index);
                if (entity.mWeakObserver.isEnqueued()) {
                    this.mEnters.remove(index);
                    Entity newEntity = new Entity();
                    newEntity.statusMask = this.setStatus(0L, type, (byte)3);
                    newEntity.mWeakObserver = new WeakReference<Observer>(observer);
                    this.mEnters.add(newEntity);
                } else {
                    entity.statusMask = this.setStatus(entity.statusMask, type, (byte)3);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(byte type, Observer observer) {
        List<Entity> list = this.mEnters;
        synchronized (list) {
            int index = this.entityIndex(observer);
            if (index == -1) {
                return;
            }
            Entity entity = this.mEnters.get(index);
            if (entity.mWeakObserver.isEnqueued()) {
                this.mEnters.remove(index);
            } else {
                entity.statusMask = this.setStatus(entity.statusMask, type, (byte)0);
                if (entity.statusMask == 0L) {
                    this.mEnters.remove(index);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Observer observer) {
        Observer observer2 = observer;
        synchronized (observer2) {
            int index = this.entityIndex(observer);
            long allMash = -1L;
            if (index == -1) {
                Entity newEntity = new Entity();
                newEntity.mWeakObserver = new WeakReference<Observer>(observer);
                newEntity.statusMask = allMash;
                this.mEnters.add(newEntity);
            } else {
                Entity entity = this.mEnters.get(index);
                if (entity.mWeakObserver.isEnqueued()) {
                    this.mEnters.remove(index);
                    Entity newEntity = new Entity();
                    newEntity.mWeakObserver = new WeakReference<Observer>(observer);
                    newEntity.statusMask = allMash;
                    this.mEnters.add(newEntity);
                } else {
                    entity.statusMask = allMash;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Observer observer) {
        Observer observer2 = observer;
        synchronized (observer2) {
            int index = this.entityIndex(observer);
            if (index != -1) {
                this.mEnters.remove(index);
            }
        }
    }

    private final int entityIndex(Observer observer) {
        if (this.mEnters.size() == 0) {
            return -1;
        }
        int i = -1;
        for (Entity entity : this.mEnters) {
            ++i;
            if (entity.mWeakObserver.isEnqueued() || entity.mWeakObserver.get() != observer) continue;
            return i;
        }
        return -1;
    }

    public byte getCurrentStatue(int type) {
        return (byte)((this.mStatus & (long)(3 << type)) >> type);
    }

    private byte getStatus(long status, byte type) {
        return (byte)((status & (long)(3 << type)) >> type);
    }

    private long setStatus(long status, byte type, byte currentStatus) {
        status = status & (long)(~(3 << type)) | (long)(currentStatus << type);
        return status;
    }

    public boolean setCurrentStatus(byte type, byte currentStatus, Object data) {
        if (this.getCurrentStatue(type) == currentStatus) {
            return false;
        }
        this.mStatus = this.mStatus & (long)(~(3 << type)) | (long)(currentStatus << type);
        this.notifyObservers(type, currentStatus, data);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(byte type, byte status, Object data) {
        ArrayList observers = new ArrayList();
        Observable observable = this;
        synchronized (observable) {
            int index = 0;
            index = this.mEnters.size();
            while (--index >= 0) {
                Entity entity = this.mEnters.get(index);
                if (entity.mWeakObserver.get() == null || entity.mWeakObserver.isEnqueued()) {
                    this.mEnters.remove(index);
                    continue;
                }
                if (this.getStatus(entity.statusMask, type) == 0) continue;
                observers.add(entity.mWeakObserver.get());
            }
            if (observers.size() > 0) {
                for (Observer observer : observers) {
                    observer.onNotify(this, type, status, data);
                }
            }
        }
    }

    protected void clearChanged() {
        this.mChanged = false;
    }

    public boolean hasChanged() {
        return this.mChanged;
    }

    protected void setChanged() {
        this.mChanged = true;
    }

    public void printDebugInfo(PrintStream stream) {
        stream.print("CURRENT_STATUS:");
        stream.println(Long.toBinaryString(this.mStatus));
        stream.println("Observers:");
        for (Entity entity : this.mEnters) {
            stream.println(entity.toString());
        }
    }

    class Entity {
        long statusMask;
        WeakReference<Observer> mWeakObserver;

        Entity() {
        }

        public String toString() {
            return String.format("status:%1$s  Observer:%2$b %3$s", Long.toBinaryString(this.statusMask), this.mWeakObserver.isEnqueued(), this.mWeakObserver.isEnqueued() ? null : ((Observer)this.mWeakObserver.get()).toString());
        }
    }
}

