/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u5c4f\u5e55\u5c3a\u7c7b\u5e93;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.WindowManager;

public class RulerView
extends SurfaceView
implements SurfaceHolder.Callback {
    public float UNIT_MM;
    public float RULE_HEIGHT;
    public float RULE_SCALE;
    public int SCREEN_W;
    public int SCREEN_H;
    public float FONT_SIZE;
    public float PADDING;
    public float RADIUS_BIG;
    public float RADIUS_MEDIUM;
    public float RADIUS_SMALL;
    public float CYCLE_WIDTH;
    public float DISPLAY_SIZE_BIG;
    public float DISPLAY_SIZE_SMALL;
    private SurfaceHolder holder;
    boolean unlockLineCanvas = false;
    float lineX;
    float lineOffset;
    float startX;
    float lastX;
    int kedu;
    Paint paint;
    Paint linePaint;
    Paint fontPaint;

    public int getKedu() {
        return this.kedu;
    }

    public void setKedu(int n) {
        this.kedu = n;
        this.draw();
    }

    public float getLineX() {
        return this.lineX;
    }

    public void setLineX(float f) {
        this.lineX = f;
        this.draw();
    }

    private void onTouchBegain(float f, float f2) {
        this.lineOffset = Math.abs(f - this.lineX);
        if (this.lineOffset <= this.PADDING * 2.0f) {
            this.startX = f;
            this.unlockLineCanvas = true;
        }
    }

    private void onTouchMove(float f, float f2) {
        if (this.unlockLineCanvas) {
            this.lineX += f - this.startX;
            if (this.lineX < this.PADDING) {
                this.lineX = this.PADDING;
            } else if (this.lineX > this.lastX) {
                this.lineX = this.lastX;
            }
            this.kedu = Math.round((this.lineX - this.PADDING) / this.UNIT_MM);
            this.startX = f;
            this.draw();
        }
    }

    private void onTouchDone(float f, float f2) {
        this.unlockLineCanvas = false;
        this.startX = -1.0f;
        this.draw();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 1: 
            case 3: {
                this.onTouchDone(motionEvent.getX(), motionEvent.getY());
                break;
            }
            case 0: {
                this.onTouchBegain(motionEvent.getX(), motionEvent.getY());
                break;
            }
            case 2: {
                this.onTouchMove(motionEvent.getX(), motionEvent.getY());
            }
        }
        return true;
    }

    private void init(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        this.RADIUS_BIG = TypedValue.applyDimension((int)1, (float)46.0f, (DisplayMetrics)displayMetrics);
        this.RADIUS_MEDIUM = TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)displayMetrics);
        this.RADIUS_SMALL = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics);
        this.CYCLE_WIDTH = TypedValue.applyDimension((int)1, (float)4.0f, (DisplayMetrics)displayMetrics);
        this.DISPLAY_SIZE_BIG = TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)displayMetrics);
        this.DISPLAY_SIZE_SMALL = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics);
        this.UNIT_MM = TypedValue.applyDimension((int)5, (float)1.0f, (DisplayMetrics)displayMetrics);
        this.RULE_HEIGHT = TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)displayMetrics);
        this.FONT_SIZE = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics);
        this.PADDING = this.FONT_SIZE / 2.0f;
        this.SCREEN_W = displayMetrics.widthPixels;
        this.SCREEN_H = displayMetrics.heightPixels;
        this.holder = this.getHolder();
        this.holder.addCallback((SurfaceHolder.Callback)this);
        this.paint = new Paint();
        this.paint.setColor(-14763784);
        this.linePaint = new Paint();
        this.linePaint.setColor(-14763784);
        this.linePaint.setStrokeWidth(4.0f);
        this.fontPaint = new Paint();
        this.fontPaint.setTextSize(this.FONT_SIZE);
        this.fontPaint.setAntiAlias(true);
        this.fontPaint.setColor(-14763784);
        this.lineX = this.PADDING;
        this.kedu = 0;
    }

    private void drawDisplay(Canvas canvas) {
        String string = String.valueOf(this.kedu / 10);
        String string2 = String.valueOf(this.kedu % 10);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setColor(-14763784);
        paint.setTextSize(this.DISPLAY_SIZE_BIG);
        float f = paint.measureText(string);
        Rect rect = new Rect();
        paint.getTextBounds(string, 0, string.length(), rect);
        Paint paint2 = new Paint();
        paint2.setAntiAlias(true);
        paint2.setColor(-10066330);
        paint2.setTextSize(this.DISPLAY_SIZE_SMALL);
        float f2 = paint2.measureText(string2);
        Rect rect2 = new Rect();
        paint2.getTextBounds(string2, 0, string2.length(), rect2);
        canvas.drawLine(this.lineX, 0.0f, this.lineX, (float)this.SCREEN_H, this.linePaint);
        Paint paint3 = new Paint();
        paint3.setColor(-1);
        paint3.setAntiAlias(true);
        paint3.setStyle(Paint.Style.FILL);
        Paint paint4 = new Paint();
        paint4.setAntiAlias(true);
        paint4.setColor(-6710887);
        paint4.setStyle(Paint.Style.STROKE);
        paint4.setStrokeWidth(this.CYCLE_WIDTH);
        canvas.drawCircle((float)(this.SCREEN_W / 2), (float)(this.SCREEN_H / 2), this.RADIUS_BIG, paint3);
        canvas.drawCircle((float)(this.SCREEN_W / 2), (float)(this.SCREEN_H / 2), this.RADIUS_MEDIUM, paint3);
        canvas.drawCircle((float)(this.SCREEN_W / 2), (float)(this.SCREEN_H / 2), this.RADIUS_BIG, paint4);
        paint4.setColor(-10066330);
        canvas.drawCircle((float)(this.SCREEN_W / 2), (float)(this.SCREEN_H / 2), this.RADIUS_MEDIUM, paint4);
        paint4.setColor(-6710887);
        canvas.drawCircle((float)(this.SCREEN_W / 2) + this.RADIUS_BIG, (float)(this.SCREEN_H / 2), this.RADIUS_SMALL, paint3);
        canvas.drawCircle((float)(this.SCREEN_W / 2) + this.RADIUS_BIG, (float)(this.SCREEN_H / 2), this.RADIUS_SMALL, paint4);
        canvas.drawText(string, (float)(this.SCREEN_W / 2) - f / 2.0f, (float)(this.SCREEN_H / 2 + rect.height() / 2), paint);
        canvas.drawText(string2, (float)(this.SCREEN_W / 2) + this.RADIUS_BIG - f2 / 2.0f, (float)(this.SCREEN_H / 2 + rect2.height() / 2), paint2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw() {
        Canvas canvas = null;
        try {
            canvas = this.holder.lockCanvas();
            canvas.drawColor(-1);
            float f = this.PADDING;
            int n = 0;
            while ((float)this.SCREEN_W - this.PADDING - f > 0.0f) {
                Object object;
                this.RULE_SCALE = 0.5f;
                if (n % 5 == 0) {
                    if ((n & 1) == 0) {
                        this.RULE_SCALE = 1.0f;
                        object = String.valueOf(n / 10);
                        Rect rect = new Rect();
                        float f2 = this.fontPaint.measureText((String)object);
                        this.fontPaint.getTextBounds((String)object, 0, ((String)object).length(), rect);
                        canvas.drawText((String)object, f - f2 / 2.0f, this.RULE_HEIGHT + this.FONT_SIZE / 2.0f + (float)rect.height(), this.fontPaint);
                    } else {
                        this.RULE_SCALE = 0.75f;
                    }
                }
                object = new RectF();
                ((RectF)object).left = f - 1.0f;
                ((RectF)object).top = 0.0f;
                ((RectF)object).right = f + 1.0f;
                ((RectF)object).bottom = ((RectF)object).top + this.RULE_HEIGHT * this.RULE_SCALE;
                canvas.drawRect((RectF)object, this.paint);
                f += this.UNIT_MM;
                ++n;
            }
            this.lastX = f - this.UNIT_MM;
            this.drawDisplay(canvas);
        }
        catch (Exception exception) {
        }
        finally {
            if (canvas != null) {
                this.holder.unlockCanvasAndPost(canvas);
            }
        }
    }

    public RulerView(Context context) {
        super(context);
        this.init(context);
    }

    public RulerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public RulerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        new Thread(){

            @Override
            public void run() {
                RulerView.this.draw();
            }
        }.start();
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }
}

