/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE = new Timeout(){

        @Override
        public Timeout timeout(long l2, TimeUnit timeUnit) {
            return this;
        }

        @Override
        public Timeout deadline(long l2, TimeUnit timeUnit) {
            return this;
        }

        @Override
        public void throwIfReached() throws IOException {
        }
    };
    private long deadlineStart;
    private long deadlineDurationNanos = -1L;
    private long timeoutNanos = -1L;

    public Timeout timeout(long l2, TimeUnit timeUnit) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("timeout <= 0: " + l2);
        }
        this.timeoutNanos = timeUnit.toNanos(l2);
        return this;
    }

    public long getTimeoutNanos() {
        return this.timeoutNanos;
    }

    public Timeout deadline(long l2, TimeUnit timeUnit) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("duration <= 0: " + l2);
        }
        this.deadlineStart = System.nanoTime();
        this.deadlineDurationNanos = timeUnit.toNanos(l2);
        return this;
    }

    public Timeout clear() {
        this.deadlineDurationNanos = -1L;
        this.timeoutNanos = -1L;
        return this;
    }

    public void throwIfReached() throws IOException {
        long l2;
        long l3;
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
        if (this.deadlineDurationNanos != -1L && (l3 = (l2 = System.nanoTime()) - this.deadlineStart) > this.deadlineDurationNanos) {
            throw new IOException("deadline reached");
        }
    }
}

