/*
 * Decompiled with CFR 0.152.
 */
package okio;

import okio.Segment;

final class SegmentPool {
    static final SegmentPool INSTANCE = new SegmentPool();
    static final long MAX_SIZE = 65536L;
    private Segment next;
    long byteCount;

    private SegmentPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Segment take() {
        SegmentPool segmentPool = this;
        synchronized (segmentPool) {
            if (this.next != null) {
                Segment segment = this.next;
                this.next = segment.next;
                segment.next = null;
                this.byteCount -= 2048L;
                return segment;
            }
        }
        return new Segment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recycle(Segment segment) {
        if (segment.next != null || segment.prev != null) {
            throw new IllegalArgumentException();
        }
        SegmentPool segmentPool = this;
        synchronized (segmentPool) {
            if (this.byteCount + 2048L > 65536L) {
                return;
            }
            this.byteCount += 2048L;
            segment.next = this.next;
            segment.limit = 0;
            segment.pos = 0;
            this.next = segment;
        }
    }
}

