/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

final class RealBufferedSource
implements BufferedSource {
    public final Buffer buffer;
    public final Source source;
    private boolean closed;

    public RealBufferedSource(Source source, Buffer buffer) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        this.buffer = buffer;
        this.source = source;
    }

    public RealBufferedSource(Source source) {
        this(source, new Buffer());
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public long read(Buffer buffer, long l2) throws IOException {
        long l3;
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        if (this.buffer.size == 0L && (l3 = this.source.read(this.buffer, 2048L)) == -1L) {
            return -1L;
        }
        l3 = Math.min(l2, this.buffer.size);
        return this.buffer.read(buffer, l3);
    }

    @Override
    public boolean exhausted() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        return this.buffer.exhausted() && this.source.read(this.buffer, 2048L) == -1L;
    }

    @Override
    public void require(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (this.buffer.size < l2) {
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            throw new EOFException();
        }
    }

    @Override
    public byte readByte() throws IOException {
        this.require(1L);
        return this.buffer.readByte();
    }

    @Override
    public ByteString readByteString(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readByteString(l2);
    }

    @Override
    public byte[] readByteArray(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readByteArray(l2);
    }

    @Override
    public void readFully(Buffer buffer, long l2) throws IOException {
        this.require(l2);
        this.buffer.readFully(buffer, l2);
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        long l2 = 0L;
        while (this.source.read(this.buffer, 2048L) != -1L) {
            long l3 = this.buffer.completeSegmentByteCount();
            if (l3 <= 0L) continue;
            l2 += l3;
            sink.write(this.buffer, l3);
        }
        if (this.buffer.size() > 0L) {
            l2 += this.buffer.size();
            sink.write(this.buffer, this.buffer.size());
        }
        return l2;
    }

    @Override
    public String readUtf8() throws IOException {
        while (this.source.read(this.buffer, 2048L) != -1L) {
        }
        return this.buffer.readUtf8();
    }

    @Override
    public String readUtf8(long l2) throws IOException {
        this.require(l2);
        return this.buffer.readUtf8(l2);
    }

    @Override
    public String readString(Charset charset) throws IOException {
        while (this.source.read(this.buffer, 2048L) != -1L) {
        }
        return this.buffer.readString(charset);
    }

    @Override
    public String readString(long l2, Charset charset) throws IOException {
        this.require(l2);
        return this.buffer.readString(l2, charset);
    }

    @Override
    public String readUtf8Line() throws IOException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            return this.buffer.size != 0L ? this.readUtf8(this.buffer.size) : null;
        }
        return this.buffer.readUtf8Line(l2);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            throw new EOFException();
        }
        return this.buffer.readUtf8Line(l2);
    }

    @Override
    public short readShort() throws IOException {
        this.require(2L);
        return this.buffer.readShort();
    }

    @Override
    public short readShortLe() throws IOException {
        this.require(2L);
        return this.buffer.readShortLe();
    }

    @Override
    public int readInt() throws IOException {
        this.require(4L);
        return this.buffer.readInt();
    }

    @Override
    public int readIntLe() throws IOException {
        this.require(4L);
        return this.buffer.readIntLe();
    }

    @Override
    public long readLong() throws IOException {
        this.require(8L);
        return this.buffer.readLong();
    }

    @Override
    public long readLongLe() throws IOException {
        this.require(8L);
        return this.buffer.readLongLe();
    }

    @Override
    public void skip(long l2) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        while (l2 > 0L) {
            if (this.buffer.size == 0L && this.source.read(this.buffer, 2048L) == -1L) {
                throw new EOFException();
            }
            long l3 = Math.min(l2, this.buffer.size());
            this.buffer.skip(l3);
            l2 -= l3;
        }
    }

    @Override
    public long indexOf(byte by) throws IOException {
        long l2;
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        long l3 = 0L;
        while ((l2 = this.buffer.indexOf(by, l3)) == -1L) {
            l3 = this.buffer.size;
            if (this.source.read(this.buffer, 2048L) != -1L) continue;
            return -1L;
        }
        return l2;
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                long l2;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                if (RealBufferedSource.this.buffer.size == 0L && (l2 = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 2048L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.readByte() & 0xFF;
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                long l2;
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                Util.checkOffsetAndCount(byArray.length, n2, n3);
                if (RealBufferedSource.this.buffer.size == 0L && (l2 = RealBufferedSource.this.source.read(RealBufferedSource.this.buffer, 2048L)) == -1L) {
                    return -1;
                }
                return RealBufferedSource.this.buffer.read(byArray, n2, n3);
            }

            @Override
            public int available() throws IOException {
                if (RealBufferedSource.this.closed) {
                    throw new IOException("closed");
                }
                return (int)Math.min(RealBufferedSource.this.buffer.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() throws IOException {
                RealBufferedSource.this.close();
            }

            public String toString() {
                return RealBufferedSource.this + ".inputStream()";
            }
        };
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.source.close();
        this.buffer.clear();
    }

    @Override
    public Timeout timeout() {
        return this.source.timeout();
    }

    public String toString() {
        return "buffer(" + this.source + ")";
    }
}

