/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import okio.AsyncTimeout;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.RealBufferedSink;
import okio.RealBufferedSource;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public final class Okio {
    private static final Logger logger = Logger.getLogger(Okio.class.getName());

    private Okio() {
    }

    public static BufferedSource buffer(Source source) {
        return new RealBufferedSource(source);
    }

    public static BufferedSink buffer(Sink sink) {
        return new RealBufferedSink(sink);
    }

    public static Sink sink(OutputStream outputStream) {
        return Okio.sink(outputStream, new Timeout());
    }

    private static Sink sink(final OutputStream outputStream, final Timeout timeout) {
        return new Sink(){

            @Override
            public void write(Buffer buffer, long l2) throws IOException {
                Util.checkOffsetAndCount(buffer.size, 0L, l2);
                while (l2 > 0L) {
                    timeout.throwIfReached();
                    Segment segment = buffer.head;
                    int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
                    outputStream.write(segment.data, segment.pos, n2);
                    segment.pos += n2;
                    l2 -= (long)n2;
                    buffer.size -= (long)n2;
                    if (segment.pos != segment.limit) continue;
                    buffer.head = segment.pop();
                    SegmentPool.INSTANCE.recycle(segment);
                }
            }

            @Override
            public void flush() throws IOException {
                outputStream.flush();
            }

            @Override
            public void close() throws IOException {
                outputStream.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "sink(" + outputStream + ")";
            }
        };
    }

    public static Sink sink(final Socket socket) throws IOException {
        final AsyncTimeout asyncTimeout = Okio.timeout(socket);
        final Sink sink = Okio.sink(socket.getOutputStream(), asyncTimeout);
        return new Sink(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(Buffer buffer, long l2) throws IOException {
                boolean bl = false;
                asyncTimeout.enter();
                try {
                    sink.write(buffer, l2);
                    bl = true;
                }
                finally {
                    asyncTimeout.exit(bl);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flush() throws IOException {
                boolean bl = false;
                asyncTimeout.enter();
                try {
                    sink.flush();
                    bl = true;
                }
                finally {
                    asyncTimeout.exit(bl);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                boolean bl = false;
                asyncTimeout.enter();
                try {
                    sink.close();
                    bl = true;
                }
                finally {
                    asyncTimeout.exit(bl);
                }
            }

            @Override
            public Timeout timeout() {
                return asyncTimeout;
            }

            public String toString() {
                return "sink(" + socket + ")";
            }
        };
    }

    public static Source source(InputStream inputStream) {
        return Okio.source(inputStream, new Timeout());
    }

    private static Source source(final InputStream inputStream, final Timeout timeout) {
        return new Source(){

            @Override
            public long read(Buffer buffer, long l2) throws IOException {
                if (l2 < 0L) {
                    throw new IllegalArgumentException("byteCount < 0: " + l2);
                }
                timeout.throwIfReached();
                Segment segment = buffer.writableSegment(1);
                int n2 = (int)Math.min(l2, (long)(2048 - segment.limit));
                int n3 = inputStream.read(segment.data, segment.limit, n2);
                if (n3 == -1) {
                    return -1L;
                }
                segment.limit += n3;
                buffer.size += (long)n3;
                return n3;
            }

            @Override
            public void close() throws IOException {
                inputStream.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "source(" + inputStream + ")";
            }
        };
    }

    public static Source source(final Socket socket) throws IOException {
        final AsyncTimeout asyncTimeout = Okio.timeout(socket);
        final Source source = Okio.source(socket.getInputStream(), asyncTimeout);
        return new Source(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long read(Buffer buffer, long l2) throws IOException {
                boolean bl = false;
                asyncTimeout.enter();
                try {
                    long l3 = source.read(buffer, l2);
                    bl = true;
                    long l4 = l3;
                    return l4;
                }
                finally {
                    asyncTimeout.exit(bl);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                boolean bl = false;
                try {
                    source.close();
                    bl = true;
                }
                finally {
                    asyncTimeout.exit(bl);
                }
            }

            @Override
            public Timeout timeout() {
                return asyncTimeout;
            }

            public String toString() {
                return "source(" + socket + ")";
            }
        };
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected void timedOut() {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "Failed to close timed out socket " + socket, exception);
                }
            }
        };
    }
}

