/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import okio.Base64;
import okio.Util;

public final class ByteString
implements Serializable {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    private transient int hashCode;
    private transient String utf8;

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    public static ByteString of(byte ... byArray) {
        return new ByteString((byte[])byArray.clone());
    }

    public static ByteString of(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return new ByteString(byArray2);
    }

    public static ByteString encodeUtf8(String string) {
        ByteString byteString = new ByteString(string.getBytes(Util.UTF_8));
        byteString.utf8 = string;
        return byteString;
    }

    public String utf8() {
        String string = this.utf8;
        return string != null ? string : (this.utf8 = new String(this.data, Util.UTF_8));
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public static ByteString decodeBase64(String string) {
        byte[] byArray = Base64.decode(string);
        return byArray != null ? new ByteString(byArray) : null;
    }

    public String hex() {
        char[] cArray = new char[this.data.length * 2];
        int n2 = 0;
        for (byte by : this.data) {
            cArray[n2++] = HEX_DIGITS[by >> 4 & 0xF];
            cArray[n2++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    public static ByteString decodeHex(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("Unexpected hex string: " + string);
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = ByteString.decodeHexDigit(string.charAt(i2 * 2)) << 4;
            int n3 = ByteString.decodeHexDigit(string.charAt(i2 * 2 + 1));
            byArray[i2] = (byte)(n2 + n3);
        }
        return ByteString.of(byArray);
    }

    private static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c2);
    }

    public static ByteString read(InputStream inputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; i2 += n3) {
            n3 = inputStream.read(byArray, i2, n2 - i2);
            if (n3 != -1) continue;
            throw new EOFException();
        }
        return new ByteString(byArray);
    }

    public ByteString toAsciiLowercase() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            byte by = this.data[i2];
            if (by < 65 || by > 90) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i2++] = (byte)(by - -32);
            while (i2 < byArray.length) {
                by = byArray[i2];
                if (by >= 65 && by <= 90) {
                    byArray[i2] = (byte)(by - -32);
                }
                ++i2;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public ByteString toAsciiUppercase() {
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            byte by = this.data[i2];
            if (by < 97 || by > 122) continue;
            byte[] byArray = (byte[])this.data.clone();
            byArray[i2++] = (byte)(by - 32);
            while (i2 < byArray.length) {
                by = byArray[i2];
                if (by >= 97 && by <= 122) {
                    byArray[i2] = (byte)(by - 32);
                }
                ++i2;
            }
            return new ByteString(byArray);
        }
        return this;
    }

    public byte getByte(int n2) {
        return this.data[n2];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.data);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof ByteString && Arrays.equals(((ByteString)object).data, this.data);
    }

    public int hashCode() {
        int n2 = this.hashCode;
        return n2 != 0 ? n2 : (this.hashCode = Arrays.hashCode(this.data));
    }

    public String toString() {
        if (this.data.length == 0) {
            return "ByteString[size=0]";
        }
        if (this.data.length <= 16) {
            return String.format("ByteString[size=%s data=%s]", this.data.length, this.hex());
        }
        try {
            return String.format("ByteString[size=%s md5=%s]", this.data.length, ByteString.of(MessageDigest.getInstance("MD5").digest(this.data)).hex());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        int n2 = objectInputStream.readInt();
        ByteString byteString = ByteString.read(objectInputStream, n2);
        try {
            Field field = ByteString.class.getDeclaredField("data");
            field.setAccessible(true);
            field.set(this, byteString.data);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }
}

