/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Segment;
import okio.SegmentPool;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import okio.Util;

public final class Buffer
implements Cloneable,
BufferedSink,
BufferedSource {
    Segment head;
    long size;

    public long size() {
        return this.size;
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n2) {
                Buffer.this.writeByte((byte)n2);
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) {
                Buffer.this.write(byArray, n2, n3);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return this + ".outputStream()";
            }
        };
    }

    @Override
    public Buffer emitCompleteSegments() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long l2) throws EOFException {
        if (this.size < l2) {
            throw new EOFException();
        }
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                if (Buffer.this.size > 0L) {
                    return Buffer.this.readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) {
                return Buffer.this.read(byArray, n2, n3);
            }

            @Override
            public int available() {
                return (int)Math.min(Buffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".inputStream()";
            }
        };
    }

    public Buffer copyTo(OutputStream outputStream) throws IOException {
        return this.copyTo(outputStream, 0L, this.size);
    }

    public Buffer copyTo(OutputStream outputStream, long l2, long l3) throws IOException {
        Util.checkOffsetAndCount(this.size, l2, l3);
        if (l3 == 0L) {
            return this;
        }
        Segment segment = this.head;
        while (l2 >= (long)(segment.limit - segment.pos)) {
            l2 -= (long)(segment.limit - segment.pos);
            segment = segment.next;
        }
        while (l3 > 0L) {
            int n2 = (int)((long)segment.pos + l2);
            int n3 = (int)Math.min((long)(segment.limit - n2), l3);
            outputStream.write(segment.data, n2, n3);
            l3 -= (long)n3;
            l2 = 0L;
            segment = segment.next;
        }
        return this;
    }

    public Buffer writeTo(OutputStream outputStream) throws IOException {
        return this.writeTo(outputStream, this.size);
    }

    public Buffer writeTo(OutputStream outputStream, long l2) throws IOException {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        Segment segment = this.head;
        while (l2 > 0L) {
            int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
            outputStream.write(segment.data, segment.pos, n2);
            segment.pos += n2;
            this.size -= (long)n2;
            l2 -= (long)n2;
            if (segment.pos != segment.limit) continue;
            Segment segment2 = segment;
            this.head = segment = segment2.pop();
            SegmentPool.INSTANCE.recycle(segment2);
        }
        return this;
    }

    public Buffer readFrom(InputStream inputStream) throws IOException {
        this.readFrom(inputStream, Long.MAX_VALUE, true);
        return this;
    }

    public Buffer readFrom(InputStream inputStream, long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        this.readFrom(inputStream, l2, false);
        return this;
    }

    private void readFrom(InputStream inputStream, long l2, boolean bl) throws IOException {
        while (l2 > 0L || bl) {
            Segment segment = this.writableSegment(1);
            int n2 = (int)Math.min(l2, (long)(2048 - segment.limit));
            int n3 = inputStream.read(segment.data, segment.limit, n2);
            if (n3 == -1) {
                if (bl) {
                    return;
                }
                throw new EOFException();
            }
            segment.limit += n3;
            this.size += (long)n3;
            l2 -= (long)n3;
        }
    }

    public long completeSegmentByteCount() {
        long l2 = this.size;
        if (l2 == 0L) {
            return 0L;
        }
        Segment segment = this.head.prev;
        if (segment.limit < 2048) {
            l2 -= (long)(segment.limit - segment.pos);
        }
        return l2;
    }

    @Override
    public byte readByte() {
        if (this.size == 0L) {
            throw new IllegalStateException("size == 0");
        }
        Segment segment = this.head;
        int n2 = segment.pos;
        int n3 = segment.limit;
        byte[] byArray = segment.data;
        byte by = byArray[n2++];
        --this.size;
        if (n2 == n3) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n2;
        }
        return by;
    }

    public byte getByte(long l2) {
        Util.checkOffsetAndCount(this.size, l2, 1L);
        Segment segment = this.head;
        int n2;
        while (l2 >= (long)(n2 = segment.limit - segment.pos)) {
            l2 -= (long)n2;
            segment = segment.next;
        }
        return segment.data[segment.pos + (int)l2];
    }

    @Override
    public short readShort() {
        if (this.size < 2L) {
            throw new IllegalStateException("size < 2: " + this.size);
        }
        Segment segment = this.head;
        int n2 = segment.limit;
        int n3 = segment.pos;
        if (n2 - n3 < 2) {
            int n4 = (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            return (short)n4;
        }
        byte[] byArray = segment.data;
        int n5 = (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        this.size -= 2L;
        if (n3 == n2) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n3;
        }
        return (short)n5;
    }

    @Override
    public int readInt() {
        if (this.size < 4L) {
            throw new IllegalStateException("size < 4: " + this.size);
        }
        Segment segment = this.head;
        int n2 = segment.limit;
        int n3 = segment.pos;
        if (n2 - n3 < 4) {
            return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
        }
        byte[] byArray = segment.data;
        int n4 = (byArray[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        this.size -= 4L;
        if (n3 == n2) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n3;
        }
        return n4;
    }

    @Override
    public long readLong() {
        if (this.size < 8L) {
            throw new IllegalStateException("size < 8: " + this.size);
        }
        Segment segment = this.head;
        int n2 = segment.limit;
        int n3 = segment.pos;
        if (n2 - n3 < 8) {
            return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }
        byte[] byArray = segment.data;
        long l2 = ((long)byArray[n3++] & 0xFFL) << 56 | ((long)byArray[n3++] & 0xFFL) << 48 | ((long)byArray[n3++] & 0xFFL) << 40 | ((long)byArray[n3++] & 0xFFL) << 32 | ((long)byArray[n3++] & 0xFFL) << 24 | ((long)byArray[n3++] & 0xFFL) << 16 | ((long)byArray[n3++] & 0xFFL) << 8 | (long)byArray[n3++] & 0xFFL;
        this.size -= 8L;
        if (n3 == n2) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        } else {
            segment.pos = n3;
        }
        return l2;
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public ByteString readByteString(long l2) {
        return new ByteString(this.readByteArray(l2));
    }

    @Override
    public void readFully(Buffer buffer, long l2) throws IOException {
        buffer.write(this, l2);
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        long l2 = this.size();
        sink.write(this, l2);
        return l2;
    }

    @Override
    public String readUtf8() throws IOException {
        return this.readString(this.size, Util.UTF_8);
    }

    @Override
    public String readUtf8(long l2) {
        return this.readString(l2, Util.UTF_8);
    }

    @Override
    public String readString(Charset charset) throws IOException {
        return this.readString(this.size, charset);
    }

    @Override
    public String readString(long l2, Charset charset) {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l2);
        }
        if (l2 == 0L) {
            return "";
        }
        Segment segment = this.head;
        if ((long)segment.pos + l2 > (long)segment.limit) {
            return new String(this.readByteArray(l2), charset);
        }
        String string = new String(segment.data, segment.pos, (int)l2, charset);
        segment.pos = (int)((long)segment.pos + l2);
        this.size -= l2;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        }
        return string;
    }

    @Override
    public String readUtf8Line() throws IOException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            return this.size != 0L ? this.readUtf8(this.size) : null;
        }
        return this.readUtf8Line(l2);
    }

    @Override
    public String readUtf8LineStrict() throws IOException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            throw new EOFException();
        }
        return this.readUtf8Line(l2);
    }

    String readUtf8Line(long l2) {
        if (l2 > 0L && this.getByte(l2 - 1L) == 13) {
            String string = this.readUtf8(l2 - 1L);
            this.skip(2L);
            return string;
        }
        String string = this.readUtf8(l2);
        this.skip(1L);
        return string;
    }

    @Override
    public byte[] readByteArray(long l2) {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l2);
        }
        int n2 = 0;
        byte[] byArray = new byte[(int)l2];
        while ((long)n2 < l2) {
            int n3 = (int)Math.min(l2 - (long)n2, (long)(this.head.limit - this.head.pos));
            System.arraycopy(this.head.data, this.head.pos, byArray, n2, n3);
            n2 += n3;
            this.head.pos += n3;
            if (this.head.pos != this.head.limit) continue;
            Segment segment = this.head;
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        }
        this.size -= l2;
        return byArray;
    }

    int read(byte[] byArray, int n2, int n3) {
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        int n4 = Math.min(n3, segment.limit - segment.pos);
        System.arraycopy(segment.data, segment.pos, byArray, n2, n4);
        segment.pos += n4;
        this.size -= (long)n4;
        if (segment.pos == segment.limit) {
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        }
        return n4;
    }

    public void clear() {
        this.skip(this.size);
    }

    @Override
    public void skip(long l2) {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        this.size -= l2;
        while (l2 > 0L) {
            int n2 = (int)Math.min(l2, (long)(this.head.limit - this.head.pos));
            l2 -= (long)n2;
            this.head.pos += n2;
            if (this.head.pos != this.head.limit) continue;
            Segment segment = this.head;
            this.head = segment.pop();
            SegmentPool.INSTANCE.recycle(segment);
        }
    }

    @Override
    public Buffer write(ByteString byteString) {
        return this.write(byteString.data, 0, byteString.data.length);
    }

    @Override
    public Buffer writeUtf8(String string) {
        return this.writeString(string, Util.UTF_8);
    }

    @Override
    public Buffer writeString(String string, Charset charset) {
        byte[] byArray = string.getBytes(charset);
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public Buffer write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    @Override
    public Buffer write(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        while (n2 < n4) {
            Segment segment = this.writableSegment(1);
            int n5 = Math.min(n4 - n2, 2048 - segment.limit);
            System.arraycopy(byArray, n2, segment.data, segment.limit, n5);
            n2 += n5;
            segment.limit += n5;
        }
        this.size += (long)n3;
        return this;
    }

    @Override
    public long writeAll(Source source) throws IOException {
        long l2;
        long l3 = 0L;
        while ((l2 = source.read(this, 2048L)) != -1L) {
            l3 += l2;
        }
        return l3;
    }

    @Override
    public Buffer writeByte(int n2) {
        Segment segment = this.writableSegment(1);
        segment.data[segment.limit++] = (byte)n2;
        ++this.size;
        return this;
    }

    @Override
    public Buffer writeShort(int n2) {
        Segment segment = this.writableSegment(2);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 & 0xFF);
        segment.limit = n3;
        this.size += 2L;
        return this;
    }

    @Override
    public Buffer writeShortLe(int n2) {
        return this.writeShort(Util.reverseBytesShort((short)n2));
    }

    @Override
    public Buffer writeInt(int n2) {
        Segment segment = this.writableSegment(4);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 & 0xFF);
        segment.limit = n3;
        this.size += 4L;
        return this;
    }

    @Override
    public Buffer writeIntLe(int n2) {
        return this.writeInt(Util.reverseBytesInt(n2));
    }

    @Override
    public Buffer writeLong(long l2) {
        Segment segment = this.writableSegment(8);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        byArray[n2++] = (byte)(l2 >>> 56 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 48 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 40 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 32 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 24 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 16 & 0xFFL);
        byArray[n2++] = (byte)(l2 >>> 8 & 0xFFL);
        byArray[n2++] = (byte)(l2 & 0xFFL);
        segment.limit = n2;
        this.size += 8L;
        return this;
    }

    @Override
    public Buffer writeLongLe(long l2) {
        return this.writeLong(Util.reverseBytesLong(l2));
    }

    Segment writableSegment(int n2) {
        if (n2 < 1 || n2 > 2048) {
            throw new IllegalArgumentException();
        }
        if (this.head == null) {
            this.head.next = this.head.prev = (this.head = SegmentPool.INSTANCE.take());
            return this.head.prev;
        }
        Segment segment = this.head.prev;
        if (segment.limit + n2 > 2048) {
            segment = segment.push(SegmentPool.INSTANCE.take());
        }
        return segment;
    }

    @Override
    public void write(Buffer buffer, long l2) {
        if (buffer == this) {
            throw new IllegalArgumentException("source == this");
        }
        Util.checkOffsetAndCount(buffer.size, 0L, l2);
        while (l2 > 0L) {
            Segment segment;
            if (l2 < (long)(buffer.head.limit - buffer.head.pos)) {
                Segment segment2 = segment = this.head != null ? this.head.prev : null;
                if (segment == null || l2 + (long)(segment.limit - segment.pos) > 2048L) {
                    buffer.head = buffer.head.split((int)l2);
                } else {
                    buffer.head.writeTo(segment, (int)l2);
                    buffer.size -= l2;
                    this.size += l2;
                    return;
                }
            }
            segment = buffer.head;
            long l3 = segment.limit - segment.pos;
            buffer.head = segment.pop();
            if (this.head == null) {
                this.head.next = this.head.prev = (this.head = segment);
            } else {
                Segment segment3 = this.head.prev;
                segment3 = segment3.push(segment);
                segment3.compact();
            }
            buffer.size -= l3;
            this.size += l3;
            l2 -= l3;
        }
    }

    @Override
    public long read(Buffer buffer, long l2) {
        if (this.size == 0L) {
            return -1L;
        }
        if (l2 > this.size) {
            l2 = this.size;
        }
        buffer.write(this, l2);
        return l2;
    }

    @Override
    public long indexOf(byte by) {
        return this.indexOf(by, 0L);
    }

    public long indexOf(byte by, long l2) {
        Segment segment = this.head;
        if (segment == null) {
            return -1L;
        }
        long l3 = 0L;
        do {
            int n2;
            if (l2 >= (long)(n2 = segment.limit - segment.pos)) {
                l2 -= (long)n2;
            } else {
                byte[] byArray = segment.data;
                long l4 = segment.limit;
                for (long i2 = (long)segment.pos + l2; i2 < l4; ++i2) {
                    if (byArray[(int)i2] != by) continue;
                    return l3 + i2 - (long)segment.pos;
                }
                l2 = 0L;
            }
            l3 += (long)n2;
        } while ((segment = segment.next) != this.head);
        return -1L;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    List<Integer> segmentSizes() {
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(this.head.limit - this.head.pos);
        Segment segment = this.head.next;
        while (segment != this.head) {
            arrayList.add(segment.limit - segment.pos);
            segment = segment.next;
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        long l2;
        if (!(object instanceof Buffer)) {
            return false;
        }
        Buffer buffer = (Buffer)object;
        if (this.size != buffer.size) {
            return false;
        }
        if (this.size == 0L) {
            return true;
        }
        Segment segment = this.head;
        Segment segment2 = buffer.head;
        int n2 = segment.pos;
        int n3 = segment2.pos;
        for (long i2 = 0L; i2 < this.size; i2 += l2) {
            l2 = Math.min(segment.limit - n2, segment2.limit - n3);
            int n4 = 0;
            while ((long)n4 < l2) {
                if (segment.data[n2++] != segment2.data[n3++]) {
                    return false;
                }
                ++n4;
            }
            if (n2 == segment.limit) {
                segment = segment.next;
                n2 = segment.pos;
            }
            if (n3 != segment2.limit) continue;
            segment2 = segment2.next;
            n3 = segment2.pos;
        }
        return true;
    }

    public int hashCode() {
        Segment segment = this.head;
        if (segment == null) {
            return 0;
        }
        int n2 = 1;
        do {
            int n3 = segment.limit;
            for (int i2 = segment.pos; i2 < n3; ++i2) {
                n2 = 31 * n2 + segment.data[i2];
            }
        } while ((segment = segment.next) != this.head);
        return n2;
    }

    public String toString() {
        if (this.size == 0L) {
            return "Buffer[size=0]";
        }
        if (this.size <= 16L) {
            ByteString byteString = this.clone().readByteString(this.size);
            return String.format("Buffer[size=%s data=%s]", this.size, byteString.hex());
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(this.head.data, this.head.pos, this.head.limit - this.head.pos);
            Segment segment = this.head.next;
            while (segment != this.head) {
                messageDigest.update(segment.data, segment.pos, segment.limit - segment.pos);
                segment = segment.next;
            }
            return String.format("Buffer[size=%s md5=%s]", this.size, ByteString.of(messageDigest.digest()).hex());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    public Buffer clone() {
        Buffer buffer = new Buffer();
        if (this.size == 0L) {
            return buffer;
        }
        buffer.write(this.head.data, this.head.pos, this.head.limit - this.head.pos);
        Segment segment = this.head.next;
        while (segment != this.head) {
            buffer.write(segment.data, segment.pos, segment.limit - segment.pos);
            segment = segment.next;
        }
        return buffer;
    }
}

