/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.io.IOException;
import okio.Timeout;

class AsyncTimeout
extends Timeout {
    private static AsyncTimeout head;
    private boolean inQueue;
    private AsyncTimeout next;
    private long timeoutAt;

    AsyncTimeout() {
    }

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long l2 = this.getTimeoutNanos();
        if (l2 == -1L) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout(this, l2);
    }

    private static synchronized void scheduleTimeout(AsyncTimeout asyncTimeout, long l2) {
        if (head == null) {
            head = new AsyncTimeout();
            new Watchdog().start();
        }
        long l3 = System.nanoTime();
        asyncTimeout.timeoutAt = l3 + l2;
        long l4 = asyncTimeout.remainingNanos(l3);
        AsyncTimeout asyncTimeout2 = head;
        while (true) {
            if (asyncTimeout2.next == null || l4 < asyncTimeout2.next.remainingNanos(l3)) {
                asyncTimeout.next = asyncTimeout2.next;
                asyncTimeout2.next = asyncTimeout;
                if (asyncTimeout2 != head) break;
                AsyncTimeout.class.notify();
                break;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    public final void exit(boolean bl) throws IOException {
        boolean bl2 = this.exit();
        if (bl2 && bl) {
            throw new IOException("timeout");
        }
    }

    private static synchronized boolean cancelScheduledTimeout(AsyncTimeout asyncTimeout) {
        AsyncTimeout asyncTimeout2 = head;
        while (asyncTimeout2 != null) {
            if (asyncTimeout2.next == asyncTimeout) {
                asyncTimeout2.next = asyncTimeout.next;
                asyncTimeout.next = null;
                return false;
            }
            asyncTimeout2 = asyncTimeout2.next;
        }
        return true;
    }

    protected long remainingNanos(long l2) {
        return this.timeoutAt - l2;
    }

    protected void timedOut() {
    }

    public static synchronized AsyncTimeout awaitTimeout() throws InterruptedException {
        AsyncTimeout asyncTimeout = AsyncTimeout.head.next;
        if (asyncTimeout == null) {
            AsyncTimeout.class.wait();
            return null;
        }
        long l2 = asyncTimeout.remainingNanos(System.nanoTime());
        if (l2 > 0L) {
            long l3 = l2 / 1000000L;
            AsyncTimeout.class.wait(l3, (int)(l2 -= l3 * 1000000L));
            return null;
        }
        AsyncTimeout.head.next = asyncTimeout.next;
        asyncTimeout.next = null;
        return asyncTimeout;
    }

    private static final class Watchdog
    extends Thread {
        public Watchdog() {
            super("Okio Watchdog");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        AsyncTimeout asyncTimeout;
                        if ((asyncTimeout = AsyncTimeout.awaitTimeout()) == null) {
                            continue;
                        }
                        asyncTimeout.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

