/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireType;
import java.io.IOException;

public final class WireOutput {
    private final byte[] buffer;
    private final int limit;
    private int position;

    public static int int32Size(int n2) {
        if (n2 >= 0) {
            return WireOutput.varint32Size(n2);
        }
        return 10;
    }

    public static int int64Size(long l2) {
        if (l2 >= 0L) {
            return WireOutput.varint64Size(l2);
        }
        return 10;
    }

    public static int tagSize(int n2, WireType wireType) {
        return WireOutput.int32Size(WireOutput.makeTag(n2, wireType));
    }

    public static int messageSize(int n2, int n3) {
        return WireOutput.tagSize(n2, WireType.LENGTH_DELIMITED) + WireOutput.int32Size(n3) + n3;
    }

    public static int writeTag(int n2, WireType wireType, byte[] byArray, int n3) {
        return WireOutput.writeVarint(WireOutput.makeTag(n2, wireType), byArray, n3);
    }

    public static int writeVarint(long l2, byte[] byArray, int n2) {
        int n3 = n2;
        while (true) {
            if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                byArray[n2++] = (byte)l2;
                return n2 - n3;
            }
            byArray[n2++] = (byte)(l2 & 0x7FL | 0x80L);
            l2 >>>= 7;
        }
    }

    public static int messageHeaderSize(int n2, int n3) {
        return WireOutput.tagSize(n2, WireType.LENGTH_DELIMITED) + WireOutput.int32Size(n3);
    }

    public static int writeMessageHeader(int n2, byte[] byArray, int n3, int n4) {
        int n5 = n3;
        n3 += WireOutput.writeTag(n2, WireType.LENGTH_DELIMITED, byArray, n3);
        n3 += WireOutput.writeVarint(n4, byArray, n3);
        return n3 - n5;
    }

    public static int makeTag(int n2, WireType wireType) {
        return n2 << 3 | wireType.value();
    }

    private WireOutput(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.position = n2;
        this.limit = n2 + n3;
    }

    static WireOutput newInstance(byte[] byArray) {
        return WireOutput.newInstance(byArray, 0, byArray.length);
    }

    static WireOutput newInstance(byte[] byArray, int n2, int n3) {
        return new WireOutput(byArray, n2, n3);
    }

    static int varintTagSize(int n2) {
        return WireOutput.varint32Size(WireOutput.makeTag(n2, WireType.VARINT));
    }

    static int varint32Size(int n2) {
        if ((n2 & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n2 & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n2 & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n2 & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    static int varint64Size(long l2) {
        if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l2 & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l2 & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l2 & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l2 & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l2 & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l2 & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l2 & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l2 & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    void writeRawByte(byte by) throws IOException {
        if (this.position == this.limit) {
            throw new IOException("Out of space: position=" + this.position + ", limit=" + this.limit);
        }
        this.buffer[this.position++] = by;
    }

    void writeRawByte(int n2) throws IOException {
        this.writeRawByte((byte)n2);
    }

    void writeRawBytes(byte[] byArray) throws IOException {
        this.writeRawBytes(byArray, 0, byArray.length);
    }

    void writeRawBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.limit - this.position >= n3) {
            System.arraycopy(byArray, n2, this.buffer, this.position, n3);
            this.position += n3;
        } else {
            throw new IOException("Out of space: position=" + this.position + ", limit=" + this.limit);
        }
    }

    void writeTag(int n2, WireType wireType) throws IOException {
        this.writeVarint32(WireOutput.makeTag(n2, wireType));
    }

    void writeSignedVarint32(int n2) throws IOException {
        if (n2 >= 0) {
            this.writeVarint32(n2);
        } else {
            this.writeVarint64(n2);
        }
    }

    void writeVarint32(int n2) throws IOException {
        while (true) {
            if ((n2 & 0xFFFFFF80) == 0) {
                this.writeRawByte(n2);
                return;
            }
            this.writeRawByte(n2 & 0x7F | 0x80);
            n2 >>>= 7;
        }
    }

    void writeVarint64(long l2) throws IOException {
        while (true) {
            if ((l2 & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)l2);
                return;
            }
            this.writeRawByte((int)l2 & 0x7F | 0x80);
            l2 >>>= 7;
        }
    }

    void writeFixed32(int n2) throws IOException {
        this.writeRawByte(n2 & 0xFF);
        this.writeRawByte(n2 >> 8 & 0xFF);
        this.writeRawByte(n2 >> 16 & 0xFF);
        this.writeRawByte(n2 >> 24 & 0xFF);
    }

    void writeFixed64(long l2) throws IOException {
        this.writeRawByte((int)l2 & 0xFF);
        this.writeRawByte((int)(l2 >> 8) & 0xFF);
        this.writeRawByte((int)(l2 >> 16) & 0xFF);
        this.writeRawByte((int)(l2 >> 24) & 0xFF);
        this.writeRawByte((int)(l2 >> 32) & 0xFF);
        this.writeRawByte((int)(l2 >> 40) & 0xFF);
        this.writeRawByte((int)(l2 >> 48) & 0xFF);
        this.writeRawByte((int)(l2 >> 56) & 0xFF);
    }

    static int zigZag32(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    static long zigZag64(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }
}

