/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireType;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

final class WireInput {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String ENCOUNTERED_A_NEGATIVE_SIZE = "Encountered a negative size";
    private static final String INPUT_ENDED_UNEXPECTEDLY = "The input ended unexpectedly in the middle of a field";
    private static final String PROTOCOL_MESSAGE_CONTAINED_AN_INVALID_TAG_ZERO = "Protocol message contained an invalid tag (zero).";
    private static final String PROTOCOL_MESSAGE_END_GROUP_TAG_DID_NOT_MATCH_EXPECTED_TAG = "Protocol message end-group tag did not match expected tag.";
    private static final String ENCOUNTERED_A_MALFORMED_VARINT = "WireInput encountered a malformed varint.";
    private final BufferedSource source;
    private int pos = 0;
    private int currentLimit = Integer.MAX_VALUE;
    public static final int RECURSION_LIMIT = 64;
    public int recursionDepth;
    private int lastTag;

    public static WireInput newInstance(byte[] byArray) {
        return new WireInput(new Buffer().write(byArray));
    }

    public static WireInput newInstance(byte[] byArray, int n2, int n3) {
        return new WireInput(new Buffer().write(byArray, n2, n3));
    }

    public static WireInput newInstance(InputStream inputStream) {
        return new WireInput(Okio.buffer(Okio.source(inputStream)));
    }

    public static WireInput newInstance(Source source) {
        return new WireInput(Okio.buffer(source));
    }

    public int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readVarint32();
        if (this.lastTag == 0) {
            throw new IOException(PROTOCOL_MESSAGE_CONTAINED_AN_INVALID_TAG_ZERO);
        }
        return this.lastTag;
    }

    public void checkLastTagWas(int n2) throws IOException {
        if (this.lastTag != n2) {
            throw new IOException(PROTOCOL_MESSAGE_END_GROUP_TAG_DID_NOT_MATCH_EXPECTED_TAG);
        }
    }

    public String readString() throws IOException {
        int n2 = this.readVarint32();
        this.pos += n2;
        return this.source.readString(n2, UTF_8);
    }

    public ByteString readBytes() throws IOException {
        int n2 = this.readVarint32();
        return this.readBytes(n2);
    }

    public ByteString readBytes(int n2) throws IOException {
        this.pos += n2;
        this.source.require(n2);
        return this.source.readByteString(n2);
    }

    public int readVarint32() throws IOException {
        ++this.pos;
        byte by = this.source.readByte();
        if (by >= 0) {
            return by;
        }
        int n2 = by & 0x7F;
        ++this.pos;
        by = this.source.readByte();
        if (by >= 0) {
            n2 |= by << 7;
        } else {
            n2 |= (by & 0x7F) << 7;
            ++this.pos;
            by = this.source.readByte();
            if (by >= 0) {
                n2 |= by << 14;
            } else {
                n2 |= (by & 0x7F) << 14;
                ++this.pos;
                by = this.source.readByte();
                if (by >= 0) {
                    n2 |= by << 21;
                } else {
                    n2 |= (by & 0x7F) << 21;
                    ++this.pos;
                    by = this.source.readByte();
                    n2 |= by << 28;
                    if (by < 0) {
                        for (int i2 = 0; i2 < 5; ++i2) {
                            ++this.pos;
                            if (this.source.readByte() < 0) continue;
                            return n2;
                        }
                        throw new IOException(ENCOUNTERED_A_MALFORMED_VARINT);
                    }
                }
            }
        }
        return n2;
    }

    public long readVarint64() throws IOException {
        long l2 = 0L;
        for (int i2 = 0; i2 < 64; i2 += 7) {
            ++this.pos;
            byte by = this.source.readByte();
            l2 |= (long)(by & 0x7F) << i2;
            if ((by & 0x80) != 0) continue;
            return l2;
        }
        throw new IOException(ENCOUNTERED_A_MALFORMED_VARINT);
    }

    public int readFixed32() throws IOException {
        this.pos += 4;
        return this.source.readIntLe();
    }

    public long readFixed64() throws IOException {
        this.pos += 8;
        return this.source.readLongLe();
    }

    public static int decodeZigZag32(int n2) {
        return n2 >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long l2) {
        return l2 >>> 1 ^ -(l2 & 1L);
    }

    private WireInput(BufferedSource bufferedSource) {
        this.source = bufferedSource;
    }

    public int pushLimit(int n2) throws IOException {
        if (n2 < 0) {
            throw new IOException(ENCOUNTERED_A_NEGATIVE_SIZE);
        }
        int n3 = this.currentLimit;
        if ((n2 += this.pos) > n3) {
            throw new EOFException(INPUT_ENDED_UNEXPECTEDLY);
        }
        this.currentLimit = n2;
        return n3;
    }

    public void popLimit(int n2) {
        this.currentLimit = n2;
    }

    private boolean isAtEnd() throws IOException {
        if (this.getPosition() == (long)this.currentLimit) {
            return true;
        }
        return this.source.exhausted();
    }

    public long getPosition() {
        return this.pos;
    }

    public void skipGroup() throws IOException {
        int n2;
        while ((n2 = this.readTag()) != 0 && !this.skipField(n2)) {
        }
    }

    private boolean skipField(int n2) throws IOException {
        switch (WireType.valueOf(n2)) {
            case VARINT: {
                this.readVarint64();
                return false;
            }
            case FIXED32: {
                this.readFixed32();
                return false;
            }
            case FIXED64: {
                this.readFixed64();
                return false;
            }
            case LENGTH_DELIMITED: {
                this.skip(this.readVarint32());
                return false;
            }
            case START_GROUP: {
                this.skipGroup();
                this.checkLastTagWas(n2 & 0xFFFFFFF8 | WireType.END_GROUP.value());
                return false;
            }
            case END_GROUP: {
                return true;
            }
        }
        throw new AssertionError();
    }

    private void skip(long l2) throws IOException {
        this.pos = (int)((long)this.pos + l2);
        this.source.skip(l2);
    }
}

