/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.BuilderAdapter;
import com.squareup.wire.EnumAdapter;
import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionRegistry;
import com.squareup.wire.Message;
import com.squareup.wire.MessageAdapter;
import com.squareup.wire.Preconditions;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.WireInput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.Source;

public final class Wire {
    private final Map<Class<? extends Message>, MessageAdapter<? extends Message>> messageAdapters = new LinkedHashMap<Class<? extends Message>, MessageAdapter<? extends Message>>();
    private final Map<Class<? extends Message.Builder>, BuilderAdapter<? extends Message.Builder>> builderAdapters = new LinkedHashMap<Class<? extends Message.Builder>, BuilderAdapter<? extends Message.Builder>>();
    private final Map<Class<? extends ProtoEnum>, EnumAdapter<? extends ProtoEnum>> enumAdapters = new LinkedHashMap<Class<? extends ProtoEnum>, EnumAdapter<? extends ProtoEnum>>();
    final ExtensionRegistry registry = new ExtensionRegistry();

    public Wire(Class<?> ... classArray) {
        this(Arrays.asList(classArray));
    }

    public Wire(List<Class<?>> list) {
        for (Class<?> clazz : list) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getType().equals(Extension.class)) continue;
                try {
                    Extension extension = (Extension)field.get(null);
                    this.registry.add(extension);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError((Object)illegalAccessException);
                }
            }
        }
    }

    synchronized <M extends Message> MessageAdapter<M> messageAdapter(Class<M> clazz) {
        MessageAdapter<Message> messageAdapter = this.messageAdapters.get(clazz);
        if (messageAdapter == null) {
            messageAdapter = new MessageAdapter<M>(this, clazz);
            this.messageAdapters.put(clazz, messageAdapter);
        }
        return messageAdapter;
    }

    synchronized <B extends Message.Builder> BuilderAdapter<B> builderAdapter(Class<B> clazz) {
        BuilderAdapter<Message.Builder<Object>> builderAdapter = this.builderAdapters.get(clazz);
        if (builderAdapter == null) {
            builderAdapter = new BuilderAdapter<B>(clazz);
            this.builderAdapters.put(clazz, builderAdapter);
        }
        return builderAdapter;
    }

    synchronized <E extends ProtoEnum> EnumAdapter<E> enumAdapter(Class<E> clazz) {
        EnumAdapter<ProtoEnum> enumAdapter = this.enumAdapters.get(clazz);
        if (enumAdapter == null) {
            enumAdapter = new EnumAdapter<E>(clazz);
            this.enumAdapters.put(clazz, enumAdapter);
        }
        return enumAdapter;
    }

    public <M extends Message> M parseFrom(byte[] byArray, Class<M> clazz) throws IOException {
        Preconditions.checkNotNull(byArray, "bytes");
        Preconditions.checkNotNull(clazz, "messageClass");
        return this.parseFrom(WireInput.newInstance(byArray), clazz);
    }

    public <M extends Message> M parseFrom(byte[] byArray, int n2, int n3, Class<M> clazz) throws IOException {
        Preconditions.checkNotNull(byArray, "bytes");
        Preconditions.checkArgument(n2 >= 0, "offset < 0");
        Preconditions.checkArgument(n3 >= 0, "count < 0");
        Preconditions.checkArgument(n2 + n3 <= byArray.length, "offset + count > bytes");
        Preconditions.checkNotNull(clazz, "messageClass");
        return this.parseFrom(WireInput.newInstance(byArray, n2, n3), clazz);
    }

    public <M extends Message> M parseFrom(InputStream inputStream, Class<M> clazz) throws IOException {
        Preconditions.checkNotNull(inputStream, "input");
        Preconditions.checkNotNull(clazz, "messageClass");
        return this.parseFrom(WireInput.newInstance(inputStream), clazz);
    }

    public <M extends Message> M parseFrom(Source source, Class<M> clazz) throws IOException {
        Preconditions.checkNotNull(source, "input");
        Preconditions.checkNotNull(clazz, "messageClass");
        return this.parseFrom(WireInput.newInstance(source), clazz);
    }

    private <M extends Message> M parseFrom(WireInput wireInput, Class<M> clazz) throws IOException {
        MessageAdapter<M> messageAdapter = this.messageAdapter(clazz);
        return messageAdapter.read(wireInput);
    }

    public static <T> T get(T t, T t2) {
        return t != null ? t : t2;
    }
}

