/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.WireOutput;
import com.squareup.wire.WireType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import okio.ByteString;

final class UnknownFieldMap {
    Map<Integer, List<FieldValue>> fieldMap;

    UnknownFieldMap() {
    }

    UnknownFieldMap(UnknownFieldMap unknownFieldMap) {
        if (unknownFieldMap.fieldMap != null) {
            this.ensureFieldMap().putAll(unknownFieldMap.fieldMap);
        }
    }

    void addVarint(int n2, Long l2) throws IOException {
        this.addElement(this.ensureFieldMap(), n2, l2, WireType.VARINT);
    }

    void addFixed32(int n2, Integer n3) throws IOException {
        this.addElement(this.ensureFieldMap(), n2, n3, WireType.FIXED32);
    }

    void addFixed64(int n2, Long l2) throws IOException {
        this.addElement(this.ensureFieldMap(), n2, l2, WireType.FIXED64);
    }

    void addLengthDelimited(int n2, ByteString byteString) throws IOException {
        this.addElement(this.ensureFieldMap(), n2, byteString, WireType.LENGTH_DELIMITED);
    }

    private Map<Integer, List<FieldValue>> ensureFieldMap() {
        if (this.fieldMap == null) {
            this.fieldMap = new TreeMap<Integer, List<FieldValue>>();
        }
        return this.fieldMap;
    }

    private <T> void addElement(Map<Integer, List<FieldValue>> map, int n2, T t, WireType wireType) throws IOException {
        FieldValue fieldValue;
        List<FieldValue> list = map.get(n2);
        if (list == null) {
            list = new ArrayList<FieldValue>();
            map.put(n2, list);
        }
        switch (wireType) {
            case VARINT: {
                fieldValue = FieldValue.varint(n2, (Long)t);
                break;
            }
            case FIXED32: {
                fieldValue = FieldValue.fixed32(n2, (Integer)t);
                break;
            }
            case FIXED64: {
                fieldValue = FieldValue.fixed64(n2, (Long)t);
                break;
            }
            case LENGTH_DELIMITED: {
                fieldValue = FieldValue.lengthDelimited(n2, (ByteString)t);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported wireType = " + (Object)((Object)wireType));
            }
        }
        if (list.size() > 0 && list.get(0).getWireType() != fieldValue.getWireType()) {
            throw new IOException(String.format("Wire type %s differs from previous type %s for tag %s", new Object[]{fieldValue.getWireType(), list.get(0).getWireType(), n2}));
        }
        list.add(fieldValue);
    }

    int getSerializedSize() {
        int n2 = 0;
        if (this.fieldMap != null) {
            for (Map.Entry<Integer, List<FieldValue>> entry : this.fieldMap.entrySet()) {
                n2 += WireOutput.varintTagSize(entry.getKey());
                for (FieldValue fieldValue : entry.getValue()) {
                    n2 += fieldValue.getSerializedSize();
                }
            }
        }
        return n2;
    }

    void write(WireOutput wireOutput) throws IOException {
        if (this.fieldMap != null) {
            for (Map.Entry<Integer, List<FieldValue>> entry : this.fieldMap.entrySet()) {
                int n2 = entry.getKey();
                for (FieldValue fieldValue : entry.getValue()) {
                    fieldValue.write(n2, wireOutput);
                }
            }
        }
    }

    static final class LengthDelimitedFieldValue
    extends FieldValue {
        private final ByteString value;

        public LengthDelimitedFieldValue(int n2, ByteString byteString) {
            super(n2, WireType.LENGTH_DELIMITED);
            this.value = byteString;
        }

        @Override
        public int getSerializedSize() {
            return WireOutput.varint32Size(this.value.size()) + this.value.size();
        }

        @Override
        public void write(int n2, WireOutput wireOutput) throws IOException {
            wireOutput.writeTag(n2, WireType.LENGTH_DELIMITED);
            wireOutput.writeVarint32(this.value.size());
            wireOutput.writeRawBytes(this.value.toByteArray());
        }

        @Override
        public ByteString getAsBytes() {
            return this.value;
        }
    }

    static final class Fixed64FieldValue
    extends FieldValue {
        private final Long value;

        public Fixed64FieldValue(int n2, Long l2) {
            super(n2, WireType.FIXED64);
            this.value = l2;
        }

        @Override
        public int getSerializedSize() {
            return 8;
        }

        @Override
        public void write(int n2, WireOutput wireOutput) throws IOException {
            wireOutput.writeTag(n2, WireType.FIXED64);
            wireOutput.writeFixed64(this.value);
        }

        @Override
        public Long getAsLong() {
            return this.value;
        }
    }

    static final class Fixed32FieldValue
    extends FieldValue {
        private final Integer value;

        public Fixed32FieldValue(int n2, Integer n3) {
            super(n2, WireType.FIXED32);
            this.value = n3;
        }

        @Override
        public int getSerializedSize() {
            return 4;
        }

        @Override
        public void write(int n2, WireOutput wireOutput) throws IOException {
            wireOutput.writeTag(n2, WireType.FIXED32);
            wireOutput.writeFixed32(this.value);
        }

        @Override
        public Integer getAsInteger() {
            return this.value;
        }
    }

    static final class VarintFieldValue
    extends FieldValue {
        private final Long value;

        public VarintFieldValue(int n2, Long l2) {
            super(n2, WireType.VARINT);
            this.value = l2;
        }

        @Override
        public int getSerializedSize() {
            return WireOutput.varint64Size(this.value);
        }

        @Override
        public void write(int n2, WireOutput wireOutput) throws IOException {
            wireOutput.writeTag(n2, WireType.VARINT);
            wireOutput.writeVarint64(this.value);
        }

        @Override
        public Long getAsLong() {
            return this.value;
        }
    }

    static abstract class FieldValue {
        private final int tag;
        private final WireType wireType;

        public FieldValue(int n2, WireType wireType) {
            this.tag = n2;
            this.wireType = wireType;
        }

        public static VarintFieldValue varint(int n2, Long l2) {
            return new VarintFieldValue(n2, l2);
        }

        public static Fixed32FieldValue fixed32(int n2, Integer n3) {
            return new Fixed32FieldValue(n2, n3);
        }

        public static Fixed64FieldValue fixed64(int n2, Long l2) {
            return new Fixed64FieldValue(n2, l2);
        }

        public static LengthDelimitedFieldValue lengthDelimited(int n2, ByteString byteString) {
            return new LengthDelimitedFieldValue(n2, byteString);
        }

        public abstract int getSerializedSize();

        public abstract void write(int var1, WireOutput var2) throws IOException;

        public int getTag() {
            return this.tag;
        }

        public WireType getWireType() {
            return this.wireType;
        }

        public Integer getAsInteger() {
            throw new IllegalStateException();
        }

        public Long getAsLong() {
            throw new IllegalStateException();
        }

        public ByteString getAsBytes() {
            throw new IllegalStateException();
        }
    }

    static enum UnknownFieldType {
        VARINT,
        FIXED32,
        FIXED64,
        LENGTH_DELIMITED;


        public static UnknownFieldType of(String string) {
            if ("varint".equals(string)) {
                return VARINT;
            }
            if ("fixed32".equals(string)) {
                return FIXED32;
            }
            if ("fixed64".equals(string)) {
                return FIXED64;
            }
            if ("length-delimited".equals(string)) {
                return LENGTH_DELIMITED;
            }
            throw new IllegalArgumentException("Unknown type " + string);
        }
    }
}

