/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

abstract class TagMap<T> {
    private static final int SIZE_THRESHOLD = 64;
    private static final float RATIO_THRESHOLD = 0.75f;
    private static final Comparator<? super Map.Entry<Integer, ?>> COMPARATOR = new Comparator<Map.Entry<Integer, ?>>(){

        @Override
        public int compare(Map.Entry<Integer, ?> entry, Map.Entry<Integer, ?> entry2) {
            return entry.getKey().compareTo(entry2.getKey());
        }
    };
    List<T> values;

    public static <T> TagMap<T> of(Map<Integer, T> map) {
        int n2 = TagMap.maxTag(map);
        if (TagMap.isCompact(map.size(), n2)) {
            return Compact.compactTagMapOf(map, n2);
        }
        return Sparse.sparseTagMapOf(map);
    }

    private static boolean isCompact(int n2, int n3) {
        return n3 <= 64 || (float)n2 / (float)n3 > 0.75f;
    }

    private static <T> int maxTag(Map<Integer, T> map) {
        int n2 = -1;
        for (int n3 : map.keySet()) {
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private static <T> List<T> sortedValues(Map<Integer, T> map) {
        TreeSet treeSet = new TreeSet(COMPARATOR);
        treeSet.addAll(map.entrySet());
        ArrayList arrayList = new ArrayList();
        for (Map.Entry<Integer, ?> entry : treeSet) {
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }

    protected TagMap(Map<Integer, T> map) {
        this.values = TagMap.sortedValues(map);
    }

    public Collection<T> values() {
        return this.values;
    }

    public abstract T get(int var1);

    public abstract boolean containsKey(int var1);

    static final class Sparse<T>
    extends TagMap<T> {
        Map<Integer, T> map;

        public static <T> Sparse<T> sparseTagMapOf(Map<Integer, T> map) {
            return new Sparse<T>(map);
        }

        private Sparse(Map<Integer, T> map) {
            super(map);
            this.map = map;
        }

        @Override
        public T get(int n2) {
            return this.map.get(n2);
        }

        @Override
        public boolean containsKey(int n2) {
            return this.map.containsKey(n2);
        }
    }

    static final class Compact<T>
    extends TagMap<T> {
        Object[] elementsByTag;
        int maxTag = -1;

        public static <T> Compact<T> compactTagMapOf(Map<Integer, T> map, int n2) {
            return new Compact<T>(map, n2);
        }

        private Compact(Map<Integer, T> map, int n2) {
            super(map);
            this.maxTag = n2;
            this.elementsByTag = new Object[n2 + 1];
            for (Map.Entry<Integer, T> entry : map.entrySet()) {
                Integer n3 = entry.getKey();
                if (n3 <= 0) {
                    throw new IllegalArgumentException("Input map key is negative or zero");
                }
                this.elementsByTag[n3.intValue()] = entry.getValue();
            }
        }

        @Override
        public T get(int n2) {
            if (n2 > this.maxTag) {
                return null;
            }
            return (T)this.elementsByTag[n2];
        }

        @Override
        public boolean containsKey(int n2) {
            if (n2 > this.maxTag) {
                return false;
            }
            return this.elementsByTag[n2] != null;
        }
    }
}

