/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoField;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Redactor<T extends Message> {
    private static final Redactor<?> NOOP_REDACTOR = new Redactor<Message>(null, null, null, null){

        @Override
        public Message redact(Message message) {
            return message;
        }
    };
    private static final Map<Class<? extends Message>, Redactor> redactors = new LinkedHashMap<Class<? extends Message>, Redactor>();
    private final Constructor<?> builderConstructor;
    private final List<Field> redactedFields;
    private final List<Field> messageFields;
    private final List<Redactor<?>> messageRedactors;

    Redactor(Constructor<?> constructor, List<Field> list, List<Field> list2, List<Redactor<?>> list3) {
        this.builderConstructor = constructor;
        this.redactedFields = list;
        this.messageFields = list2;
        this.messageRedactors = list3;
    }

    /*
     * WARNING - void declaration
     */
    public static synchronized <T extends Message> Redactor<T> get(Class<T> clazz) {
        Redactor redactor = redactors.get(clazz);
        if (redactor != null) {
            return redactor;
        }
        FutureRedactor futureRedactor = new FutureRedactor();
        redactors.put(clazz, futureRedactor);
        try {
            void var7_12;
            Class<?> clazz2 = Class.forName(clazz.getName() + "$Builder");
            ArrayList<Field> arrayList = new ArrayList<Field>();
            ArrayList<Field> arrayList2 = new ArrayList<Field>();
            ArrayList arrayList3 = new ArrayList();
            for (Field field : clazz.getDeclaredFields()) {
                Field field2;
                Redactor<?> redactor2;
                if (Modifier.isStatic(field.getModifiers())) continue;
                ProtoField protoField = field.getAnnotation(ProtoField.class);
                if (protoField != null && protoField.redacted()) {
                    if (protoField.label() == Message.Label.REQUIRED) {
                        throw new IllegalArgumentException(String.format("Field %s is REQUIRED and cannot be redacted.", field));
                    }
                    arrayList.add(clazz2.getDeclaredField(field.getName()));
                    continue;
                }
                if (!Message.class.isAssignableFrom(field.getType()) || (redactor2 = Redactor.get((field2 = clazz2.getDeclaredField(field.getName())).getType())) == NOOP_REDACTOR) continue;
                arrayList2.add(field2);
                arrayList3.add(redactor2);
            }
            if (arrayList.isEmpty() && arrayList2.isEmpty()) {
                Redactor<?> redactor3 = NOOP_REDACTOR;
            } else {
                Constructor<?> constructor = clazz2.getConstructor(clazz);
                Redactor<T> redactor4 = new Redactor<T>(constructor, arrayList, arrayList2, arrayList3);
            }
            futureRedactor.setDelegate(var7_12);
            redactors.put(clazz, (Redactor)var7_12);
            return var7_12;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public T redact(T t) {
        if (t == null) {
            return null;
        }
        try {
            Message.Builder builder = (Message.Builder)this.builderConstructor.newInstance(t);
            for (Field field : this.redactedFields) {
                field.set(builder, null);
            }
            for (int i2 = 0; i2 < this.messageFields.size(); ++i2) {
                Field field;
                field = this.messageFields.get(i2);
                Redactor<?> redactor = this.messageRedactors.get(i2);
                field.set(builder, redactor.redact((Message)field.get(builder)));
            }
            return builder.build();
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception.getMessage());
        }
    }

    private static class FutureRedactor<T extends Message>
    extends Redactor<T> {
        private Redactor<T> delegate;

        public FutureRedactor() {
            super(null, null, null, null);
        }

        public void setDelegate(Redactor<T> redactor) {
            this.delegate = redactor;
        }

        @Override
        public T redact(T t) {
            if (this.delegate == null) {
                throw new IllegalStateException("Delegate was not set.");
            }
            return this.delegate.redact(t);
        }
    }
}

