/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionMap;
import com.squareup.wire.ExtensionRegistry;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.ProtoField;
import com.squareup.wire.TagMap;
import com.squareup.wire.Wire;
import com.squareup.wire.WireInput;
import com.squareup.wire.WireOutput;
import com.squareup.wire.WireType;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import okio.ByteString;

final class MessageAdapter<M extends Message> {
    private static final String FULL_BLOCK = "\u2588";
    private static final String REDACTED = "\u2588\u2588";
    private final Wire wire;
    private final Class<M> messageType;
    private final Class<Message.Builder<M>> builderType;
    private final Map<String, Integer> tagMap = new LinkedHashMap<String, Integer>();
    private final TagMap<FieldInfo> fieldInfoMap;

    Message.Builder<M> newBuilder() {
        try {
            return this.builderType.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
    }

    Collection<FieldInfo> getFields() {
        return this.fieldInfoMap.values();
    }

    FieldInfo getField(String string) {
        Integer n2 = this.tagMap.get(string);
        return n2 == null ? null : this.fieldInfoMap.get(n2);
    }

    Object getFieldValue(M m2, FieldInfo fieldInfo) {
        if (fieldInfo.messageField == null) {
            throw new AssertionError((Object)"Field is not of type \"Message\"");
        }
        try {
            return fieldInfo.messageField.get(m2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    public void setBuilderField(Message.Builder<M> builder, int n2, Object object) {
        try {
            this.fieldInfoMap.get(n2).builderField.set(builder, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }

    MessageAdapter(Wire wire, Class<M> clazz) {
        this.wire = wire;
        this.messageType = clazz;
        this.builderType = this.getBuilderType(clazz);
        LinkedHashMap<Integer, FieldInfo> linkedHashMap = new LinkedHashMap<Integer, FieldInfo>();
        for (Field field : clazz.getDeclaredFields()) {
            ProtoField protoField = field.getAnnotation(ProtoField.class);
            if (protoField == null) continue;
            int n2 = protoField.tag();
            String string = field.getName();
            this.tagMap.put(string, n2);
            Class<Object> clazz2 = null;
            Message.Datatype datatype = protoField.type();
            if (datatype == Message.Datatype.ENUM) {
                clazz2 = this.getEnumType(field);
            } else if (datatype == Message.Datatype.MESSAGE) {
                clazz2 = this.getMessageType(field);
            }
            linkedHashMap.put(n2, new FieldInfo(n2, string, datatype, protoField.label(), protoField.redacted(), clazz2, field, this.getBuilderField(string)));
        }
        this.fieldInfoMap = TagMap.of(linkedHashMap);
    }

    private Class<Message.Builder<M>> getBuilderType(Class<M> clazz) {
        try {
            return Class.forName(clazz.getName() + "$Builder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("No builder class found for message type " + clazz.getName());
        }
    }

    private Field getBuilderField(String string) {
        try {
            return this.builderType.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError((Object)("No builder field " + this.builderType.getName() + "." + string));
        }
    }

    private Class<? extends Message> getMessageType(Field field) {
        Class<?> clazz = field.getType();
        if (Message.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return field.getAnnotation(ProtoField.class).messageType();
        }
        return null;
    }

    private Class<? extends Enum> getEnumType(Field field) {
        Class<?> clazz = field.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return field.getAnnotation(ProtoField.class).enumType();
        }
        return null;
    }

    int getSerializedSize(M m2) {
        int n2 = 0;
        for (FieldInfo fieldInfo : this.getFields()) {
            Object object = this.getFieldValue(m2, fieldInfo);
            if (object == null) continue;
            int n3 = fieldInfo.tag;
            Message.Datatype datatype = fieldInfo.datatype;
            Message.Label label = fieldInfo.label;
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    n2 += this.getPackedSize((List)object, n3, datatype);
                    continue;
                }
                n2 += this.getRepeatedSize((List)object, n3, datatype);
                continue;
            }
            n2 += this.getSerializedSize(n3, object, datatype);
        }
        if (m2 instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)m2;
            if (extendableMessage.extensionMap != null) {
                n2 += this.getExtensionsSerializedSize(extendableMessage.extensionMap);
            }
        }
        return n2 += ((Message)m2).getUnknownFieldsSerializedSize();
    }

    private <T extends ExtendableMessage<?>> int getExtensionsSerializedSize(ExtensionMap<T> extensionMap) {
        int n2 = 0;
        for (int i2 = 0; i2 < extensionMap.size(); ++i2) {
            Extension<T, ?> extension = extensionMap.getExtension(i2);
            Object object = extensionMap.getExtensionValue(i2);
            int n3 = extension.getTag();
            Message.Datatype datatype = extension.getDatatype();
            Message.Label label = extension.getLabel();
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    n2 += this.getPackedSize((List)object, n3, datatype);
                    continue;
                }
                n2 += this.getRepeatedSize((List)object, n3, datatype);
                continue;
            }
            n2 += this.getSerializedSize(n3, object, datatype);
        }
        return n2;
    }

    private int getRepeatedSize(List<?> list, int n2, Message.Datatype datatype) {
        int n3 = 0;
        for (Object obj : list) {
            n3 += this.getSerializedSize(n2, obj, datatype);
        }
        return n3;
    }

    private int getPackedSize(List<?> list, int n2, Message.Datatype datatype) {
        int n3 = 0;
        for (Object obj : list) {
            n3 += this.getSerializedSizeNoTag(obj, datatype);
        }
        int n4 = WireOutput.varint32Size(WireOutput.makeTag(n2, WireType.LENGTH_DELIMITED));
        n4 += WireOutput.varint32Size(n3);
        return n4 += n3;
    }

    void write(M m2, WireOutput wireOutput) throws IOException {
        for (FieldInfo fieldInfo : this.getFields()) {
            Object object = this.getFieldValue(m2, fieldInfo);
            if (object == null) continue;
            int n2 = fieldInfo.tag;
            Message.Datatype datatype = fieldInfo.datatype;
            Message.Label label = fieldInfo.label;
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    this.writePacked(wireOutput, (List)object, n2, datatype);
                    continue;
                }
                this.writeRepeated(wireOutput, (List)object, n2, datatype);
                continue;
            }
            this.writeValue(wireOutput, n2, object, datatype);
        }
        if (m2 instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)m2;
            if (extendableMessage.extensionMap != null) {
                this.writeExtensions(wireOutput, extendableMessage.extensionMap);
            }
        }
        ((Message)m2).writeUnknownFieldMap(wireOutput);
    }

    private <T extends ExtendableMessage<?>> void writeExtensions(WireOutput wireOutput, ExtensionMap<T> extensionMap) throws IOException {
        for (int i2 = 0; i2 < extensionMap.size(); ++i2) {
            Extension<T, ?> extension = extensionMap.getExtension(i2);
            Object object = extensionMap.getExtensionValue(i2);
            int n2 = extension.getTag();
            Message.Datatype datatype = extension.getDatatype();
            Message.Label label = extension.getLabel();
            if (label.isRepeated()) {
                if (label.isPacked()) {
                    this.writePacked(wireOutput, (List)object, n2, datatype);
                    continue;
                }
                this.writeRepeated(wireOutput, (List)object, n2, datatype);
                continue;
            }
            this.writeValue(wireOutput, n2, object, datatype);
        }
    }

    private void writeRepeated(WireOutput wireOutput, List<?> list, int n2, Message.Datatype datatype) throws IOException {
        for (Object obj : list) {
            this.writeValue(wireOutput, n2, obj, datatype);
        }
    }

    private void writePacked(WireOutput wireOutput, List<?> list, int n2, Message.Datatype datatype) throws IOException {
        int n3 = 0;
        for (Object obj : list) {
            n3 += this.getSerializedSizeNoTag(obj, datatype);
        }
        wireOutput.writeTag(n2, WireType.LENGTH_DELIMITED);
        wireOutput.writeVarint32(n3);
        for (Object obj : list) {
            this.writeValueNoTag(wireOutput, obj, datatype);
        }
    }

    byte[] toByteArray(M m2) {
        byte[] byArray = new byte[this.getSerializedSize(m2)];
        try {
            this.write(m2, WireOutput.newInstance(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return byArray;
    }

    String toString(M m2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.messageType.getSimpleName());
        stringBuilder.append("{");
        String string = "";
        for (FieldInfo fieldInfo : this.getFields()) {
            Object object = this.getFieldValue(m2, fieldInfo);
            if (object == null) continue;
            stringBuilder.append(string);
            string = ", ";
            stringBuilder.append(fieldInfo.name);
            stringBuilder.append("=");
            stringBuilder.append(fieldInfo.redacted ? REDACTED : object);
        }
        if (m2 instanceof ExtendableMessage) {
            ExtendableMessage extendableMessage = (ExtendableMessage)m2;
            stringBuilder.append(string);
            stringBuilder.append("{extensions=");
            stringBuilder.append(extendableMessage.extensionsToString());
            stringBuilder.append("}");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private int getSerializedSize(int n2, Object object, Message.Datatype datatype) {
        return WireOutput.varintTagSize(n2) + this.getSerializedSizeNoTag(object, datatype);
    }

    private int getSerializedSizeNoTag(Object object, Message.Datatype datatype) {
        switch (datatype) {
            case INT32: {
                return WireOutput.int32Size((Integer)object);
            }
            case INT64: 
            case UINT64: {
                return WireOutput.varint64Size((Long)object);
            }
            case UINT32: {
                return WireOutput.varint32Size((Integer)object);
            }
            case SINT32: {
                return WireOutput.varint32Size(WireOutput.zigZag32((Integer)object));
            }
            case SINT64: {
                return WireOutput.varint64Size(WireOutput.zigZag64((Long)object));
            }
            case BOOL: {
                return 1;
            }
            case ENUM: {
                return this.getEnumSize((ProtoEnum)object);
            }
            case STRING: {
                int n2 = this.utf8Length((String)object);
                return WireOutput.varint32Size(n2) + n2;
            }
            case BYTES: {
                int n3 = ((ByteString)object).size();
                return WireOutput.varint32Size(n3) + n3;
            }
            case MESSAGE: {
                return this.getMessageSize((Message)object);
            }
            case FIXED32: 
            case SFIXED32: 
            case FLOAT: {
                return 4;
            }
            case FIXED64: 
            case SFIXED64: 
            case DOUBLE: {
                return 8;
            }
        }
        throw new RuntimeException();
    }

    private int utf8Length(String string) {
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u007f') {
                ++n2;
                continue;
            }
            if (c2 <= '\u07ff') {
                n2 += 2;
                continue;
            }
            if (Character.isHighSurrogate(c2)) {
                n2 += 4;
                ++i2;
                continue;
            }
            n2 += 3;
        }
        return n2;
    }

    private <E extends ProtoEnum> int getEnumSize(E e2) {
        EnumAdapter<?> enumAdapter = this.wire.enumAdapter(e2.getClass());
        return WireOutput.varint32Size(enumAdapter.toInt(e2));
    }

    private <M extends Message> int getMessageSize(M m2) {
        int n2 = m2.getSerializedSize();
        return WireOutput.varint32Size(n2) + n2;
    }

    private void writeValue(WireOutput wireOutput, int n2, Object object, Message.Datatype datatype) throws IOException {
        wireOutput.writeTag(n2, datatype.wireType());
        this.writeValueNoTag(wireOutput, object, datatype);
    }

    private void writeValueNoTag(WireOutput wireOutput, Object object, Message.Datatype datatype) throws IOException {
        switch (datatype) {
            case INT32: {
                wireOutput.writeSignedVarint32((Integer)object);
                break;
            }
            case INT64: 
            case UINT64: {
                wireOutput.writeVarint64((Long)object);
                break;
            }
            case UINT32: {
                wireOutput.writeVarint32((Integer)object);
                break;
            }
            case SINT32: {
                wireOutput.writeVarint32(WireOutput.zigZag32((Integer)object));
                break;
            }
            case SINT64: {
                wireOutput.writeVarint64(WireOutput.zigZag64((Long)object));
                break;
            }
            case BOOL: {
                wireOutput.writeRawByte((Boolean)object != false ? 1 : 0);
                break;
            }
            case ENUM: {
                this.writeEnum((ProtoEnum)object, wireOutput);
                break;
            }
            case STRING: {
                byte[] byArray = ((String)object).getBytes("UTF-8");
                wireOutput.writeVarint32(byArray.length);
                wireOutput.writeRawBytes(byArray);
                break;
            }
            case BYTES: {
                ByteString byteString = (ByteString)object;
                wireOutput.writeVarint32(byteString.size());
                wireOutput.writeRawBytes(byteString.toByteArray());
                break;
            }
            case MESSAGE: {
                this.writeMessage((Message)object, wireOutput);
                break;
            }
            case FIXED32: 
            case SFIXED32: {
                wireOutput.writeFixed32((Integer)object);
                break;
            }
            case FIXED64: 
            case SFIXED64: {
                wireOutput.writeFixed64((Long)object);
                break;
            }
            case FLOAT: {
                wireOutput.writeFixed32(Float.floatToIntBits(((Float)object).floatValue()));
                break;
            }
            case DOUBLE: {
                wireOutput.writeFixed64(Double.doubleToLongBits((Double)object));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private <M extends Message> void writeMessage(M m2, WireOutput wireOutput) throws IOException {
        wireOutput.writeVarint32(m2.getSerializedSize());
        MessageAdapter<?> messageAdapter = this.wire.messageAdapter(m2.getClass());
        messageAdapter.write(m2, wireOutput);
    }

    private <E extends ProtoEnum> void writeEnum(E e2, WireOutput wireOutput) throws IOException {
        EnumAdapter<?> enumAdapter = this.wire.enumAdapter(e2.getClass());
        wireOutput.writeVarint32(enumAdapter.toInt(e2));
    }

    M read(WireInput wireInput) throws IOException {
        try {
            Message.Builder<M> builder = this.builderType.newInstance();
            Storage storage = new Storage();
            while (true) {
                Object object;
                Message.Label label;
                Object object2;
                Extension<ExtendableMessage<?>, ?> extension = null;
                int n2 = wireInput.readTag();
                int n3 = n2 >> 3;
                WireType wireType = WireType.valueOf(n2);
                if (n3 == 0) {
                    for (int n4 : storage.getTags()) {
                        boolean bl = this.fieldInfoMap.containsKey(n4);
                        if (bl) {
                            this.setBuilderField(builder, n4, storage.get(n4));
                            continue;
                        }
                        this.setExtension((ExtendableMessage.ExtendableBuilder)builder, this.getExtension(n4), storage.get(n4));
                    }
                    return builder.build();
                }
                FieldInfo fieldInfo = this.fieldInfoMap.get(n3);
                if (fieldInfo != null) {
                    object2 = fieldInfo.datatype;
                    label = fieldInfo.label;
                } else {
                    extension = this.getExtension(n3);
                    if (extension == null) {
                        this.readUnknownField(builder, wireInput, n3, wireType);
                        continue;
                    }
                    object2 = extension.getDatatype();
                    label = extension.getLabel();
                }
                if (label.isPacked() && wireType == WireType.LENGTH_DELIMITED) {
                    int n5 = wireInput.readVarint32();
                    long l2 = wireInput.getPosition();
                    int n6 = wireInput.pushLimit(n5);
                    while (wireInput.getPosition() < l2 + (long)n5) {
                        object = this.readValue(wireInput, n3, (Message.Datatype)((Object)object2));
                        if (object2 == Message.Datatype.ENUM && object instanceof Integer) {
                            builder.addVarint(n3, ((Integer)object).intValue());
                            continue;
                        }
                        storage.add(n3, object);
                    }
                    wireInput.popLimit(n6);
                    if (wireInput.getPosition() == l2 + (long)n5) continue;
                    throw new IOException("Packed data had wrong length!");
                }
                object = this.readValue(wireInput, n3, (Message.Datatype)((Object)object2));
                if (object2 == Message.Datatype.ENUM && object instanceof Integer) {
                    builder.addVarint(n3, ((Integer)object).intValue());
                    continue;
                }
                if (label.isRepeated()) {
                    storage.add(n3, object);
                    continue;
                }
                if (extension != null) {
                    this.setExtension((ExtendableMessage.ExtendableBuilder)builder, extension, object);
                    continue;
                }
                this.setBuilderField(builder, n3, object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
    }

    private Object readValue(WireInput wireInput, int n2, Message.Datatype datatype) throws IOException {
        switch (datatype) {
            case INT32: 
            case UINT32: {
                return wireInput.readVarint32();
            }
            case INT64: 
            case UINT64: {
                return wireInput.readVarint64();
            }
            case SINT32: {
                return WireInput.decodeZigZag32(wireInput.readVarint32());
            }
            case SINT64: {
                return WireInput.decodeZigZag64(wireInput.readVarint64());
            }
            case BOOL: {
                return wireInput.readVarint32() != 0;
            }
            case ENUM: {
                EnumAdapter<ProtoEnum> enumAdapter = this.getEnumAdapter(n2);
                int n3 = wireInput.readVarint32();
                try {
                    return enumAdapter.fromInt(n3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return n3;
                }
            }
            case STRING: {
                return wireInput.readString();
            }
            case BYTES: {
                return wireInput.readBytes();
            }
            case MESSAGE: {
                return this.readMessage(wireInput, n2);
            }
            case FIXED32: 
            case SFIXED32: {
                return wireInput.readFixed32();
            }
            case FIXED64: 
            case SFIXED64: {
                return wireInput.readFixed64();
            }
            case FLOAT: {
                return Float.valueOf(Float.intBitsToFloat(wireInput.readFixed32()));
            }
            case DOUBLE: {
                return Double.longBitsToDouble(wireInput.readFixed64());
            }
        }
        throw new RuntimeException();
    }

    private Message readMessage(WireInput wireInput, int n2) throws IOException {
        int n3 = wireInput.readVarint32();
        if (wireInput.recursionDepth >= 64) {
            throw new IOException("Wire recursion limit exceeded");
        }
        int n4 = wireInput.pushLimit(n3);
        ++wireInput.recursionDepth;
        MessageAdapter<Message> messageAdapter = this.getMessageAdapter(n2);
        Message message = messageAdapter.read(wireInput);
        wireInput.checkLastTagWas(0);
        --wireInput.recursionDepth;
        wireInput.popLimit(n4);
        return message;
    }

    private MessageAdapter<? extends Message> getMessageAdapter(int n2) {
        FieldInfo fieldInfo = this.fieldInfoMap.get(n2);
        if (fieldInfo != null && fieldInfo.messageAdapter != null) {
            return fieldInfo.messageAdapter;
        }
        MessageAdapter<Message> messageAdapter = this.wire.messageAdapter(this.getMessageClass(n2));
        if (fieldInfo != null) {
            fieldInfo.messageAdapter = messageAdapter;
        }
        return messageAdapter;
    }

    private EnumAdapter<? extends ProtoEnum> getEnumAdapter(int n2) {
        FieldInfo fieldInfo = this.fieldInfoMap.get(n2);
        if (fieldInfo != null && fieldInfo.enumAdapter != null) {
            return fieldInfo.enumAdapter;
        }
        EnumAdapter<ProtoEnum> enumAdapter = this.wire.enumAdapter(this.getEnumClass(n2));
        if (fieldInfo != null) {
            fieldInfo.enumAdapter = enumAdapter;
        }
        return enumAdapter;
    }

    private Class<Message> getMessageClass(int n2) {
        Extension<ExtendableMessage<?>, ?> extension;
        Class<Message> clazz;
        FieldInfo fieldInfo = this.fieldInfoMap.get(n2);
        Class<Message> clazz2 = clazz = fieldInfo == null ? null : fieldInfo.messageType;
        if (clazz == null && (extension = this.getExtension(n2)) != null) {
            clazz = extension.getMessageType();
        }
        return clazz;
    }

    private void readUnknownField(Message.Builder builder, WireInput wireInput, int n2, WireType wireType) throws IOException {
        switch (wireType) {
            case VARINT: {
                builder.ensureUnknownFieldMap().addVarint(n2, wireInput.readVarint64());
                break;
            }
            case FIXED32: {
                builder.ensureUnknownFieldMap().addFixed32(n2, wireInput.readFixed32());
                break;
            }
            case FIXED64: {
                builder.ensureUnknownFieldMap().addFixed64(n2, wireInput.readFixed64());
                break;
            }
            case LENGTH_DELIMITED: {
                int n3 = wireInput.readVarint32();
                builder.ensureUnknownFieldMap().addLengthDelimited(n2, wireInput.readBytes(n3));
                break;
            }
            case START_GROUP: {
                wireInput.skipGroup();
                break;
            }
            case END_GROUP: {
                break;
            }
            default: {
                throw new RuntimeException("Unsupported wire type: " + (Object)((Object)wireType));
            }
        }
    }

    private Extension<ExtendableMessage<?>, ?> getExtension(int n2) {
        ExtensionRegistry extensionRegistry = this.wire.registry;
        return extensionRegistry == null ? null : extensionRegistry.getExtension(this.messageType, n2);
    }

    Extension<ExtendableMessage<?>, ?> getExtension(String string) {
        ExtensionRegistry extensionRegistry = this.wire.registry;
        return extensionRegistry == null ? null : extensionRegistry.getExtension(this.messageType, string);
    }

    private void setExtension(ExtendableMessage.ExtendableBuilder extendableBuilder, Extension<?, ?> extension, Object object) {
        extendableBuilder.setExtension(extension, object);
    }

    private Class<? extends ProtoEnum> getEnumClass(int n2) {
        Extension<ExtendableMessage<?>, ?> extension;
        Class<? extends ProtoEnum> clazz;
        FieldInfo fieldInfo = this.fieldInfoMap.get(n2);
        Class<? extends ProtoEnum> clazz2 = clazz = fieldInfo == null ? null : fieldInfo.enumType;
        if (clazz == null && (extension = this.getExtension(n2)) != null) {
            clazz = extension.getEnumType();
        }
        return clazz;
    }

    static class ImmutableList<T>
    extends AbstractList<T>
    implements Serializable,
    Cloneable,
    RandomAccess {
        private final List<T> list = new ArrayList<T>();

        ImmutableList() {
        }

        public Object clone() {
            return this;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public T get(int n2) {
            return this.list.get(n2);
        }
    }

    private static class Storage {
        private Map<Integer, ImmutableList<Object>> map;

        private Storage() {
        }

        void add(int n2, Object object) {
            ImmutableList<Object> immutableList;
            ImmutableList<Object> immutableList2 = immutableList = this.map == null ? null : this.map.get(n2);
            if (immutableList == null) {
                immutableList = new ImmutableList();
                if (this.map == null) {
                    this.map = new LinkedHashMap<Integer, ImmutableList<Object>>();
                }
                this.map.put(n2, immutableList);
            }
            ((ImmutableList)immutableList).list.add(object);
        }

        Set<Integer> getTags() {
            if (this.map == null) {
                return Collections.emptySet();
            }
            return this.map.keySet();
        }

        List<Object> get(int n2) {
            return this.map == null ? null : this.map.get(n2);
        }
    }

    public static final class FieldInfo {
        final int tag;
        final String name;
        final Message.Datatype datatype;
        final Message.Label label;
        final Class<? extends ProtoEnum> enumType;
        final Class<? extends Message> messageType;
        final boolean redacted;
        MessageAdapter<? extends Message> messageAdapter;
        EnumAdapter<? extends ProtoEnum> enumAdapter;
        private final Field messageField;
        private final Field builderField;

        private FieldInfo(int n2, String string, Message.Datatype datatype, Message.Label label, boolean bl, Class<?> clazz, Field field, Field field2) {
            this.tag = n2;
            this.name = string;
            this.datatype = datatype;
            this.label = label;
            this.redacted = bl;
            if (datatype == Message.Datatype.ENUM) {
                this.enumType = clazz;
                this.messageType = null;
            } else if (datatype == Message.Datatype.MESSAGE) {
                this.messageType = clazz;
                this.enumType = null;
            } else {
                this.enumType = null;
                this.messageType = null;
            }
            this.messageField = field;
            this.builderField = field2;
        }
    }
}

