/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.EnumAdapter;
import com.squareup.wire.MessageAdapter;
import com.squareup.wire.MessageSerializedForm;
import com.squareup.wire.ProtoEnum;
import com.squareup.wire.UnknownFieldMap;
import com.squareup.wire.Wire;
import com.squareup.wire.WireOutput;
import com.squareup.wire.WireType;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okio.ByteString;

public abstract class Message
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final Wire WIRE = new Wire(new Class[0]);
    private transient UnknownFieldMap unknownFields;
    private transient boolean haveCachedSerializedSize;
    private transient int cachedSerializedSize;
    protected transient int hashCode = 0;

    protected Message() {
    }

    protected void setBuilder(Builder builder) {
        if (builder.unknownFieldMap != null) {
            this.unknownFields = new UnknownFieldMap(builder.unknownFieldMap);
        }
    }

    protected Collection<List<UnknownFieldMap.FieldValue>> unknownFields() {
        return this.unknownFields == null ? Collections.emptySet() : this.unknownFields.fieldMap.values();
    }

    protected static <T> List<T> copyOf(List<T> list) {
        return list == null ? null : new ArrayList<T>(list);
    }

    protected static <T> List<T> immutableCopyOf(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        if (list instanceof MessageAdapter.ImmutableList) {
            return list;
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <E extends Enum> int intFromEnum(E e2) {
        EnumAdapter<?> enumAdapter = WIRE.enumAdapter(e2.getClass());
        return enumAdapter.toInt((ProtoEnum)((Object)e2));
    }

    public static <E extends Enum> E enumFromInt(Class<E> clazz, int n2) {
        EnumAdapter<E> enumAdapter = WIRE.enumAdapter(clazz);
        return (E)((Enum)enumAdapter.fromInt(n2));
    }

    public byte[] toByteArray() {
        return WIRE.messageAdapter(this.getClass()).toByteArray(this);
    }

    public void writeTo(byte[] byArray) {
        this.writeTo(byArray, 0, byArray.length);
    }

    public void writeTo(byte[] byArray, int n2, int n3) {
        this.write(WireOutput.newInstance(byArray, n2, n3));
    }

    private void write(WireOutput wireOutput) {
        MessageAdapter<?> messageAdapter = WIRE.messageAdapter(this.getClass());
        try {
            messageAdapter.write(this, wireOutput);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void writeUnknownFieldMap(WireOutput wireOutput) throws IOException {
        if (this.unknownFields != null) {
            this.unknownFields.write(wireOutput);
        }
    }

    public int getSerializedSize() {
        if (!this.haveCachedSerializedSize) {
            MessageAdapter<?> messageAdapter = WIRE.messageAdapter(this.getClass());
            this.cachedSerializedSize = messageAdapter.getSerializedSize(this);
            this.haveCachedSerializedSize = true;
        }
        return this.cachedSerializedSize;
    }

    public int getUnknownFieldsSerializedSize() {
        return this.unknownFields == null ? 0 : this.unknownFields.getSerializedSize();
    }

    protected boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    protected boolean equals(List<?> list, List<?> list2) {
        if (list != null && list.isEmpty()) {
            list = null;
        }
        if (list2 != null && list2.isEmpty()) {
            list2 = null;
        }
        return list == list2 || list != null && list.equals(list2);
    }

    public String toString() {
        return WIRE.messageAdapter(this.getClass()).toString(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MessageSerializedForm(this, this.getClass());
    }

    public static abstract class Builder<T extends Message> {
        UnknownFieldMap unknownFieldMap;

        public Builder() {
        }

        public Builder(Message message) {
            if (message != null && message.unknownFields != null) {
                this.unknownFieldMap = new UnknownFieldMap(message.unknownFields);
            }
        }

        public void addVarint(int n2, long l2) {
            try {
                this.ensureUnknownFieldMap().addVarint(n2, l2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }

        public void addFixed32(int n2, int n3) {
            try {
                this.ensureUnknownFieldMap().addFixed32(n2, n3);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }

        public void addFixed64(int n2, long l2) {
            try {
                this.ensureUnknownFieldMap().addFixed64(n2, l2);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }

        public void addLengthDelimited(int n2, ByteString byteString) {
            try {
                this.ensureUnknownFieldMap().addLengthDelimited(n2, byteString);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }

        UnknownFieldMap ensureUnknownFieldMap() {
            if (this.unknownFieldMap == null) {
                this.unknownFieldMap = new UnknownFieldMap();
            }
            return this.unknownFieldMap;
        }

        public void checkRequiredFields() {
            WIRE.builderAdapter(this.getClass()).checkRequiredFields(this);
        }

        protected static <T> List<T> checkForNulls(List<T> list) {
            if (list != null && !list.isEmpty()) {
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    T t = list.get(i2);
                    if (t != null) continue;
                    throw new NullPointerException("Element at index " + i2 + " is null");
                }
            }
            return list;
        }

        public abstract T build();
    }

    public static enum Label {
        REQUIRED(32),
        OPTIONAL(64),
        REPEATED(128),
        PACKED(256);

        public static final Comparator<Label> ORDER_BY_NAME;
        private final int value;

        private Label(int n3) {
            this.value = n3;
        }

        public int value() {
            return this.value;
        }

        public boolean isRepeated() {
            return this == REPEATED || this == PACKED;
        }

        public boolean isPacked() {
            return this == PACKED;
        }

        static {
            ORDER_BY_NAME = new Comparator<Label>(){

                @Override
                public int compare(Label label, Label label2) {
                    return label.name().compareTo(label2.name());
                }
            };
        }
    }

    public static enum Datatype {
        INT32(1),
        INT64(2),
        UINT32(3),
        UINT64(4),
        SINT32(5),
        SINT64(6),
        BOOL(7),
        ENUM(8),
        STRING(9),
        BYTES(10),
        MESSAGE(11),
        FIXED32(12),
        SFIXED32(13),
        FIXED64(14),
        SFIXED64(15),
        FLOAT(16),
        DOUBLE(17);

        public static final Comparator<Datatype> ORDER_BY_NAME;
        private static final Map<String, Datatype> TYPES_BY_NAME;
        private final int value;

        private Datatype(int n3) {
            this.value = n3;
        }

        public int value() {
            return this.value;
        }

        public WireType wireType() {
            switch (this) {
                case INT32: 
                case INT64: 
                case UINT32: 
                case UINT64: 
                case SINT32: 
                case SINT64: 
                case BOOL: 
                case ENUM: {
                    return WireType.VARINT;
                }
                case FIXED32: 
                case SFIXED32: 
                case FLOAT: {
                    return WireType.FIXED32;
                }
                case FIXED64: 
                case SFIXED64: 
                case DOUBLE: {
                    return WireType.FIXED64;
                }
                case STRING: 
                case BYTES: 
                case MESSAGE: {
                    return WireType.LENGTH_DELIMITED;
                }
            }
            throw new AssertionError((Object)("No wiretype for datatype " + (Object)((Object)this)));
        }

        public static Datatype of(String string) {
            return TYPES_BY_NAME.get(string);
        }

        static {
            ORDER_BY_NAME = new Comparator<Datatype>(){

                @Override
                public int compare(Datatype datatype, Datatype datatype2) {
                    return datatype.name().compareTo(datatype2.name());
                }
            };
            TYPES_BY_NAME = new LinkedHashMap<String, Datatype>();
            TYPES_BY_NAME.put("int32", INT32);
            TYPES_BY_NAME.put("int64", INT64);
            TYPES_BY_NAME.put("uint32", UINT32);
            TYPES_BY_NAME.put("uint64", UINT64);
            TYPES_BY_NAME.put("sint32", SINT32);
            TYPES_BY_NAME.put("sint64", SINT64);
            TYPES_BY_NAME.put("bool", BOOL);
            TYPES_BY_NAME.put("enum", ENUM);
            TYPES_BY_NAME.put("string", STRING);
            TYPES_BY_NAME.put("bytes", BYTES);
            TYPES_BY_NAME.put("message", MESSAGE);
            TYPES_BY_NAME.put("fixed32", FIXED32);
            TYPES_BY_NAME.put("sfixed32", SFIXED32);
            TYPES_BY_NAME.put("fixed64", FIXED64);
            TYPES_BY_NAME.put("sfixed64", SFIXED64);
            TYPES_BY_NAME.put("float", FLOAT);
            TYPES_BY_NAME.put("double", DOUBLE);
        }
    }
}

