/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Extension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class ExtensionMap<T extends ExtendableMessage<?>> {
    private static final int INITIAL_SIZE = 1;
    private Object[] data;
    private int size;

    public <E> ExtensionMap(Extension<T, E> extension, E e2) {
        this.data = new Object[2];
        this.data[0] = extension;
        this.data[1] = e2;
        this.size = 1;
    }

    public ExtensionMap(ExtensionMap<T> extensionMap) {
        this.data = (Object[])extensionMap.data.clone();
        this.size = extensionMap.size;
    }

    public int size() {
        return this.size;
    }

    public Extension<T, ?> getExtension(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        return (Extension)this.data[n2];
    }

    public Object getExtensionValue(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        return this.data[this.size + n2];
    }

    public List<Extension<T, ?>> getExtensions() {
        ArrayList<Extension> arrayList = new ArrayList<Extension>(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            arrayList.add((Extension)this.data[i2]);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public <E> E get(Extension<T, E> extension) {
        int n2 = Arrays.binarySearch(this.data, 0, this.size, extension);
        return (E)(n2 < 0 ? null : this.data[this.size + n2]);
    }

    public <E> void put(Extension<T, E> extension, E e2) {
        int n2 = Arrays.binarySearch(this.data, 0, this.size, extension);
        if (n2 >= 0) {
            this.data[this.size + n2] = e2;
        } else {
            this.insert(extension, e2, -(n2 + 1));
        }
    }

    private <E> void insert(Extension<T, E> extension, E e2, int n2) {
        Object[] objectArray = this.data;
        if (this.data.length < 2 * (this.size + 1)) {
            objectArray = new Object[2 * this.data.length];
            System.arraycopy(this.data, 0, objectArray, 0, n2);
        }
        if (n2 < this.size) {
            System.arraycopy(this.data, this.size + n2, objectArray, this.size + n2 + 2, this.size - n2);
            System.arraycopy(this.data, n2, objectArray, n2 + 1, this.size);
        } else {
            System.arraycopy(this.data, this.size, objectArray, this.size + 1, this.size);
        }
        ++this.size;
        this.data = objectArray;
        this.data[n2] = extension;
        this.data[this.size + n2] = e2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExtensionMap)) {
            return false;
        }
        ExtensionMap extensionMap = (ExtensionMap)object;
        if (this.size != extensionMap.size) {
            return false;
        }
        for (int i2 = 0; i2 < 2 * this.size; ++i2) {
            if (this.data[i2].equals(extensionMap.data[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 < 2 * this.size; ++i2) {
            n2 = n2 * 37 + this.data[i2].hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        String string = "";
        for (int i2 = 0; i2 < this.size; ++i2) {
            stringBuilder.append(string);
            stringBuilder.append(((Extension)this.data[i2]).getTag());
            stringBuilder.append("=");
            stringBuilder.append(this.data[this.size + i2]);
            string = ", ";
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

