/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ExtendableMessage;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoEnum;
import java.util.List;
import okio.ByteString;

public final class Extension<T extends ExtendableMessage<?>, E>
implements Comparable<Extension<?, ?>> {
    private final Class<T> extendedType;
    private final Class<? extends Message> messageType;
    private final Class<? extends ProtoEnum> enumType;
    private final String name;
    private final int tag;
    private final Message.Datatype datatype;
    private final Message.Label label;

    public static <T extends ExtendableMessage<?>> Builder<T, Integer> int32Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.INT32);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Integer> sint32Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.SINT32);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Integer> uint32Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.UINT32);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Integer> fixed32Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.FIXED32);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Integer> sfixed32Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.SFIXED32);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Long> int64Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.INT64);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Long> sint64Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.SINT64);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Long> uint64Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.UINT64);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Long> fixed64Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.FIXED64);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Long> sfixed64Extending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.SFIXED64);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Boolean> boolExtending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.BOOL);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, String> stringExtending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.STRING);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, ByteString> bytesExtending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.BYTES);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Float> floatExtending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.FLOAT);
    }

    public static <T extends ExtendableMessage<?>> Builder<T, Double> doubleExtending(Class<T> clazz) {
        return new Builder(clazz, Message.Datatype.DOUBLE);
    }

    public static <T extends ExtendableMessage<?>, E extends Enum> Builder<T, E> enumExtending(Class<E> clazz, Class<T> clazz2) {
        return new Builder(clazz2, null, clazz, Message.Datatype.ENUM);
    }

    public static <T extends ExtendableMessage<?>, M extends Message> Builder<T, M> messageExtending(Class<M> clazz, Class<T> clazz2) {
        return new Builder(clazz2, clazz, null, Message.Datatype.MESSAGE);
    }

    private Extension(Class<T> clazz, Class<? extends Message> clazz2, Class<? extends ProtoEnum> clazz3, String string, int n2, Message.Label label, Message.Datatype datatype) {
        this.extendedType = clazz;
        this.name = string;
        this.tag = n2;
        this.datatype = datatype;
        this.label = label;
        this.messageType = clazz2;
        this.enumType = clazz3;
    }

    @Override
    public int compareTo(Extension<?, ?> extension) {
        if (extension == this) {
            return 0;
        }
        if (this.tag != extension.tag) {
            return this.tag - extension.tag;
        }
        if (this.datatype != extension.datatype) {
            return this.datatype.value() - extension.datatype.value();
        }
        if (this.label != extension.label) {
            return this.label.value() - extension.label.value();
        }
        if (this.extendedType != null && !this.extendedType.equals(extension.extendedType)) {
            return this.extendedType.getName().compareTo(extension.extendedType.getName());
        }
        if (this.messageType != null && !this.messageType.equals(extension.messageType)) {
            return this.messageType.getName().compareTo(extension.messageType.getName());
        }
        if (this.enumType != null && !this.enumType.equals(extension.enumType)) {
            return this.enumType.getName().compareTo(extension.enumType.getName());
        }
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof Extension && this.compareTo((Extension)object) == 0;
    }

    public int hashCode() {
        int n2 = this.tag;
        n2 = n2 * 37 + this.datatype.value();
        n2 = n2 * 37 + this.label.value();
        n2 = n2 * 37 + this.extendedType.hashCode();
        n2 = n2 * 37 + (this.messageType != null ? this.messageType.hashCode() : 0);
        n2 = n2 * 37 + (this.enumType != null ? this.enumType.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return String.format("[%s %s %s = %d]", new Object[]{this.label, this.datatype, this.name, this.tag});
    }

    public Class<T> getExtendedType() {
        return this.extendedType;
    }

    public Class<? extends Message> getMessageType() {
        return this.messageType;
    }

    public Class<? extends ProtoEnum> getEnumType() {
        return this.enumType;
    }

    public String getName() {
        return this.name;
    }

    public int getTag() {
        return this.tag;
    }

    public Message.Datatype getDatatype() {
        return this.datatype;
    }

    public Message.Label getLabel() {
        return this.label;
    }

    public static final class Builder<T extends ExtendableMessage<?>, E> {
        private final Class<T> extendedType;
        private final Class<? extends Message> messageType;
        private final Class<? extends ProtoEnum> enumType;
        private final Message.Datatype datatype;
        private String name = null;
        private int tag = -1;
        private Message.Label label = null;

        private Builder(Class<T> clazz, Message.Datatype datatype) {
            this.extendedType = clazz;
            this.messageType = null;
            this.enumType = null;
            this.datatype = datatype;
        }

        private Builder(Class<T> clazz, Class<? extends Message> clazz2, Class<? extends ProtoEnum> clazz3, Message.Datatype datatype) {
            this.extendedType = clazz;
            this.messageType = clazz2;
            this.enumType = clazz3;
            this.datatype = datatype;
        }

        public Builder<T, E> setName(String string) {
            this.name = string;
            return this;
        }

        public Builder<T, E> setTag(int n2) {
            this.tag = n2;
            return this;
        }

        public Extension<T, E> buildOptional() {
            this.label = Message.Label.OPTIONAL;
            this.validate();
            return new Extension(this.extendedType, this.messageType, this.enumType, this.name, this.tag, this.label, this.datatype);
        }

        public Extension<T, E> buildRequired() {
            this.label = Message.Label.REQUIRED;
            this.validate();
            return new Extension(this.extendedType, this.messageType, this.enumType, this.name, this.tag, this.label, this.datatype);
        }

        public Extension<T, List<E>> buildRepeated() {
            this.label = Message.Label.REPEATED;
            this.validate();
            return new Extension(this.extendedType, this.messageType, this.enumType, this.name, this.tag, this.label, this.datatype);
        }

        public Extension<T, List<E>> buildPacked() {
            this.label = Message.Label.PACKED;
            this.validate();
            return new Extension(this.extendedType, this.messageType, this.enumType, this.name, this.tag, this.label, this.datatype);
        }

        private void validate() {
            if (this.extendedType == null) {
                throw new IllegalArgumentException("extendedType == null");
            }
            if (this.name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (this.datatype == null) {
                throw new IllegalArgumentException("datatype == null");
            }
            if (this.label == null) {
                throw new IllegalArgumentException("label == null");
            }
            if (this.tag <= 0) {
                throw new IllegalArgumentException("tag == " + this.tag);
            }
            if (this.datatype == Message.Datatype.MESSAGE) {
                if (this.messageType == null || this.enumType != null) {
                    throw new IllegalStateException("Message w/o messageType or w/ enumType");
                }
            } else if (this.datatype == Message.Datatype.ENUM) {
                if (this.messageType != null || this.enumType == null) {
                    throw new IllegalStateException("Enum w/ messageType or w/o enumType");
                }
            } else if (this.messageType != null || this.enumType != null) {
                throw new IllegalStateException("Scalar w/ messageType or enumType");
            }
        }
    }
}

