/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Extension;
import com.squareup.wire.ExtensionMap;
import com.squareup.wire.Message;
import java.util.Collections;
import java.util.List;

public abstract class ExtendableMessage<T extends ExtendableMessage<?>>
extends Message {
    private static final long serialVersionUID = 0L;
    transient ExtensionMap<T> extensionMap;

    protected ExtendableMessage() {
    }

    protected void setBuilder(ExtendableBuilder<T> extendableBuilder) {
        super.setBuilder(extendableBuilder);
        if (extendableBuilder.extensionMap != null) {
            this.extensionMap = new ExtensionMap(extendableBuilder.extensionMap);
        }
    }

    public List<Extension<T, ?>> getExtensions() {
        return this.extensionMap == null ? Collections.emptyList() : this.extensionMap.getExtensions();
    }

    public <E> E getExtension(Extension<T, E> extension) {
        return this.extensionMap == null ? null : (E)this.extensionMap.get(extension);
    }

    protected boolean extensionsEqual(ExtendableMessage<T> extendableMessage) {
        if (this.extensionMap == null) {
            return extendableMessage.extensionMap == null;
        }
        return this.extensionMap.equals(extendableMessage.extensionMap);
    }

    protected int extensionsHashCode() {
        return this.extensionMap == null ? 0 : this.extensionMap.hashCode();
    }

    String extensionsToString() {
        return this.extensionMap == null ? "{}" : this.extensionMap.toString();
    }

    public static abstract class ExtendableBuilder<T extends ExtendableMessage<?>>
    extends Message.Builder<T> {
        ExtensionMap<T> extensionMap;

        protected ExtendableBuilder() {
        }

        protected ExtendableBuilder(ExtendableMessage<T> extendableMessage) {
            super(extendableMessage);
            if (extendableMessage != null && extendableMessage.extensionMap != null) {
                this.extensionMap = new ExtensionMap(extendableMessage.extensionMap);
            }
        }

        public <E> E getExtension(Extension<T, E> extension) {
            return this.extensionMap == null ? null : (E)this.extensionMap.get(extension);
        }

        public <E> ExtendableBuilder<T> setExtension(Extension<T, E> extension, E e2) {
            if (this.extensionMap == null) {
                this.extensionMap = new ExtensionMap<T>(extension, e2);
            } else {
                this.extensionMap.put(extension, e2);
            }
            return this;
        }
    }
}

