/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.ProtoEnum;
import java.util.Arrays;
import java.util.Comparator;

final class EnumAdapter<E extends ProtoEnum> {
    private static final Comparator<ProtoEnum> COMPARATOR = new Comparator<ProtoEnum>(){

        @Override
        public int compare(ProtoEnum protoEnum, ProtoEnum protoEnum2) {
            return protoEnum.getValue() - protoEnum2.getValue();
        }
    };
    private final Class<E> type;
    private final int[] values;
    private final E[] constants;
    private final boolean isDense;

    EnumAdapter(Class<E> clazz) {
        this.type = clazz;
        this.constants = (ProtoEnum[])clazz.getEnumConstants();
        Arrays.sort(this.constants, COMPARATOR);
        int n2 = this.constants.length;
        if (this.constants[0].getValue() == 1 && this.constants[n2 - 1].getValue() == n2) {
            this.isDense = true;
            this.values = null;
        } else {
            this.isDense = false;
            this.values = new int[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.values[i2] = this.constants[i2].getValue();
            }
        }
    }

    public int toInt(E e2) {
        return e2.getValue();
    }

    public E fromInt(int n2) {
        int n3 = this.isDense ? n2 - 1 : Arrays.binarySearch(this.values, n2);
        try {
            return this.constants[n3];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Unknown enum tag " + n2 + " for " + this.type.getCanonicalName());
        }
    }
}

