/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class BuilderAdapter<B extends Message.Builder> {
    private static final int SUFFIX_LENGTH = "$Builder".length();
    private static final Comparator<Field> ORDER_BY_FIELD_NAME = new Comparator<Field>(){

        @Override
        public int compare(Field field, Field field2) {
            return field.getName().compareTo(field2.getName());
        }
    };
    private final List<Field> requiredFields = new ArrayList<Field>();

    public BuilderAdapter(Class<B> clazz) {
        Class<?> clazz2;
        String string = clazz.getName();
        String string2 = string.substring(0, string.length() - SUFFIX_LENGTH);
        try {
            clazz2 = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)("No message class found for builder type " + string));
        }
        for (Field field : clazz2.getDeclaredFields()) {
            ProtoField protoField = field.getAnnotation(ProtoField.class);
            if (protoField == null || protoField.label() != Message.Label.REQUIRED) continue;
            try {
                this.requiredFields.add(clazz.getField(field.getName()));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError((Object)("No builder field found for message field " + field.getName()));
            }
        }
        Collections.sort(this.requiredFields, ORDER_BY_FIELD_NAME);
    }

    public <B extends Message.Builder> void checkRequiredFields(B b2) {
        StringBuilder stringBuilder = null;
        String string = "";
        try {
            int n2 = this.requiredFields.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Field field = this.requiredFields.get(i2);
                if (field.get(b2) != null) continue;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else {
                    string = "s";
                }
                stringBuilder.append("\n  ");
                stringBuilder.append(field.getName());
            }
            if (stringBuilder != null) {
                throw new IllegalStateException("Required field" + string + " not set:" + stringBuilder);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)"Unable to access required fields");
        }
    }
}

