/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u7535\u5b50\u4e66\u9605\u8bfb\u5668\u7c7b\u5e93;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.Vector;

public class BookPageFactory {
    private File book_file = null;
    private MappedByteBuffer m_mbBuf = null;
    private int m_mbBufLen = 0;
    private int m_mbBufBegin = 0;
    private int m_mbBufEnd = 0;
    private String m_strCharsetName = "GBK";
    private Bitmap m_book_bg = null;
    private int mWidth;
    private int mHeight;
    private int \u603b\u9875\u6570 = 0;
    private boolean \u663e\u793a\u9875\u7801;
    private Vector<String> m_lines = new Vector();
    private float m_fontSize = 24.0f;
    private int m_textColor = -16777216;
    private int m_backColor = 0;
    private int marginWidth = 15;
    private int marginHeight = 20;
    private int mLineCount;
    private float mVisibleHeight;
    private float mVisibleWidth;
    private boolean m_isfirstPage;
    private boolean m_islastPage;
    private Paint mPaint;
    DecimalFormat df = new DecimalFormat("##.##");

    public BookPageFactory(float f, int n, int n2, int n3, boolean bl) {
        this.m_fontSize = f;
        this.m_textColor = n;
        this.mWidth = n2;
        this.mHeight = n3;
        this.\u603b\u9875\u6570 = 0;
        this.\u663e\u793a\u9875\u7801 = bl;
        this.mPaint = new Paint(1);
        this.mPaint.setTextAlign(Paint.Align.LEFT);
        this.mPaint.setTextSize(this.m_fontSize);
        this.mPaint.setColor(this.m_textColor);
        this.mVisibleWidth = this.mWidth - this.marginWidth * 2;
        this.mVisibleHeight = this.mHeight - this.marginHeight * 2;
        this.mLineCount = (int)(this.mVisibleHeight / this.m_fontSize) - 1;
    }

    public void openbook(String string) {
        try {
            this.book_file = new File(string);
            long l = this.book_file.length();
            this.m_mbBufLen = (int)l;
            this.m_mbBuf = new RandomAccessFile(this.book_file, "r").getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, l);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected byte[] readParagraphBack(int n) {
        byte by;
        byte by2;
        int n2;
        int n3 = n;
        if (this.m_strCharsetName.equals("UTF-16LE")) {
            for (n2 = n3 - 2; n2 > 0; --n2) {
                by2 = this.m_mbBuf.get(n2);
                by = this.m_mbBuf.get(n2 + 1);
                if (by2 != 10 || by != 0 || n2 == n3 - 2) continue;
                n2 += 2;
                break;
            }
        } else if (this.m_strCharsetName.equals("UTF-16BE")) {
            for (n2 = n3 - 2; n2 > 0; --n2) {
                by2 = this.m_mbBuf.get(n2);
                by = this.m_mbBuf.get(n2 + 1);
                if (by2 != 0 || by != 10 || n2 == n3 - 2) continue;
                n2 += 2;
                break;
            }
        } else {
            for (n2 = n3 - 1; n2 > 0; --n2) {
                by2 = this.m_mbBuf.get(n2);
                if (by2 != 10 || n2 == n3 - 1) continue;
                ++n2;
                break;
            }
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n3 - n2;
        byte[] byArray = new byte[n4];
        for (int i = 0; i < n4; ++i) {
            byArray[i] = this.m_mbBuf.get(n2 + i);
        }
        return byArray;
    }

    protected byte[] readParagraphForward(int n) {
        byte by;
        byte by2;
        int n2;
        int n3 = n2 = n;
        if (this.m_strCharsetName.equals("UTF-16LE")) {
            while (n3 < this.m_mbBufLen - 1) {
                by2 = this.m_mbBuf.get(n3++);
                by = this.m_mbBuf.get(n3++);
                if (by2 != 10 || by != 0) continue;
                break;
            }
        } else if (this.m_strCharsetName.equals("UTF-16BE")) {
            while (n3 < this.m_mbBufLen - 1) {
                by2 = this.m_mbBuf.get(n3++);
                by = this.m_mbBuf.get(n3++);
                if (by2 != 0 || by != 10) continue;
                break;
            }
        } else {
            while (n3 < this.m_mbBufLen && (by2 = this.m_mbBuf.get(n3++)) != 10) {
            }
        }
        int n4 = n3 - n2;
        byte[] byArray = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray[n3] = this.m_mbBuf.get(n + n3);
        }
        return byArray;
    }

    protected Vector<String> pageDown() {
        String string = "";
        Vector<String> vector = new Vector<String>();
        while (vector.size() < this.mLineCount && this.m_mbBufEnd < this.m_mbBufLen) {
            byte[] byArray = this.readParagraphForward(this.m_mbBufEnd);
            this.m_mbBufEnd += byArray.length;
            try {
                string = new String(byArray, this.m_strCharsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            String string2 = "";
            if (string.indexOf("\r\n") != -1) {
                string2 = "\r\n";
                string = string.replaceAll("\r\n", "");
            } else if (string.indexOf("\n") != -1) {
                string2 = "\n";
                string = string.replaceAll("\n", "");
            }
            if (string.length() == 0) {
                vector.add(string);
            }
            while (string.length() > 0) {
                int n = this.mPaint.breakText(string, true, this.mVisibleWidth, null);
                vector.add(string.substring(0, n));
                string = string.substring(n);
                if (vector.size() < this.mLineCount) continue;
                break;
            }
            if (string.length() == 0) continue;
            try {
                this.m_mbBufEnd -= (string + string2).getBytes(this.m_strCharsetName).length;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return vector;
    }

    protected void pageUp() {
        if (this.m_mbBufBegin < 0) {
            this.m_mbBufBegin = 0;
        }
        Vector vector = new Vector();
        String string = "";
        while (vector.size() < this.mLineCount && this.m_mbBufBegin > 0) {
            Vector<String> vector2 = new Vector<String>();
            byte[] byArray = this.readParagraphBack(this.m_mbBufBegin);
            this.m_mbBufBegin -= byArray.length;
            try {
                string = new String(byArray, this.m_strCharsetName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            string = string.replaceAll("\r\n", "");
            string = string.replaceAll("\n", "");
            if (string.length() == 0) {
                vector2.add(string);
            }
            while (string.length() > 0) {
                int n = this.mPaint.breakText(string, true, this.mVisibleWidth, null);
                vector2.add(string.substring(0, n));
                string = string.substring(n);
            }
            vector.addAll(0, vector2);
        }
        while (vector.size() > this.mLineCount) {
            try {
                this.m_mbBufBegin += ((String)vector.get(0)).getBytes(this.m_strCharsetName).length;
                vector.remove(0);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        this.m_mbBufEnd = this.m_mbBufBegin;
    }

    protected void prePage() {
        if (this.m_mbBufBegin <= 0) {
            this.m_mbBufBegin = 0;
            this.m_isfirstPage = true;
            return;
        }
        this.m_isfirstPage = false;
        this.m_lines.clear();
        this.pageUp();
        this.m_lines = this.pageDown();
    }

    public void nextPage() {
        if (this.m_mbBufEnd >= this.m_mbBufLen) {
            this.m_islastPage = true;
            return;
        }
        this.m_islastPage = false;
        this.m_lines.clear();
        this.m_mbBufBegin = this.m_mbBufEnd;
        this.m_lines = this.pageDown();
    }

    public void onDraw(Canvas canvas) {
        if (this.m_lines.size() == 0) {
            this.m_lines = this.pageDown();
        }
        if (this.m_lines.size() > 0) {
            if (this.m_book_bg == null) {
                canvas.drawColor(this.m_backColor);
            } else {
                canvas.drawBitmap(this.m_book_bg, 0.0f, 0.0f, null);
            }
            int n = this.marginHeight;
            for (String string : this.m_lines) {
                n = (int)((float)n + this.m_fontSize);
                canvas.drawText(string, (float)this.marginWidth, (float)n, this.mPaint);
            }
        }
        ++this.\u603b\u9875\u6570;
        if (this.\u663e\u793a\u9875\u7801) {
            String string = "\u7b2c" + this.\u603b\u9875\u6570 + "\u9875";
            int n = (int)this.mPaint.measureText(string + "  ");
            int n2 = (int)this.mPaint.measureText("\u7b2c") / 2;
            canvas.drawText(string, (float)(this.mWidth - n), (float)(this.mHeight - n2), this.mPaint);
        }
    }

    public void setBgBitmap(Bitmap bitmap) {
        this.m_book_bg = bitmap;
    }

    public boolean isfirstPage() {
        return this.m_isfirstPage;
    }

    public boolean islastPage() {
        return this.m_islastPage;
    }
}

