/*
 * Decompiled with CFR 0.152.
 */
package com.mob.wrappers;

import android.os.Handler;
import android.os.Message;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.PlatformActionListener;
import cn.sharesdk.framework.ShareSDK;
import cn.sharesdk.onekeyshare.OnekeyShare;
import com.mob.MobSDK;
import com.mob.tools.proguard.PublicMemberKeeper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.UIHandler;
import java.lang.reflect.Field;
import java.util.HashMap;

public class ShareSDKWrapper
implements PublicMemberKeeper {
    private static int state;

    private static synchronized boolean isAvailable() {
        if (state == 0) {
            try {
                ReflectHelper.importClass((String)"cn.sharesdk.framework.ShareSDK");
                state = 1;
            }
            catch (Throwable t) {
                state = -1;
            }
        }
        return state == 1;
    }

    public static String[] getPlatformList() {
        Platform[] platforms;
        String[] names = null;
        if (ShareSDKWrapper.isAvailable() && (platforms = ShareSDK.getPlatformList()) != null) {
            names = new String[platforms.length];
            for (int i = 0; i < platforms.length; ++i) {
                names[i] = platforms[i].getName();
            }
        }
        return names;
    }

    public static void login(final String platform, final CallbackWrapper callback) {
        if (ShareSDKWrapper.isAvailable()) {
            Platform plat = ShareSDK.getPlatform((String)platform);
            if (plat == null) {
                UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                    public boolean handleMessage(Message msg) {
                        Throwable t = new Throwable("platform " + platform + " is not exist or disable");
                        callback.onError(platform, 8, t);
                        return false;
                    }
                });
            } else {
                plat.showUser(null);
                if (callback != null) {
                    plat.setPlatformActionListener(new PlatformActionListener(){

                        public void onComplete(Platform platform, int i, HashMap<String, Object> r) {
                            callback.onComplete(platform.getName(), i, r);
                        }

                        public void onError(Platform platform, int i, Throwable t) {
                            callback.onError(platform.getName(), i, t);
                        }

                        public void onCancel(Platform platform, int i) {
                            callback.onCancel(platform.getName(), i);
                        }
                    });
                }
            }
        } else if (callback != null) {
            UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    Throwable t = new Throwable("platform " + platform + " is not exist or disable");
                    callback.onError(platform, 8, t);
                    return false;
                }
            });
        }
    }

    public static void logout(String platform) {
        Platform plat;
        if (ShareSDKWrapper.isAvailable() && (plat = ShareSDK.getPlatform((String)platform)) != null) {
            plat.removeAccount(true);
        }
    }

    public static int getPlatformToId(String platform) {
        if (ShareSDKWrapper.isAvailable()) {
            return ShareSDK.platformNameToId((String)platform);
        }
        return 0;
    }

    public static String getDbData(String platform) {
        Platform plat;
        String dbData = null;
        if (ShareSDKWrapper.isAvailable() && (plat = ShareSDK.getPlatform((String)platform)) != null) {
            dbData = plat.getDb().exportData();
        }
        return dbData;
    }

    public static String getToken(String platform) {
        Platform plat;
        String token = null;
        if (ShareSDKWrapper.isAvailable() && (plat = ShareSDK.getPlatform((String)platform)) != null) {
            token = plat.getDb().getToken();
        }
        return token;
    }

    public static String getUserID(String platform) {
        Platform plat;
        String userId = null;
        if (ShareSDKWrapper.isAvailable() && (plat = ShareSDK.getPlatform((String)platform)) != null) {
            userId = plat.getDb().getUserId();
        }
        return userId;
    }

    public static String getUserName(String platform) {
        Platform plat;
        String userName = null;
        if (ShareSDKWrapper.isAvailable() && (plat = ShareSDK.getPlatform((String)platform)) != null) {
            userName = plat.getDb().getUserName();
        }
        return userName;
    }

    public static boolean isLogin(String platform) {
        Platform plat;
        boolean state = false;
        if (ShareSDKWrapper.isAvailable() && (plat = ShareSDK.getPlatform((String)platform)) != null) {
            state = plat.isAuthValid();
        }
        return state;
    }

    public static void share(final String platform, HashMap<String, Object> shareParams, final CallbackWrapper callback) {
        if (ShareSDKWrapper.isAvailable()) {
            Platform plat = ShareSDK.getPlatform((String)platform);
            if (plat == null) {
                UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                    public boolean handleMessage(Message msg) {
                        Throwable t = new Throwable("platform " + platform + " is not exist or disable");
                        callback.onError(platform, 9, t);
                        return false;
                    }
                });
            } else {
                Platform.ShareParams sp = new Platform.ShareParams(shareParams);
                if (callback != null) {
                    plat.setPlatformActionListener(new PlatformActionListener(){

                        public void onComplete(Platform platform, int i, HashMap<String, Object> r) {
                            callback.onComplete(platform.getName(), i, r);
                        }

                        public void onError(Platform platform, int i, Throwable t) {
                            callback.onError(platform.getName(), i, t);
                        }

                        public void onCancel(Platform platform, int i) {
                            callback.onCancel(platform.getName(), i);
                        }
                    });
                }
                plat.share(sp);
            }
        } else if (callback != null) {
            UIHandler.sendEmptyMessage((int)0, (Handler.Callback)new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    Throwable t = new Throwable("platform " + platform + " is not exist or disable");
                    callback.onError(platform, 9, t);
                    return false;
                }
            });
        }
    }

    private static boolean isOneKeyShareAvailable() {
        try {
            ReflectHelper.importClass((String)"cn.sharesdk.onekeyshare.OnekeyShare");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void oneKeyShare(String platform, HashMap<String, Object> shareParams, final CallbackWrapper callback) {
        if (ShareSDKWrapper.isOneKeyShareAvailable()) {
            OnekeyShare oks = new OnekeyShare();
            if (platform != null) {
                oks.setPlatform(platform);
            }
            if (callback != null) {
                oks.setCallback(new PlatformActionListener(){

                    public void onComplete(Platform platform, int i, HashMap<String, Object> r) {
                        callback.onComplete(platform.getName(), i, r);
                    }

                    public void onError(Platform platform, int i, Throwable t) {
                        callback.onError(platform.getName(), i, t);
                    }

                    public void onCancel(Platform platform, int i) {
                        callback.onCancel(platform.getName(), i);
                    }
                });
            }
            for (Field fld : oks.getClass().getDeclaredFields()) {
                if (!HashMap.class.isAssignableFrom(fld.getType())) continue;
                try {
                    fld.setAccessible(true);
                    HashMap map = (HashMap)fld.get(oks);
                    map.putAll(shareParams);
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            oks.show(MobSDK.getContext());
        }
    }

    public static void oneKeyShare(HashMap<String, Object> shareParams, CallbackWrapper callback) {
        ShareSDKWrapper.oneKeyShare(null, shareParams, callback);
    }

    public static interface CallbackWrapper {
        public void onComplete(String var1, int var2, HashMap<String, Object> var3);

        public void onError(String var1, int var2, Throwable var3);

        public void onCancel(String var1, int var2);
    }
}

