/*
 * Decompiled with CFR 0.152.
 */
package com.mob.wrappers;

import com.mob.analysdk.AnalySDK;
import com.mob.analysdk.User;
import com.mob.tools.proguard.PublicMemberKeeper;
import com.mob.tools.utils.ReflectHelper;
import java.util.Date;
import java.util.HashMap;

public class AnalySDKWrapper
implements PublicMemberKeeper {
    private static int state;

    private static synchronized boolean isAvailable() {
        if (state == 0) {
            try {
                ReflectHelper.importClass((String)"com.mob.analysdk.AnalySDK");
                state = 1;
            }
            catch (Throwable t) {
                state = -1;
            }
        }
        return state == 1;
    }

    public static Location setLocation() {
        return new Location();
    }

    public static Event trackEvent() {
        return new Event();
    }

    public static User identifyUser() {
        return new User();
    }

    public static enum GenderWrapper {
        Man,
        Woman;

    }

    public static final class User
    extends MapCreator<User, String, String>
    implements PublicMemberKeeper {
        private String userId;
        private String name;
        private Date birthday;
        private GenderWrapper gender;
        private Date firstAccessTime;
        private String retistryChannel;
        private String country;
        private String province;
        private String city;
        private long registryTime;

        private User() {
        }

        public User withID(String userId) {
            this.userId = userId;
            return this;
        }

        public User setName(String name) {
            this.name = name;
            return this;
        }

        public User setBirthday(Date birthday) {
            this.birthday = birthday;
            return this;
        }

        public User setGender(GenderWrapper gender) {
            this.gender = gender;
            return this;
        }

        public User setFirstAccessTime(Date firstAccessTime) {
            this.firstAccessTime = firstAccessTime;
            return this;
        }

        public User setRetistryChannel(String retistryChannel) {
            this.retistryChannel = retistryChannel;
            return this;
        }

        public User setCountry(String country) {
            this.country = country;
            return this;
        }

        public User setProvince(String province) {
            this.province = province;
            return this;
        }

        public User setCity(String city) {
            this.city = city;
            return this;
        }

        public User setRegistryTime(long registryTime) {
            this.registryTime = registryTime;
            return this;
        }

        @Override
        public void commit() {
            if (AnalySDKWrapper.isAvailable()) {
                com.mob.analysdk.User user = new com.mob.analysdk.User();
                user.name = this.name;
                user.birthday = this.birthday;
                if (this.gender == GenderWrapper.Man) {
                    user.gender = User.Gender.Man;
                } else if (this.gender == GenderWrapper.Woman) {
                    user.gender = User.Gender.Woman;
                }
                user.firstAccessTime = this.firstAccessTime;
                user.retistryChannel = this.retistryChannel;
                user.country = this.country;
                user.province = this.province;
                user.city = this.city;
                user.registryTime = this.registryTime;
                user.others = this.map;
                AnalySDK.identifyUser((String)this.userId, (com.mob.analysdk.User)user);
            }
        }
    }

    public static final class Event
    extends MapCreator<Event, String, Object>
    implements PublicMemberKeeper {
        private String eventName;

        private Event() {
        }

        public Event withName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        @Override
        public void commit() {
            if (AnalySDKWrapper.isAvailable()) {
                if (this.map.isEmpty()) {
                    AnalySDK.trackEvent((String)this.eventName);
                } else {
                    AnalySDK.trackEvent((String)this.eventName, (HashMap)this.map);
                }
            }
        }
    }

    public static final class MapItem<CreatorClass extends MapCreator, K, V>
    implements PublicMemberKeeper {
        private MapCreator creator;
        private K fieldName;

        private MapItem(MapCreator creator, K fieldName) {
            this.creator = creator;
            this.fieldName = fieldName;
        }

        public CreatorClass widthValue(V value) {
            this.creator.map.put(this.fieldName, value);
            return (CreatorClass)this.creator;
        }
    }

    private static abstract class MapCreator<SubClass extends MapCreator, K, V>
    implements Committer {
        protected HashMap<K, V> map = new HashMap();

        public MapItem<SubClass, K, V> setField(K fieldName) {
            return new MapItem(this, fieldName);
        }
    }

    public static final class Location
    implements Committer,
    PublicMemberKeeper {
        private double longitude;
        private double latitude;

        private Location() {
        }

        public Location longitude(double longitude) {
            this.longitude = longitude;
            return this;
        }

        public Location latitude(double latitude) {
            this.latitude = latitude;
            return this;
        }

        @Override
        public void commit() {
            if (AnalySDKWrapper.isAvailable()) {
                AnalySDK.setLocation((double)this.longitude, (double)this.latitude);
            }
        }
    }

    private static interface Committer {
        public void commit();
    }
}

