/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.config.BuiltInProperties;
import com.sun.deploy.config.ClientConfig;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;

public class SecurityBaseline {
    private static String baseline_131 = "1.3.1_21";
    private static String baseline_142 = "1.4.2_41";
    private static String baseline_150 = "1.5.0_39";
    private static String baseline_160 = "1.6.0_39";
    private static String baseline_170 = "1.7.0_13";
    private static String baseline_180 = "1.8.0";
    private static boolean baselines_initialized = false;
    private static final boolean DEBUG = Config.getBooleanProperty("deployment.baseline.debug");
    private static final long UPDATE_INTERVAL = DEBUG ? 10000 : 604800000;
    private static final long THREAD_SLEEP_INTERVAL = DEBUG ? 1000 : 30000;
    private static final String BASELINE_FILENAME = "baseline.versions";
    private static final String BASELINE_TIMESTAMP = "baseline.timestamp";
    private static final String UPDATE_TIMESTAMP = "update.timestamp";
    private static final File securityDir = new File(Config.getUserHome(), "security");
    private static final File baselineFile = new File(securityDir, "baseline.versions");
    private static final File baselineTimestampFile = new File(securityDir, "baseline.timestamp");
    private static final File updateTimestampFile = new File(securityDir, "update.timestamp");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initialize_baselines() {
        block20: {
            if (!baselines_initialized && baselineFile.exists()) {
                BufferedReader bufferedReader;
                block19: {
                    bufferedReader = null;
                    long l = System.currentTimeMillis();
                    bufferedReader = new BufferedReader(new FileReader(baselineFile));
                    boolean bl = false;
                    while (!bl) {
                        String string = bufferedReader.readLine();
                        if (string == null) {
                            bl = true;
                            continue;
                        }
                        if (string.startsWith("1.8")) {
                            baseline_180 = string;
                            Platform.get().cacheSecurityBaseline("1.8.0", baseline_180);
                            continue;
                        }
                        if (string.startsWith("1.7")) {
                            baseline_170 = string;
                            Platform.get().cacheSecurityBaseline("1.7.0", baseline_170);
                            continue;
                        }
                        if (string.startsWith("1.6")) {
                            baseline_160 = string;
                            Platform.get().cacheSecurityBaseline("1.6.0", baseline_160);
                            continue;
                        }
                        if (string.startsWith("1.5")) {
                            baseline_150 = string;
                            Platform.get().cacheSecurityBaseline("1.5.0", baseline_150);
                            continue;
                        }
                        if (string.startsWith("1.4.2")) {
                            baseline_142 = string;
                            Platform.get().cacheSecurityBaseline("1.4.2", baseline_142);
                            continue;
                        }
                        if (!string.startsWith("1.3.1")) continue;
                        baseline_131 = string;
                        Platform.get().cacheSecurityBaseline("1.3.1", baseline_131);
                    }
                    if (!DEBUG) break block19;
                    Trace.println("It took " + (System.currentTimeMillis() - l) + " Ms. to read baseline file", TraceLevel.BASIC);
                }
                Object var6_5 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block20;
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
                break block20;
                {
                    catch (Exception exception) {
                        Trace.ignored(exception);
                        Object var6_6 = null;
                        try {
                            if (bufferedReader != null) {
                                bufferedReader.close();
                            }
                            break block20;
                        }
                        catch (IOException iOException) {
                            Trace.ignored(iOException);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                    throw throwable;
                }
            }
        }
        baselines_initialized = true;
    }

    public static String getBaselineVersion(String string) {
        if (!baselines_initialized) {
            SecurityBaseline.initialize_baselines();
        }
        String string2 = string.startsWith("1.8") ? baseline_180 : (string.startsWith("1.7") ? baseline_170 : (string.startsWith("1.6") ? baseline_160 : (string.startsWith("1.5") ? baseline_150 : (string.startsWith("1.4.2") ? baseline_142 : (string.startsWith("1.3.1") ? baseline_131 : "1.7.0_13")))));
        if (DEBUG) {
            Trace.println("for requested version: " + string + "baseline version is: " + string2, TraceLevel.SECURITY);
        }
        return string2;
    }

    public static boolean satisfiesSecurityBaseline(String string) {
        VersionID versionID = new VersionID(string);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        if (versionID.isGreaterThanOrEqual(versionID2)) {
            return true;
        }
        return versionID.equals(JREInfo.getLatestVersion(false));
    }

    public static boolean satisfiesBaselineStrictly(String string) {
        int n = string.indexOf("-");
        String string2 = n > 0 ? string.substring(0, n) : string;
        VersionID versionID = new VersionID(string2);
        VersionID versionID2 = new VersionID(SecurityBaseline.getBaselineVersion(string));
        boolean bl = versionID.isGreaterThanOrEqual(versionID2);
        if (DEBUG) {
            Trace.println("strictly satisfied=" + bl + "  for version: " + string + "  baseline is: " + SecurityBaseline.getBaselineVersion(string));
        }
        return bl;
    }

    public static String getDeployVersion() {
        return "10.13.2.20";
    }

    public static String getDeployNoBuildVersion() {
        return "10.13.2";
    }

    public static String getDeployNoDotVersion() {
        return "10132";
    }

    public static String getCurrentVersion() {
        return "1.7.0_13";
    }

    public static String getCurrentNoDotVersion() {
        return "170";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized void checkForBaselineUpdates() {
        block27: {
            String string = Config.getStringProperty("deployment.baseline.url");
            if (string != null && string.length() > 0) {
                Serializable serializable2222;
                FileOutputStream fileOutputStream;
                InputStream inputStream;
                block25: {
                    long l = 0L;
                    if (baselineFile.exists()) {
                        l = baselineFile.lastModified();
                    }
                    inputStream = null;
                    fileOutputStream = null;
                    if (DEBUG) {
                        Trace.println("Checking for baseline at: " + string, TraceLevel.NETWORK);
                    }
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    if (uRLConnection.getLastModified() > l) {
                        int n;
                        Trace.println("Updating baseline file at: " + baselineFile + " from url: " + string, TraceLevel.NETWORK);
                        inputStream = uRLConnection.getInputStream();
                        fileOutputStream = new FileOutputStream(baselineFile);
                        byte[] byArray = new byte[8192];
                        while ((n = inputStream.read(byArray)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                    }
                    Object var10_9 = null;
                    if (fileOutputStream == null) break block25;
                    try {
                        fileOutputStream.close();
                        SecurityBaseline.initialize_baselines();
                        if (SecurityBaseline.isExpired() && (serializable2222 = Config.get()) instanceof ClientConfig) {
                            ((ClientConfig)serializable2222).storeConfig();
                        }
                    }
                    catch (Exception serializable2222) {
                        Trace.ignored(serializable2222);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception serializable2222) {
                        Trace.ignored(serializable2222);
                    }
                }
                break block27;
                {
                    catch (Exception exception) {
                        Serializable serializable32222;
                        Trace.ignored(exception);
                        Object var10_10 = null;
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                                SecurityBaseline.initialize_baselines();
                                if (SecurityBaseline.isExpired() && (serializable32222 = Config.get()) instanceof ClientConfig) {
                                    ((ClientConfig)serializable32222).storeConfig();
                                }
                            }
                            catch (Exception serializable32222) {
                                Trace.ignored(serializable32222);
                            }
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception serializable32222) {
                                Trace.ignored(serializable32222);
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Serializable serializable42222;
                    Object var10_11 = null;
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                            SecurityBaseline.initialize_baselines();
                            if (SecurityBaseline.isExpired() && (serializable42222 = Config.get()) instanceof ClientConfig) {
                                ((ClientConfig)serializable42222).storeConfig();
                            }
                        }
                        catch (Exception serializable42222) {
                            Trace.ignored(serializable42222);
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception serializable42222) {
                            Trace.ignored(serializable42222);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }

    private static long getLastChecked() {
        if (baselineTimestampFile.exists()) {
            return baselineTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastChecked(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(baselineTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static long getLastUpdateNag() {
        if (updateTimestampFile.exists()) {
            return updateTimestampFile.lastModified();
        }
        return 0L;
    }

    private static void setLastUpdateNag(long l) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(updateTimestampFile);
            ((OutputStream)fileOutputStream).write(46);
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void backgroundBaselineUpdate() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                long l = new Date().getTime();
                if (l > SecurityBaseline.getLastChecked() + UPDATE_INTERVAL) {
                    try {
                        Thread.sleep(THREAD_SLEEP_INTERVAL);
                        SecurityBaseline.checkForBaselineUpdates();
                        SecurityBaseline.setLastChecked(l);
                    }
                    catch (Exception exception) {
                        Trace.ignored(exception);
                    }
                }
                if (DEBUG) {
                    Trace.println("Baseline thread exiting time: " + (new Date().getTime() - l), TraceLevel.BASIC);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    public static void forceBaselineUpdate() {
        SecurityBaseline.checkForBaselineUpdates();
        SecurityBaseline.initialize_baselines();
        SecurityBaseline.setLastChecked(new Date().getTime());
    }

    public static boolean isExpired() {
        Date date;
        if (Config.isJavaVersionAtLeast15()) {
            if (System.getenv("JRE_NOTEXPIRED") != null) {
                return false;
            }
            if (System.getenv("JRE_EXPIRED") != null) {
                return true;
            }
        }
        if ((date = new Date(BuiltInProperties.expirationTime)).before(new Date())) {
            return true;
        }
        return !SecurityBaseline.satisfiesBaselineStrictly(JREInfo.getLatest());
    }

    static {
        securityDir.mkdirs();
        SecurityBaseline.backgroundBaselineUpdate();
    }
}

