/*
 * Decompiled with CFR 0.152.
 */
package com.e4a.runtime.components.impl.android.\u4e0b\u8f7d\u5668\u66f4\u65b0\u7248\u7c7b\u5e93;

import android.content.Context;
import android.database.Cursor;
import com.e4a.runtime.android.mainActivity;
import com.e4a.runtime.components.ComponentContainer;
import com.e4a.runtime.components.impl.ComponentImpl;
import com.e4a.runtime.components.impl.android.\u4e0b\u8f7d\u5668\u66f4\u65b0\u7248\u7c7b\u5e93.DownloadInfo;
import com.e4a.runtime.components.impl.android.\u4e0b\u8f7d\u5668\u66f4\u65b0\u7248\u7c7b\u5e93.\u4e0b\u8f7d\u5668\u66f4\u65b0\u7248;
import com.e4a.runtime.events.EventDispatcher;
import com.lidroid.xutils.DbUtils;
import com.lidroid.xutils.HttpUtils;
import com.lidroid.xutils.db.converter.ColumnConverter;
import com.lidroid.xutils.db.converter.ColumnConverterFactory;
import com.lidroid.xutils.db.sqlite.ColumnDbType;
import com.lidroid.xutils.db.sqlite.Selector;
import com.lidroid.xutils.exception.DbException;
import com.lidroid.xutils.exception.HttpException;
import com.lidroid.xutils.http.HttpHandler;
import com.lidroid.xutils.http.ResponseInfo;
import com.lidroid.xutils.http.callback.RequestCallBack;
import com.lidroid.xutils.util.LogUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class \u4e0b\u8f7d\u5668\u66f4\u65b0\u7248Impl
extends ComponentImpl
implements \u4e0b\u8f7d\u5668\u66f4\u65b0\u7248 {
    private DownloadManager downloadManager;

    public \u4e0b\u8f7d\u5668\u66f4\u65b0\u7248Impl(ComponentContainer componentContainer) {
        super(componentContainer);
    }

    @Override
    public void \u521d\u59cb\u5316() {
        this.downloadManager = new DownloadManager((Context)mainActivity.getContext());
        this.downloadManager.setMaxDownloadThread(1);
    }

    @Override
    public void \u7f6e\u4efb\u52a1\u6570(int n) {
        this.downloadManager.setMaxDownloadThread(n);
    }

    @Override
    public void \u6682\u505c\u6240\u6709\u4efb\u52a1() {
        try {
            this.downloadManager.stopAllDownload();
        }
        catch (DbException dbException) {
            // empty catch block
        }
    }

    @Override
    public void \u6682\u505c\u5355\u4e2a\u4efb\u52a1(int n) {
        if (n <= this.downloadManager.getDownloadInfoListCount() - 1) {
            try {
                this.downloadManager.stopDownload(n);
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
    }

    @Override
    public void \u5220\u9664\u4e0b\u8f7d\u4efb\u52a1(int n) {
        if (n <= this.downloadManager.getDownloadInfoListCount() - 1) {
            try {
                this.downloadManager.removeDownload(n);
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
    }

    @Override
    public String \u53d6\u4efb\u52a1\u4fe1\u606f(int n, String string) {
        DownloadInfo downloadInfo = null;
        String string2 = "";
        if (n <= this.downloadManager.getDownloadInfoListCount() - 1) {
            downloadInfo = this.downloadManager.getDownloadInfo(n);
            String string3 = downloadInfo.getDownloadUrl();
            String string4 = downloadInfo.getFileSavePath();
            String string5 = downloadInfo.getFileName();
            string2 = string5 + string + string4 + string + string3;
        }
        return string2;
    }

    @Override
    public void \u6062\u590d\u4e0b\u8f7d\u4efb\u52a1(int n) {
        if (n <= this.downloadManager.getDownloadInfoListCount() - 1) {
            try {
                this.downloadManager.resumeDownload(n, (RequestCallBack<File>)new \u8fdb\u5ea6());
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
    }

    @Override
    public int \u6dfb\u52a0\u4e0b\u8f7d\u4efb\u52a1(String string, String string2, String string3) {
        int n = 0;
        try {
            n = this.downloadManager.addNewDownload(string, string3, string2 + "/" + string3, true, false, new \u8fdb\u5ea6());
        }
        catch (DbException dbException) {
            // empty catch block
        }
        return n - 1;
    }

    @Override
    public void \u4efb\u52a1\u8fdb\u5ea6\u6539\u53d8(long l, long l2, long l3) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u4efb\u52a1\u8fdb\u5ea6\u6539\u53d8", (Object[])new Object[]{l, l2, l3});
    }

    @Override
    public void \u5f00\u59cb\u4e0b\u8f7d\u6570\u636e(long l) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u5f00\u59cb\u4e0b\u8f7d\u6570\u636e", (Object[])new Object[]{l});
    }

    @Override
    public void \u4efb\u52a1\u4e0b\u8f7d\u5b8c\u6bd5(long l, boolean bl) {
        EventDispatcher.dispatchEvent((Object)this, (String)"\u4efb\u52a1\u4e0b\u8f7d\u5b8c\u6bd5", (Object[])new Object[]{l, bl});
    }

    class DownloadManager {
        private List<DownloadInfo> downloadInfoList;
        private int maxDownloadThread = 3;
        private Context mContext;
        private DbUtils db;

        DownloadManager(Context context) {
            ColumnConverterFactory.registerColumnConverter(HttpHandler.State.class, (ColumnConverter)new HttpHandlerStateConverter());
            this.mContext = context;
            this.db = DbUtils.create((Context)this.mContext);
            try {
                this.downloadInfoList = this.db.findAll(Selector.from(DownloadInfo.class));
            }
            catch (DbException dbException) {
                LogUtils.e((String)dbException.getMessage(), (Throwable)dbException);
            }
            if (this.downloadInfoList == null) {
                this.downloadInfoList = new ArrayList<DownloadInfo>();
            }
        }

        public int getDownloadInfoListCount() {
            return this.downloadInfoList.size();
        }

        public DownloadInfo getDownloadInfo(int n) {
            return this.downloadInfoList.get(n);
        }

        public int addNewDownload(String string, String string2, String string3, boolean bl, boolean bl2, RequestCallBack<File> requestCallBack) throws DbException {
            DownloadInfo downloadInfo = new DownloadInfo();
            downloadInfo.setDownloadUrl(string);
            downloadInfo.setAutoRename(bl2);
            downloadInfo.setAutoResume(bl);
            downloadInfo.setFileName(string2);
            downloadInfo.setFileSavePath(string3);
            HttpUtils httpUtils = new HttpUtils();
            httpUtils.configRequestThreadPoolSize(this.maxDownloadThread);
            HttpHandler httpHandler = httpUtils.download(string, string3, bl, bl2, (RequestCallBack)new ManagerCallBack(downloadInfo, requestCallBack));
            downloadInfo.setHandler((HttpHandler<File>)httpHandler);
            downloadInfo.setState(httpHandler.getState());
            this.downloadInfoList.add(downloadInfo);
            this.db.saveBindingId((Object)downloadInfo);
            return this.downloadInfoList.size();
        }

        public void resumeDownload(int n, RequestCallBack<File> requestCallBack) throws DbException {
            DownloadInfo downloadInfo = this.downloadInfoList.get(n);
            this.resumeDownload(downloadInfo, requestCallBack);
        }

        public void resumeDownload(DownloadInfo downloadInfo, RequestCallBack<File> requestCallBack) throws DbException {
            HttpUtils httpUtils = new HttpUtils();
            httpUtils.configRequestThreadPoolSize(this.maxDownloadThread);
            HttpHandler httpHandler = httpUtils.download(downloadInfo.getDownloadUrl(), downloadInfo.getFileSavePath(), downloadInfo.isAutoResume(), downloadInfo.isAutoRename(), (RequestCallBack)new ManagerCallBack(downloadInfo, requestCallBack));
            downloadInfo.setHandler((HttpHandler<File>)httpHandler);
            downloadInfo.setState(httpHandler.getState());
            this.db.saveOrUpdate((Object)downloadInfo);
        }

        public void removeDownload(int n) throws DbException {
            DownloadInfo downloadInfo = this.downloadInfoList.get(n);
            this.removeDownload(downloadInfo);
        }

        public void removeDownload(DownloadInfo downloadInfo) throws DbException {
            HttpHandler<File> httpHandler = downloadInfo.getHandler();
            if (httpHandler != null && !httpHandler.isCancelled()) {
                httpHandler.cancel();
            }
            this.downloadInfoList.remove(downloadInfo);
            this.db.delete((Object)downloadInfo);
        }

        public void stopDownload(int n) throws DbException {
            DownloadInfo downloadInfo = this.downloadInfoList.get(n);
            this.stopDownload(downloadInfo);
        }

        public void stopDownload(DownloadInfo downloadInfo) throws DbException {
            HttpHandler<File> httpHandler = downloadInfo.getHandler();
            if (httpHandler != null && !httpHandler.isCancelled()) {
                httpHandler.cancel();
            } else {
                downloadInfo.setState(HttpHandler.State.CANCELLED);
            }
            this.db.saveOrUpdate((Object)downloadInfo);
        }

        public void stopAllDownload() throws DbException {
            for (DownloadInfo downloadInfo : this.downloadInfoList) {
                HttpHandler<File> httpHandler = downloadInfo.getHandler();
                if (httpHandler != null && !httpHandler.isCancelled()) {
                    httpHandler.cancel();
                    continue;
                }
                downloadInfo.setState(HttpHandler.State.CANCELLED);
            }
            this.db.saveOrUpdateAll(this.downloadInfoList);
        }

        public void backupDownloadInfoList() throws DbException {
            for (DownloadInfo downloadInfo : this.downloadInfoList) {
                HttpHandler<File> httpHandler = downloadInfo.getHandler();
                if (httpHandler == null) continue;
                downloadInfo.setState(httpHandler.getState());
            }
            this.db.saveOrUpdateAll(this.downloadInfoList);
        }

        public int getMaxDownloadThread() {
            return this.maxDownloadThread;
        }

        public void setMaxDownloadThread(int n) {
            this.maxDownloadThread = n;
        }

        private class HttpHandlerStateConverter
        implements ColumnConverter<HttpHandler.State> {
            private HttpHandlerStateConverter() {
            }

            public HttpHandler.State getFieldValue(Cursor cursor, int n) {
                return HttpHandler.State.valueOf((int)cursor.getInt(n));
            }

            public HttpHandler.State getFieldValue(String string) {
                if (string == null) {
                    return null;
                }
                return HttpHandler.State.valueOf((String)string);
            }

            public Object fieldValue2ColumnValue(HttpHandler.State state) {
                return state.value();
            }

            public ColumnDbType getColumnDbType() {
                return ColumnDbType.INTEGER;
            }
        }

        public class ManagerCallBack
        extends RequestCallBack<File> {
            private DownloadInfo downloadInfo;
            private RequestCallBack<File> baseCallBack;

            public RequestCallBack<File> getBaseCallBack() {
                return this.baseCallBack;
            }

            public void setBaseCallBack(RequestCallBack<File> requestCallBack) {
                this.baseCallBack = requestCallBack;
            }

            private ManagerCallBack(DownloadInfo downloadInfo, RequestCallBack<File> requestCallBack) {
                this.baseCallBack = requestCallBack;
                this.downloadInfo = downloadInfo;
            }

            public Object getUserTag() {
                if (this.baseCallBack == null) {
                    return null;
                }
                return this.baseCallBack.getUserTag();
            }

            public void setUserTag(Object object) {
                if (this.baseCallBack == null) {
                    return;
                }
                this.baseCallBack.setUserTag(object);
            }

            public void onStart() {
                HttpHandler<File> httpHandler = this.downloadInfo.getHandler();
                \u4e0b\u8f7d\u5668\u66f4\u65b0\u7248Impl.this.\u5f00\u59cb\u4e0b\u8f7d\u6570\u636e(this.downloadInfo.getId() - 1L);
                if (httpHandler != null) {
                    this.downloadInfo.setState(httpHandler.getState());
                }
                try {
                    DownloadManager.this.db.saveOrUpdate((Object)this.downloadInfo);
                }
                catch (DbException dbException) {
                    LogUtils.e((String)dbException.getMessage(), (Throwable)dbException);
                }
                if (this.baseCallBack != null) {
                    this.baseCallBack.onStart();
                }
            }

            public void onCancelled() {
                HttpHandler<File> httpHandler = this.downloadInfo.getHandler();
                if (httpHandler != null) {
                    this.downloadInfo.setState(httpHandler.getState());
                }
                try {
                    DownloadManager.this.db.saveOrUpdate((Object)this.downloadInfo);
                }
                catch (DbException dbException) {
                    LogUtils.e((String)dbException.getMessage(), (Throwable)dbException);
                }
                if (this.baseCallBack != null) {
                    this.baseCallBack.onCancelled();
                }
            }

            public void onLoading(long l, long l2, boolean bl) {
                HttpHandler<File> httpHandler = this.downloadInfo.getHandler();
                \u4e0b\u8f7d\u5668\u66f4\u65b0\u7248Impl.this.\u4efb\u52a1\u8fdb\u5ea6\u6539\u53d8(this.downloadInfo.getId() - 1L, l, l2);
                if (httpHandler != null) {
                    this.downloadInfo.setState(httpHandler.getState());
                }
                this.downloadInfo.setFileLength(l);
                this.downloadInfo.setProgress(l2);
                try {
                    DownloadManager.this.db.saveOrUpdate((Object)this.downloadInfo);
                }
                catch (DbException dbException) {
                    LogUtils.e((String)dbException.getMessage(), (Throwable)dbException);
                }
                if (this.baseCallBack != null) {
                    this.baseCallBack.onLoading(l, l2, bl);
                }
            }

            public void onSuccess(ResponseInfo<File> responseInfo) {
                HttpHandler<File> httpHandler = this.downloadInfo.getHandler();
                \u4e0b\u8f7d\u5668\u66f4\u65b0\u7248Impl.this.\u4efb\u52a1\u4e0b\u8f7d\u5b8c\u6bd5(this.downloadInfo.getId() - 1L, true);
                if (httpHandler != null) {
                    this.downloadInfo.setState(httpHandler.getState());
                }
                try {
                    DownloadManager.this.db.saveOrUpdate((Object)this.downloadInfo);
                }
                catch (DbException dbException) {
                    LogUtils.e((String)dbException.getMessage(), (Throwable)dbException);
                }
                if (this.baseCallBack != null) {
                    this.baseCallBack.onSuccess(responseInfo);
                }
            }

            public void onFailure(HttpException httpException, String string) {
                HttpHandler<File> httpHandler = this.downloadInfo.getHandler();
                \u4e0b\u8f7d\u5668\u66f4\u65b0\u7248Impl.this.\u4efb\u52a1\u4e0b\u8f7d\u5b8c\u6bd5(this.downloadInfo.getId() - 1L, false);
                if (httpHandler != null) {
                    this.downloadInfo.setState(httpHandler.getState());
                }
                try {
                    DownloadManager.this.db.saveOrUpdate((Object)this.downloadInfo);
                }
                catch (DbException dbException) {
                    LogUtils.e((String)dbException.getMessage(), (Throwable)dbException);
                }
                if (this.baseCallBack != null) {
                    this.baseCallBack.onFailure(httpException, string);
                }
            }
        }
    }

    class \u8fdb\u5ea6
    extends RequestCallBack<File> {
        \u8fdb\u5ea6() {
        }

        public void onStart() {
        }

        public void onLoading(long l, long l2, boolean bl) {
        }

        public void onSuccess(ResponseInfo<File> responseInfo) {
        }

        public void onFailure(HttpException httpException, String string) {
        }
    }
}

