/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class CollapsedHashMap
extends IteratingRule {
    private FieldAccess fldHMSize;
    private FieldAccess fldHMTable;
    private FieldAccess fldWHMSize;
    private FieldAccess fldWHMTable;
    private JavaClass clsHM;
    private JavaClass clsWHM;
    private Set<HMRecord> poorHM = new HashSet<HMRecord>();
    private float ratio = 1.5f;

    public CollapsedHashMap() {
        super(NbBundle.getMessage(CollapsedHashMap.class, (String)"LBL_CHM_Name"), NbBundle.getMessage(CollapsedHashMap.class, (String)"LBL_CHM_Desc"), "java.util.HashMap|java.util.WeakHashMap");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(CollapsedHashMap.class, (String)"LBL_CHM_LongDesc");
    }

    public void setRatio(float f) {
        this.ratio = f;
    }

    @Override
    protected void perform(Instance instance) {
        if (this.clsHM.equals(instance.getJavaClass())) {
            this.scanHashmap(instance, this.fldHMSize, this.fldHMTable);
        } else {
            this.scanHashmap(instance, this.fldWHMSize, this.fldWHMTable);
        }
    }

    @Override
    protected void prepareRule(MemoryLint memoryLint) {
        Heap heap = memoryLint.getHeap();
        this.clsHM = heap.getJavaClassByName("java.util.HashMap");
        this.fldHMTable = new FieldAccess(this.clsHM, "table");
        this.fldHMSize = new FieldAccess(this.clsHM, "size");
        this.clsWHM = heap.getJavaClassByName("java.util.WeakHashMap");
        this.fldWHMTable = new FieldAccess(this.clsWHM, "table");
        this.fldWHMSize = new FieldAccess(this.clsWHM, "size");
    }

    @Override
    protected void summary() {
        for (HMRecord hMRecord : this.poorHM) {
            this.getContext().appendResults(hMRecord.toString() + "<br>");
        }
    }

    private void scanHashmap(Instance instance, FieldAccess fieldAccess, FieldAccess fieldAccess2) {
        int n = fieldAccess.getIntValue(instance);
        if (n < 5) {
            return;
        }
        ObjectArrayInstance objectArrayInstance = (ObjectArrayInstance)fieldAccess2.getRefValue(instance);
        if (objectArrayInstance != null) {
            int n2 = 0;
            List list = objectArrayInstance.getValues();
            for (Instance instance2 : list) {
                if (instance2 == null) continue;
                ++n2;
            }
            if (n2 > 0 && (float)(n / n2) > this.ratio) {
                this.poorHM.add(new HMRecord(instance, n, n2));
            }
        }
    }

    private class HMRecord {
        private Instance hm;
        private int size;
        private int slots;

        HMRecord(Instance instance, int n, int n2) {
            this.hm = instance;
            this.size = n;
            this.slots = n2;
        }

        public String toString() {
            boolean bl = this.slots == 1;
            return NbBundle.getMessage(CollapsedHashMap.class, (String)"FMT_CHM_Record", (Object[])new Object[]{Utils.printClass(CollapsedHashMap.this.getContext(), CollapsedHashMap.this.getContext().getRootIncommingString(this.hm)), Utils.printInstance(this.hm), this.size, this.slots});
        }
    }
}

