/*
 * Decompiled with CFR 0.152.
 */
package com.tenpay.android.service;

import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.KeyEvent;
import com.tenpay.android.service.DownloadDialog;
import com.tenpay.android.service.IRemoteServiceCallback;
import com.tenpay.android.service.ITenpayService;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class TenpayServiceHelper {
    protected static final String TAG = "TenpayServiceHelper";
    protected Context mContext;
    protected ITenpayService mService = null;
    protected Object mLock;
    protected boolean mbPaying = false;
    protected boolean bLogEnabled;
    protected boolean mbLogining = false;
    IRemoteServiceCallback mCallback = new IRemoteServiceCallback.Stub(){

        @Override
        public void startActivity(String packageName, String className, Bundle paramBundle) throws RemoteException {
            Intent i = new Intent();
            try {
                i.putExtras(paramBundle);
                i.setClassName(packageName, className);
                if (TenpayServiceHelper.this.mContext != null) {
                    TenpayServiceHelper.this.mContext.startActivity(i);
                }
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    };
    private ServiceConnection mConnection = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Object object = TenpayServiceHelper.this.mLock;
            synchronized (object) {
                if (TenpayServiceHelper.this.bLogEnabled) {
                    Log.d((String)TenpayServiceHelper.TAG, (String)"Service connected");
                }
                TenpayServiceHelper.this.mService = ITenpayService.Stub.asInterface(service);
                TenpayServiceHelper.this.mLock.notify();
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            TenpayServiceHelper.this.mService = null;
        }
    };

    public void setLogEnabled(boolean bEnabled) {
        this.bLogEnabled = bEnabled;
    }

    private TenpayServiceHelper() {
    }

    public TenpayServiceHelper(Context ctx) {
        this.mContext = ctx;
        this.mLock = new Object();
    }

    public boolean shareLogin(final Map<String, String> loginInfo, final Handler callback, final int msgID) {
        if (this.bLogEnabled) {
            Log.d((String)TAG, (String)" enter shareLogin()");
            Log.d((String)TAG, (String)("loginInfo = " + loginInfo.toString() + ",callback = " + callback + ", msgID = " + msgID));
        }
        if (this.mbLogining) {
            return false;
        }
        this.mbLogining = true;
        if (this.mService == null) {
            if (this.bLogEnabled) {
                Log.d((String)TAG, (String)"will bindService now!");
            }
            boolean isBinded = false;
            try {
                isBinded = this.mContext.bindService(new Intent("com.tenpay.android.service.ITenpayService"), this.mConnection, 1);
            }
            catch (Exception e) {
                if (this.bLogEnabled) {
                    Log.d((String)TAG, (String)"bindService exception, shareLogin() return false!");
                    e.printStackTrace();
                }
                return false;
            }
            if (!isBinded) {
                if (this.bLogEnabled) {
                    Log.d((String)TAG, (String)"bindService fail, shareLogin() return false!");
                }
                return false;
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TenpayServiceHelper.this.bLogEnabled) {
                    Log.d((String)TenpayServiceHelper.TAG, (String)"enter shareLogin()");
                }
                try {
                    Object object = TenpayServiceHelper.this.mLock;
                    synchronized (object) {
                        if (TenpayServiceHelper.this.mService == null) {
                            if (TenpayServiceHelper.this.bLogEnabled) {
                                Log.d((String)TenpayServiceHelper.TAG, (String)" service is null now, will wait...");
                            }
                            TenpayServiceHelper.this.mLock.wait();
                        }
                    }
                    String strRet = TenpayServiceHelper.this.mService.shareLogin(loginInfo, TenpayServiceHelper.this.mCallback);
                    if (TenpayServiceHelper.this.bLogEnabled) {
                        Log.d((String)TenpayServiceHelper.TAG, (String)("shareLogin() return = " + strRet));
                    }
                    TenpayServiceHelper.this.mbLogining = false;
                    TenpayServiceHelper.this.mContext.unbindService(TenpayServiceHelper.this.mConnection);
                    if (callback != null) {
                        Message msg = new Message();
                        msg.what = msgID;
                        msg.obj = strRet;
                        callback.sendMessage(msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return true;
    }

    public boolean pay(final Map<String, String> payInfo, final Handler callback, final int msgID) {
        if (this.bLogEnabled) {
            Log.d((String)TAG, (String)" enter pay()");
            Log.d((String)TAG, (String)("payInfo = " + payInfo.toString() + ", is in paying " + this.mbPaying));
        }
        if (this.mbPaying) {
            return false;
        }
        this.mbPaying = true;
        if (this.mService == null) {
            if (this.bLogEnabled) {
                Log.d((String)TAG, (String)"will bindService now!");
            }
            boolean isBinded = false;
            try {
                isBinded = this.mContext.bindService(new Intent("com.tenpay.android.service.ITenpayService"), this.mConnection, 1);
            }
            catch (Exception e) {
                if (this.bLogEnabled) {
                    Log.d((String)TAG, (String)"bindService exception, pay() return false!");
                    e.printStackTrace();
                }
                return false;
            }
            if (!isBinded) {
                if (this.bLogEnabled) {
                    Log.d((String)TAG, (String)"bindService fail, pay() return false!");
                }
                return false;
            }
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TenpayServiceHelper.this.bLogEnabled) {
                    Log.d((String)TenpayServiceHelper.TAG, (String)"enter pay()");
                }
                try {
                    Object object = TenpayServiceHelper.this.mLock;
                    synchronized (object) {
                        if (TenpayServiceHelper.this.mService == null) {
                            if (TenpayServiceHelper.this.bLogEnabled) {
                                Log.d((String)TenpayServiceHelper.TAG, (String)" service is null now, will wait...");
                            }
                            TenpayServiceHelper.this.mLock.wait();
                        }
                    }
                    String strRet = TenpayServiceHelper.this.mService.gotoPay(payInfo, TenpayServiceHelper.this.mCallback);
                    if (TenpayServiceHelper.this.bLogEnabled) {
                        Log.d((String)TenpayServiceHelper.TAG, (String)("pay() return = " + strRet));
                    }
                    TenpayServiceHelper.this.mbPaying = false;
                    TenpayServiceHelper.this.mContext.unbindService(TenpayServiceHelper.this.mConnection);
                    if (callback != null) {
                        Message msg = new Message();
                        msg.what = msgID;
                        msg.obj = strRet;
                        callback.sendMessage(msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        return true;
    }

    public boolean isTenpayServiceInstalled() {
        PackageManager manager = this.mContext.getPackageManager();
        String packageName = "com.tenpay.android.service";
        try {
            manager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            if (this.bLogEnabled) {
                Log.d((String)TAG, (String)"isTenpayServiceExist() reutrn false");
            }
            return false;
        }
        if (this.bLogEnabled) {
            Log.d((String)TAG, (String)"isTenpayServiceExist() reutrn true");
        }
        return true;
    }

    public boolean isTenpayServiceInstalled(int versionCode) {
        String packageName = "com.tenpay.android.service";
        if (this.isTenpayServiceInstalled()) {
            try {
                PackageInfo pinfo = this.mContext.getPackageManager().getPackageInfo(packageName, 0);
                int code = pinfo.versionCode;
                return code >= versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    public void installTenpayService() {
        File cacheDir = this.mContext.getCacheDir();
        String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/TenpayService.apk";
        boolean isFileGot = this.getFileFromAssets("TenpayService.apk", cachePath);
        if (isFileGot) {
            this.showInstallConfirmDlg(this.mContext, cachePath);
        } else {
            String url = "http://cl.tenpay.com/clientv1.0/pkg/TenpayService.apk";
            this.showGetAppFromNetDlg(this.mContext, "http://cl.tenpay.com/clientv1.0/pkg/TenpayService.apk");
        }
    }

    public void installTenpayService(DialogInterface.OnCancelListener listener) {
        File cacheDir = this.mContext.getCacheDir();
        String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/TenpayService.apk";
        boolean isFileGot = this.getFileFromAssets("TenpayService.apk", cachePath);
        if (isFileGot) {
            this.showInstallConfirmDlg(this.mContext, cachePath, listener);
        } else {
            String url = "http://cl.tenpay.com/clientv1.0/pkg/TenpayService.apk";
            this.showGetAppFromNetDlg(this.mContext, "http://cl.tenpay.com/clientv1.0/pkg/TenpayService.apk", listener);
        }
    }

    public void installTenpayService(DialogInterface.OnCancelListener listener, String fileDir) {
        File cacheDir = this.mContext.getCacheDir();
        String cachePath = String.valueOf(cacheDir.getAbsolutePath()) + "/TenpayService.apk";
        boolean isFileGot = this.getFileFromAssets("TenpayService.apk", cachePath);
        if (isFileGot) {
            this.showInstallConfirmDlg(this.mContext, cachePath, listener);
        } else {
            String url = "http://cl.tenpay.com/clientv1.0/pkg/TenpayService.apk";
            this.showGetAppFromNetDlg(this.mContext, "http://cl.tenpay.com/clientv1.0/pkg/TenpayService.apk", listener, fileDir);
        }
    }

    protected boolean getFileFromAssets(String fileName, String path) {
        try {
            InputStream is = this.mContext.getAssets().open(fileName);
            File file = new File(path);
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = is.read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            is.close();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    protected boolean chmod(String permission, String path) {
        try {
            String command = "chmod " + permission + " " + path;
            Runtime runtime = Runtime.getRuntime();
            Process pr = runtime.exec(command);
            pr.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected void showInstallConfirmDlg(final Context context, final String cachePath) {
        new AlertDialog.Builder(context).setTitle((CharSequence)"\u63d0\u9192").setMessage((CharSequence)"\u662f\u5426\u5b89\u88c5\u8d22\u4ed8\u901a\u624b\u673a\u5b89\u5168\u652f\u4ed8\u670d\u52a1\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TenpayServiceHelper.this.chmod("777", cachePath);
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                intent.setDataAndType(Uri.parse((String)("file://" + cachePath)), "application/vnd.android.package-archive");
                context.startActivity(intent);
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).setCancelable(false).create().show();
    }

    protected void showInstallConfirmDlg(final Context context, final String cachePath, DialogInterface.OnCancelListener listener) {
        new AlertDialog.Builder(context).setTitle((CharSequence)"\u63d0\u9192").setMessage((CharSequence)"\u662f\u5426\u5b89\u88c5\u8d22\u4ed8\u901a\u624b\u673a\u5b89\u5168\u652f\u4ed8\u670d\u52a1\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                TenpayServiceHelper.this.chmod("777", cachePath);
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                intent.setDataAndType(Uri.parse((String)("file://" + cachePath)), "application/vnd.android.package-archive");
                context.startActivity(intent);
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).setOnCancelListener(listener).create().show();
    }

    protected void showGetAppFromNetDlg(Context ctx, final String url) {
        new AlertDialog.Builder(ctx).setTitle((CharSequence)"\u63d0\u9192").setMessage((CharSequence)"\u662f\u5426\u4e0b\u8f7d\u5e76\u5b89\u88c5\u8d22\u4ed8\u901a\u624b\u673a\u5b89\u5168\u652f\u4ed8\u670d\u52a1\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                DownloadDialog downloadDlg = new DownloadDialog(TenpayServiceHelper.this.mContext, url);
                downloadDlg.setCancelable(false);
                downloadDlg.setOnKeyListener(new DialogInterface.OnKeyListener(){

                    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                        return keyCode == 84 && event.getRepeatCount() == 0;
                    }
                });
                downloadDlg.show();
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
            }
        }).setCancelable(false).create().show();
    }

    protected void showGetAppFromNetDlg(Context ctx, final String url, final DialogInterface.OnCancelListener listener) {
        new AlertDialog.Builder(ctx).setTitle((CharSequence)"\u63d0\u9192").setMessage((CharSequence)"\u662f\u5426\u4e0b\u8f7d\u5e76\u5b89\u88c5\u8d22\u4ed8\u901a\u624b\u673a\u5b89\u5168\u652f\u4ed8\u670d\u52a1\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                DownloadDialog downloadDlg = new DownloadDialog(TenpayServiceHelper.this.mContext, url);
                downloadDlg.setOnCancelListener(listener);
                downloadDlg.setOnKeyListener(new DialogInterface.OnKeyListener(){

                    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                        return keyCode == 84 && event.getRepeatCount() == 0;
                    }
                });
                downloadDlg.show();
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.cancel();
            }
        }).setOnCancelListener(listener).create().show();
    }

    protected void showGetAppFromNetDlg(Context ctx, final String url, final DialogInterface.OnCancelListener listener, final String fileDir) {
        new AlertDialog.Builder(ctx).setTitle((CharSequence)"\u63d0\u9192").setMessage((CharSequence)"\u662f\u5426\u4e0b\u8f7d\u5e76\u5b89\u88c5\u8d22\u4ed8\u901a\u624b\u673a\u5b89\u5168\u652f\u4ed8\u670d\u52a1\uff1f").setPositiveButton((CharSequence)"\u786e\u5b9a", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                DownloadDialog downloadDlg = new DownloadDialog(TenpayServiceHelper.this.mContext, url, fileDir);
                downloadDlg.setOnCancelListener(listener);
                downloadDlg.setOnKeyListener(new DialogInterface.OnKeyListener(){

                    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                        return keyCode == 84 && event.getRepeatCount() == 0;
                    }
                });
                downloadDlg.show();
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.cancel();
            }
        }).setOnCancelListener(listener).create().show();
    }
}

