/*
 * Decompiled with CFR 0.152.
 */
package com.tenpay.android.service;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Proxy;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class DownloadDialog
extends Dialog {
    protected Context mContext;
    private static final int M = 0x100000;
    private static final int K = 1024;
    private static final int RETRY_TIMES = 3;
    private LinearLayout mDownloadInfoLayout;
    private ProgressBar mProgress;
    private TextView mDowloadHint;
    private TextView mProgressNumber;
    private TextView mProgressPercent;
    private Button mRetryBtn;
    private Button mCancelBtn;
    private TextView mDownloadResult;
    private String mDownloadURL;
    private String mFileDir;
    protected int mRetryDownloadTimes = 3;
    private final NumberFormat mPercentNumberFormat = NumberFormat.getPercentInstance();
    private final DecimalFormat mMyDecimalFormat = new DecimalFormat("###.##");
    private DownloadAsyncTask mDownloadAsyncTask;

    public DownloadDialog(Context context) {
        super(context);
    }

    public DownloadDialog(Context context, String url) {
        super(context);
        this.mDownloadURL = url;
    }

    public DownloadDialog(Context context, String url, String fileDir) {
        super(context);
        this.mDownloadURL = url;
        this.mFileDir = fileDir;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        LinearLayout layout_all = new LinearLayout(this.getContext());
        layout_all.setOrientation(1);
        layout_all.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        this.mDowloadHint = new TextView(this.getContext());
        this.mDowloadHint.setPadding(10, 10, 0, 0);
        this.mDowloadHint.setText((CharSequence)"\u6b63\u5728\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\uff0c\u8bf7\u7a0d\u5019...");
        layout_all.addView((View)this.mDowloadHint, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.mProgress = new ProgressBar(this.getContext(), null, 16842872);
        this.mProgress.setIndeterminate(false);
        this.mProgress.setMax(100);
        this.mProgress.setPadding(10, 0, 10, 0);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        lp.setMargins(0, 10, 0, 0);
        lp.gravity = 17;
        this.mProgress.setLayoutParams((ViewGroup.LayoutParams)lp);
        layout_all.addView((View)this.mProgress);
        this.mDownloadInfoLayout = new LinearLayout(this.getContext());
        this.mProgressPercent = new TextView(this.getContext());
        this.mProgressPercent.setPadding(10, 0, 0, 0);
        this.mProgressPercent.setText((CharSequence)"0%");
        this.mDownloadInfoLayout.addView((View)this.mProgressPercent, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.mProgressNumber = new TextView(this.getContext());
        LinearLayout.LayoutParams lp_progress_number = new LinearLayout.LayoutParams(-2, -2);
        lp_progress_number.setMargins(60, 0, 0, 0);
        this.mDownloadInfoLayout.addView((View)this.mProgressNumber, (ViewGroup.LayoutParams)lp_progress_number);
        layout_all.addView((View)this.mDownloadInfoLayout, (ViewGroup.LayoutParams)lp);
        this.mDownloadResult = new TextView(this.getContext());
        this.mDownloadResult.setText((CharSequence)"\u5f88\u62b1\u6b49\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u540e\u91cd\u65b0\u4e0b\u8f7d");
        LinearLayout.LayoutParams lp_result = new LinearLayout.LayoutParams(-1, -2);
        lp_result.setMargins(20, 10, 0, 0);
        this.mDownloadResult.setVisibility(8);
        layout_all.addView((View)this.mDownloadResult, (ViewGroup.LayoutParams)lp_result);
        LinearLayout button_layout = new LinearLayout(this.getContext());
        button_layout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        button_layout.setPadding(10, 10, 10, 5);
        this.mRetryBtn = new Button(this.getContext());
        this.mRetryBtn.setText((CharSequence)"\u91cd\u65b0\u4e0b\u8f7d");
        this.mRetryBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DownloadDialog.this.mDowloadHint.setVisibility(0);
                DownloadDialog.this.mProgress.setVisibility(0);
                DownloadDialog.this.mDownloadInfoLayout.setVisibility(0);
                DownloadDialog.this.mDownloadResult.setVisibility(8);
                DownloadDialog.this.mDowloadHint.setText((CharSequence)"\u6b63\u5728\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\uff0c\u8bf7\u7a0d\u5019...");
                DownloadDialog.this.mProgress.setProgress(0);
                DownloadDialog.this.mProgressPercent.setText((CharSequence)"0%");
                DownloadDialog.this.mProgressNumber.setText((CharSequence)"");
                DownloadDialog.this.mDownloadAsyncTask.cancel(true);
                if (DownloadDialog.this.mFileDir != null) {
                    DownloadDialog.this.mDownloadAsyncTask = (DownloadAsyncTask)new DownloadAsyncTask().execute(new String[]{DownloadDialog.this.mDownloadURL, DownloadDialog.this.mFileDir});
                } else {
                    DownloadDialog.this.mDownloadAsyncTask = (DownloadAsyncTask)new DownloadAsyncTask().execute(new String[]{DownloadDialog.this.mDownloadURL});
                }
            }
        });
        this.mCancelBtn = new Button(this.getContext());
        this.mCancelBtn.setText((CharSequence)"\u53d6\u6d88");
        this.mCancelBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DownloadDialog.this.mDownloadAsyncTask.cancel(true);
                DownloadDialog.this.cancel();
            }
        });
        LinearLayout.LayoutParams lp_btn = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        lp_btn.gravity = 17;
        button_layout.addView((View)this.mRetryBtn, (ViewGroup.LayoutParams)lp_btn);
        button_layout.addView((View)this.mCancelBtn, (ViewGroup.LayoutParams)lp_btn);
        layout_all.addView((View)button_layout);
        this.setContentView((View)layout_all);
        this.getWindow().setLayout(-1, -2);
        this.mContext = this.getContext();
        this.mDownloadAsyncTask = this.mFileDir != null ? (DownloadAsyncTask)new DownloadAsyncTask().execute(new String[]{this.mDownloadURL, this.mFileDir}) : (DownloadAsyncTask)new DownloadAsyncTask().execute(new String[]{this.mDownloadURL});
    }

    public void chmod(String permission, String path) {
        try {
            String command = "chmod " + permission + " " + path;
            Runtime runtime = Runtime.getRuntime();
            Process pr = runtime.exec(command);
            pr.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnoughSpaceInSDcard(long fileSize) {
        if ("mounted".equals(Environment.getExternalStorageState())) {
            long avaliableSize = 0L;
            String storageDirectory = null;
            storageDirectory = Environment.getExternalStorageDirectory().getAbsolutePath();
            try {
                StatFs stat = new StatFs(storageDirectory);
                avaliableSize = (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
            }
            catch (RuntimeException ex) {
                return false;
            }
            return avaliableSize > fileSize;
        }
        return false;
    }

    private class DownloadAsyncTask
    extends AsyncTask<String, ProgressData, String> {
        static final int ERROR_CODE_OK = 0;
        static final int ERROR_CODE_IO_EXCEPTION = 1;
        static final int ERROR_CODE_SOCKET_TIMEOUT = 2;
        static final int HTTP_CONNECTIONTIMEOUT = 15000;
        static final int HTTP_SOTIMEOUT = 15000;
        final int DEFAULT_DOWNLOAD_SIZE = 2097452;
        final int PROGRESS_THRESHOLD = 2048;

        private DownloadAsyncTask() {
        }

        private HttpHost detectProxy() {
            HttpHost proxy = null;
            String proxyHost = Proxy.getDefaultHost();
            int port = Proxy.getDefaultPort();
            boolean enabled = false;
            try {
                WifiManager wifiManager;
                if (DownloadDialog.this.mContext != null && (wifiManager = (WifiManager)DownloadDialog.this.mContext.getSystemService("wifi")) != null && (enabled = wifiManager.isWifiEnabled()) && wifiManager.getConnectionInfo().getIpAddress() == 0) {
                    enabled = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!enabled && proxyHost != null) {
                proxy = new HttpHost(proxyHost, port);
            }
            return proxy;
        }

        private HttpClient createHttpClient() {
            BasicHttpParams params = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)15000);
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)15000);
            HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
            try {
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                SingleClientConnManager mgr = new SingleClientConnManager((HttpParams)params, schemeRegistry);
                return new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
            }
            catch (Exception e) {
                return new DefaultHttpClient((HttpParams)params);
            }
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected String doInBackground(String ... params) {
            ProgressData progressData = new ProgressData(0L, 2097452L, 0);
            String downloadURLStr = params[0];
            String downloadFileDir = null;
            if (params.length > 1) {
                downloadFileDir = params[1];
            }
            HttpHost proxy = this.detectProxy();
            String filename = downloadURLStr.substring(downloadURLStr.lastIndexOf("/"));
            HttpClient http_client = null;
            HttpResponse http_resp = null;
            HttpGet get_request = null;
            int status = 0;
            FileOutputStream fos = null;
            InputStream inStream = null;
            String path = null;
            try {
                http_client = this.createHttpClient();
                if (proxy != null) {
                    http_client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                }
                get_request = new HttpGet(downloadURLStr);
                get_request.setHeader("Accept-Encoding", "deflate");
                if (proxy != null) {
                    get_request.addHeader("X-Online-Host", get_request.getURI().getHost());
                    get_request.addHeader("User-Agent", "Mozilla/5.0 (Macintosh; PPC Mac OS X; U; en) Opera 8.0");
                }
                if ((status = (http_resp = http_client.execute((HttpUriRequest)get_request)).getStatusLine().getStatusCode()) != 200 && status != 206) {
                    progressData.errorCode = 1;
                    this.publishProgress(new ProgressData[]{progressData});
                    this.cancel(true);
                    return null;
                }
                Header header = http_resp.getFirstHeader("Content-Type");
                if (header != null && header.getValue() != null && header.getValue().indexOf("wap.wml") > 0) {
                    Log.d((String)"erik", (String)"cmwap wap.wml content-type found");
                    progressData.errorCode = 1;
                    this.publishProgress(new ProgressData[]{progressData});
                    this.cancel(true);
                    return null;
                }
                HttpEntity entity = http_resp.getEntity();
                inStream = entity.getContent();
                if (inStream == null) {
                    progressData.errorCode = 1;
                    this.publishProgress(new ProgressData[]{progressData});
                    this.cancel(true);
                    return null;
                }
                long fileSize = entity.getContentLength();
                Log.d((String)"erik", (String)("mProxty =" + proxy));
                Log.d((String)"erik", (String)("mFileSize = " + fileSize));
                if (fileSize <= 0L) {
                    fileSize = 2097452L;
                }
                String cachePath = null;
                if (downloadFileDir != null) {
                    cachePath = downloadFileDir;
                    File dir = new File(cachePath);
                    dir.mkdirs();
                } else {
                    cachePath = DownloadDialog.this.isEnoughSpaceInSDcard(fileSize) ? Environment.getExternalStorageDirectory().getAbsolutePath() : DownloadDialog.this.mContext.getCacheDir().getAbsolutePath();
                }
                path = String.valueOf(cachePath) + filename;
                File file = new File(path);
                if (file.exists() || file.isDirectory()) {
                    file.delete();
                }
                if (!file.createNewFile()) {
                    path = String.valueOf(cachePath) + "/TenpayPrefix" + filename.substring(1);
                    file = new File(path);
                    file.createNewFile();
                }
                Log.d((String)"erik", (String)("file path= " + path));
                fos = new FileOutputStream(file);
                long downloadedSize = 0L;
                long lastTimeDownloadedSize = 0L;
                byte[] temp = new byte[1024];
                int i = 0;
                progressData.setData(0L, fileSize, 0);
                this.publishProgress(new ProgressData[]{progressData});
                while (true) {
                    if (this.isCancelled() || (i = inStream.read(temp)) <= 0) {
                        if (fos != null) {
                            fos.close();
                            fos = null;
                        }
                        if (inStream == null) return path;
                        inStream.close();
                        inStream = null;
                        return path;
                    }
                    fos.write(temp, 0, i);
                    if ((downloadedSize += (long)i) - lastTimeDownloadedSize < 2048L) continue;
                    progressData.setData(downloadedSize, fileSize, 0);
                    this.publishProgress(new ProgressData[]{progressData});
                    lastTimeDownloadedSize = downloadedSize;
                }
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
                path = null;
                progressData.errorCode = 2;
                this.publishProgress(new ProgressData[]{progressData});
                return path;
            }
            catch (SocketTimeoutException e) {
                e.printStackTrace();
                path = null;
                progressData.errorCode = 2;
                this.publishProgress(new ProgressData[]{progressData});
                return path;
            }
            catch (SocketException e) {
                e.printStackTrace();
                path = null;
                progressData.errorCode = 2;
                this.publishProgress(new ProgressData[]{progressData});
                return path;
            }
            catch (IOException e) {
                e.printStackTrace();
                path = null;
                progressData.errorCode = 1;
                this.publishProgress(new ProgressData[]{progressData});
                return path;
            }
            finally {
                if (http_client != null) {
                    http_client.getConnectionManager().shutdown();
                    http_client = null;
                }
                if (http_resp != null) {
                    http_resp = null;
                }
                try {
                    if (fos != null) {
                        fos.close();
                        fos = null;
                    }
                    if (inStream != null) {
                        inStream.close();
                        inStream = null;
                    }
                }
                catch (IOException iOException) {}
            }
        }

        protected void onCancelled() {
            super.onCancelled();
        }

        protected void onProgressUpdate(ProgressData ... values) {
            super.onProgressUpdate((Object[])values);
            ProgressData progress = values[0];
            switch (progress.errorCode) {
                case 0: {
                    String sizeUnitStr;
                    int sizeUnit;
                    DownloadDialog.this.mDowloadHint.setText((CharSequence)"\u6b63\u5728\u4e0b\u8f7d\uff0c\u8bf7\u7a0d\u5019...");
                    DownloadDialog.this.mDownloadInfoLayout.setVisibility(0);
                    DownloadDialog.this.mDownloadResult.setVisibility(8);
                    if (progress.totalSize > 0x100000L) {
                        sizeUnit = 0x100000;
                        sizeUnitStr = "MB";
                    } else {
                        sizeUnit = 1024;
                        sizeUnitStr = "KB";
                    }
                    double total = (double)progress.totalSize / (double)sizeUnit;
                    double download = (double)progress.downloadSize / (double)sizeUnit;
                    double precent = (double)progress.downloadSize / (double)progress.totalSize;
                    DownloadDialog.this.mProgress.setProgress((int)(precent * 100.0));
                    DownloadDialog.this.mProgressNumber.setText((CharSequence)(String.valueOf(DownloadDialog.this.mMyDecimalFormat.format(download)) + sizeUnitStr + "/" + DownloadDialog.this.mMyDecimalFormat.format(total) + sizeUnitStr));
                    DownloadDialog.this.mProgressPercent.setText((CharSequence)DownloadDialog.this.mPercentNumberFormat.format(precent));
                    break;
                }
                case 1: {
                    DownloadDialog.this.mDownloadInfoLayout.setVisibility(8);
                    DownloadDialog.this.mDownloadResult.setVisibility(0);
                    DownloadDialog.this.mDownloadResult.setText((CharSequence)"\u4e0b\u8f7d\u51fa\u73b0\u5f02\u5e38\uff0c\u6b63\u5728\u91cd\u8bd5...");
                    --DownloadDialog.this.mRetryDownloadTimes;
                    if (DownloadDialog.this.mRetryDownloadTimes > 0) {
                        DownloadDialog.this.mDowloadHint.setText((CharSequence)"\u6b63\u5728\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\uff0c\u8bf7\u7a0d\u5019...");
                        DownloadDialog.this.mRetryBtn.performClick();
                        break;
                    }
                    DownloadDialog.this.mDowloadHint.setVisibility(8);
                    DownloadDialog.this.mProgress.setVisibility(8);
                    DownloadDialog.this.mDownloadInfoLayout.setVisibility(8);
                    DownloadDialog.this.mDownloadResult.setVisibility(0);
                    DownloadDialog.this.mDownloadResult.setText((CharSequence)"\u5f88\u62b1\u6b49\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u540e\u91cd\u65b0\u4e0b\u8f7d\u3002");
                    DownloadDialog.this.mRetryDownloadTimes = 3;
                    break;
                }
                case 2: {
                    DownloadDialog.this.mDownloadInfoLayout.setVisibility(8);
                    DownloadDialog.this.mDownloadResult.setVisibility(0);
                    DownloadDialog.this.mDownloadResult.setText((CharSequence)"\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\uff0c\u6b63\u5728\u91cd\u8bd5...");
                    --DownloadDialog.this.mRetryDownloadTimes;
                    if (DownloadDialog.this.mRetryDownloadTimes > 0) {
                        DownloadDialog.this.mDowloadHint.setText((CharSequence)"\u6b63\u5728\u83b7\u53d6\u4e0b\u8f7d\u6587\u4ef6\u5927\u5c0f\uff0c\u8bf7\u7a0d\u5019...");
                        DownloadDialog.this.mRetryBtn.performClick();
                        break;
                    }
                    DownloadDialog.this.mDowloadHint.setVisibility(8);
                    DownloadDialog.this.mProgress.setVisibility(8);
                    DownloadDialog.this.mDownloadInfoLayout.setVisibility(8);
                    DownloadDialog.this.mDownloadResult.setVisibility(0);
                    DownloadDialog.this.mDownloadResult.setText((CharSequence)"\u5f88\u62b1\u6b49\u4e0b\u8f7d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u540e\u91cd\u65b0\u4e0b\u8f7d\u3002");
                    DownloadDialog.this.mRetryDownloadTimes = 3;
                }
            }
        }

        protected void onPostExecute(String result) {
            super.onPostExecute((Object)result);
            if (result != null && result.length() != 0) {
                DownloadDialog.this.chmod("666", result);
                File appFile = new File(result);
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.addFlags(0x10000000);
                intent.setDataAndType(Uri.fromFile((File)appFile), "application/vnd.android.package-archive");
                DownloadDialog.this.mContext.startActivity(intent);
                DownloadDialog.this.dismiss();
            }
        }
    }

    private class ProgressData {
        long downloadSize;
        long totalSize;
        int errorCode;

        ProgressData(long d, long t, int e) {
            this.downloadSize = d;
            this.totalSize = t;
            this.errorCode = e;
        }

        void setData(long d, long t, int e) {
            this.downloadSize = d;
            this.totalSize = t;
            this.errorCode = e;
        }
    }
}

