/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.pushservice;

import android.content.Context;
import android.content.Intent;
import com.baidu.android.pushservice.LoadExecutor;
import com.baidu.android.pushservice.apiproxy.BridgePushConstants;
import com.baidu.frontia.base.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class PushConstants {
    public static final String EXTRA_PUSH_MESSAGE = "message";
    public static final String EXTRA_PUSH_MESSAGE_STRING = "message_string";
    public static final String ACTION_MESSAGE = "com.baidu.android.pushservice.action.MESSAGE";
    public static final String ACTION_SDK_MESSAGE = "com.baidu.android.pushservice.action.SDK_MESSAGE";
    public static final String ACTION_FB_MESSAGE = "com.baidu.android.pushservice.action.FB_MESSAGE";
    public static final String ACTION_METHOD = "com.baidu.android.pushservice.action.METHOD";
    public static final String ACTION_LAPP_RECEIVE = "com.baidu.android.pushservice.action.lapp.RECEIVE";
    public static final String ACTION_RECEIVE = "com.baidu.android.pushservice.action.RECEIVE";
    public static final String ACTION_RECEIVER_NOTIFICATION_CLICK = "com.baidu.android.pushservice.action.notification.CLICK";
    public static final String ACTION_SDK_RECEIVE = "com.baidu.android.pushservice.action.sdk.RECEIVE";
    public static final String ACTION_WEB_RECEIVE = "com.baidu.android.pushservice.action.web.RECEIVE";
    public static final String EXTRA_WEB_BIND_API_KEY = "com.baidu.pushservice.webapp.apikey";
    public static final String ACTION_LAPP_MESSAGE = "com.baidu.android.pushservice.action.LAPP_MESSAGE";
    public static final String METHOD_LAPP_BIND_INTENT = "method_deal_lapp_bind_intent";
    public static final String METHOD_LAPP_UNBIND = "method_lapp_unbind";
    public static final String METHOD_GET_LAPP_BIND_STATE = "method_get_lapp_bind_state";
    public static final String EXTRA_LAPP_BIND_STATE = "lapp_bind_state";
    public static final String METHOD_SET_LAPP_TAGS = "method_set_lapp_tags";
    public static final String METHOD_DEL_LAPP_TAGS = "method_del_lapp_tags";
    public static final int LOGIN_TYPE_LIGHT_APP_API_KEY = 4;
    public static final String EXTRA_METHOD = "method";
    public static final String PACKAGE_NAME = "pkg_name";
    public static final String EXTRA_ERROR_CODE = "error_msg";
    public static final String EXTRA_CONTENT = "content";
    public static final String EXTRA_TAGS_LIST = "tags_list";
    public static final String EXTRA_APP_ID = "app_id";
    public static final String EXTRA_USER_ID = "user_id";
    public static final String EXTRA_APP = "app";
    public static final String EXTRA_ACCESS_TOKEN = "access_token";
    public static final String EXTRA_API_KEY = "secret_key";
    public static final String EXTRA_BIND_NAME = "bind_name";
    public static final String EXTRA_BIND_STATUS = "bind_status";
    public static final String EXTRA_PUSH_SDK_VERSION = "push_sdk_version";
    public static final String EXTRA_MSG_KEY = "push_ msg_key";
    public static final String EXTRA_MSG = "push_ msg";
    public static final String EXTRA_CB_URL = "cb_url";
    public static final String EXTRA_TIMESTAMP = "time_stamp";
    public static final String EXTRA_MSGID = "msgid";
    public static final String EXTRA_HASHCODE = "hash_code";
    public static final String EXTRA_OPENTYPE = "open_type";
    public static final String EXTRA_EXTRA = "extra_extra_custom_content";
    public static final int OPEN_BY_USER = 0;
    public static final int OPEN_BY_NOTIFICATION = 1;
    public static final int BIND_STATUS_ONLINE = 0;
    public static final int BIND_STATUS_OFFLINE = 1;
    public static final String METHOD_SEND_MSG_TO_SERVER = "method_send_msg_to_server";
    public static final String METHOD_SEND_MSG_TO_USER = "method_send_msg_to_user";
    public static final String METHOD_APPSTART = "method_appstart";
    public static final String METHOD_APPSTOP = "method_appstop";
    public static final String METHOD_SEND = "method_send";
    public static final String METHOD_BIND = "method_bind";
    public static final String METHOD_UNBIND = "method_unbind";
    public static final String EXTRA_FETCH_TYPE = "fetch_type";
    public static final String EXTRA_FETCH_NUM = "fetch_num";
    public static final String METHOD_FETCH = "method_fetch";
    public static final String METHOD_COUNT = "method_count";
    public static final String EXTRA_MSG_IDS = "msg_ids";
    public static final String METHOD_DELETE = "method_delete";
    public static final String METHOD_GBIND = "method_gbind";
    public static final String EXTRA_GID = "gid";
    public static final String METHOD_SET_TAGS = "method_set_tags";
    public static final String METHOD_DEL_TAGS = "method_del_tags";
    public static final String EXTRA_TAGS = "tags";
    public static final String EXTRA_NOTIFICATION_TITLE = "notification_title";
    public static final String EXTRA_NOTIFICATION_CONTENT = "notification_content";
    public static final String METHOD_GUNBIND = "method_gunbind";
    public static final String METHOD_GINFO = "method_ginfo";
    public static final String METHOD_GLIST = "method_glist";
    public static final String METHOD_LISTTAGS = "method_listtags";
    public static final String METHOD_LIST_LAPP_TAGS = "method_list_lapp_tags";
    public static final String METHOD_FETCHGMSG = "method_fetchgmsg";
    public static final String EXTRA_GROUP_FETCH_TYPE = "group_fetch_type";
    public static final String EXTRA_GROUP_FETCH_NUM = "group_fetch_num";
    public static final String METHOD_COUNTGMSG = "method_countgmsg";
    public static final String METHOD_ONLINE = "method_online";
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_NETWORK_ERROR = 10001;
    public static final int ERROR_SERVICE_NOT_AVAILABLE = 10002;
    public static final int ERROR_SERVICE_NOT_AVAILABLE_TEMP = 10003;
    public static final int ERROR_UNKNOWN = 20001;
    public static final int ERROR_SERVER_INTERNAL_ERROR = 30600;
    public static final int ERROR_METHOD_ERROR = 30601;
    public static final int ERROR_PARAMS_ERROR = 30602;
    public static final int ERROR_AUTHENTICATION_FAILED = 30603;
    public static final int ERROR_QUOTA_USE_UP = 30604;
    public static final int ERROR_DATA_NOT_FOUND = 30605;
    public static final int ERROR_TIME_EXPIRES = 30606;
    public static final int ERROR_CHANNEL_TOKEN_TIMEOUT = 30607;
    public static final int ERROR_BIND_NOT_EXIST = 30608;
    public static final int ERROR_BIND_OVERLOAD = 30609;
    public static final int LOGIN_TYPE_API_KEY = 0;
    public static final int LOGIN_TYPE_ACCESS_TOKEN = 1;
    public static final int LOGIN_TYPE_BDUSS = 2;
    public static final int LOGIN_TYPE_UNKNOWN = 9;
    public static final int ERROR_AIDL_FAIL = 40001;
    public static final String ERROR_AIDL_FAIL_EXCEPTION = "aidl_error: INTERNAL_EXCEPTION";
    public static final String ERROR_AIDL_FAIL_NO_PUSHSERVICE = "aidl_error: NO BINDED PUSHSERVICE or OLD VERSION ";
    public static final short ORIGINAL_VERSION = 23;
    private static final int a = 1024;
    private static final String b = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC/7VlVn9LIrZ71PL2RZMbK/Yxc\r\ndb046w/cXVylxS7ouPY06namZUFVhdbUnNRJzmGUZlzs3jUbvMO3l+4c9cw/n9aQ\r\nrm/brgaRDeZbeSrQYRZv60xzJIimuFFxsRM+ku6/dAyYmXiQXlRbgvFQ0MsVng4j\r\nv+cXhtTis2Kbwb8mQwIDAQAB\r\n";

    public static String rsaEncrypt(String string) {
        String string2 = null;
        try {
            string2 = Base64.encode((byte[])PushConstants.a(string.getBytes(), b, 1024), (String)"utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static Intent createMethodIntent(Context context) {
        if (!LoadExecutor.loadPush(context)) {
            return new Intent();
        }
        return BridgePushConstants.createMethodIntent(context);
    }

    public static void restartPushService(Context context) {
        if (!LoadExecutor.loadPush(context)) {
            return;
        }
        BridgePushConstants.restartPushService(context);
    }

    public static void startPushService(Context context) {
        if (!LoadExecutor.loadPush(context)) {
            return;
        }
        BridgePushConstants.startPushService(context);
    }

    public static String getErrorMsg(int n) {
        String string = "Unknown";
        switch (n) {
            case 0: {
                string = "Success";
                break;
            }
            case 10001: {
                string = "Network Problem";
                break;
            }
            case 30603: {
                string = "Authentication Failed";
                break;
            }
            case 10002: {
                string = "Service not available";
                break;
            }
            case 10003: {
                string = "Service not available temporary";
                break;
            }
            case 30608: {
                string = "Bind Relation Not Found";
                break;
            }
            case 30600: {
                string = "Internal Server Error";
                break;
            }
            case 30601: {
                string = "Method Not Allowed";
                break;
            }
            case 30602: {
                string = "Request Params Not Valid";
                break;
            }
            case 30604: {
                string = "Quota Use Up Payment Required";
                break;
            }
            case 30605: {
                string = "Data Required Not Found";
                break;
            }
            case 30606: {
                string = "Request Time Expires Timeout";
                break;
            }
            case 30607: {
                string = "Channel Token Timeout";
                break;
            }
            case 30609: {
                string = "Bind Number Too Many";
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    private static byte[] a(byte[] byArray, String string, int n) throws Exception {
        byte[] byArray2 = Base64.decode((byte[])string.getBytes());
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        int n2 = n / 8;
        int n3 = n2 - 11;
        int n4 = byArray.length;
        byte[] byArray3 = new byte[(n4 + n3 - 1) / n3 * n2];
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            int n7 = n4 - n5;
            int n8 = n3 < n7 ? n3 : n7;
            byte[] byArray4 = new byte[n8];
            System.arraycopy(byArray, n5, byArray4, 0, n8);
            n5 += n8;
            System.arraycopy(cipher.doFinal(byArray4), 0, byArray3, n6, n2);
            n6 += n2;
        }
        return byArray3;
    }
}

