/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Point;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.mob.tools.MobLog;
import com.mob.tools.network.KVPair;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.Hashon;
import com.mob.tools.utils.ReflectHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ResHelper {
    private static float density;
    private static int deviceWidth;
    private static Object rp;
    private static Uri mediaUri;

    public static int dipToPx(Context context, int dip) {
        if (density <= 0.0f) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)dip * density + 0.5f);
    }

    public static int pxToDip(Context context, int px) {
        if (density <= 0.0f) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)px / density + 0.5f);
    }

    public static int designToDevice(Context context, int designScreenWidth, int designPx) {
        if (deviceWidth == 0) {
            int[] scrSize = ResHelper.getScreenSize(context);
            deviceWidth = scrSize[0] < scrSize[1] ? scrSize[0] : scrSize[1];
        }
        return (int)((float)designPx * (float)deviceWidth / (float)designScreenWidth + 0.5f);
    }

    public static int designToDevice(Context context, float designScreenDensity, int designPx) {
        if (density <= 0.0f) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)designPx * density / designScreenDensity + 0.5f);
    }

    public static int[] getScreenSize(Context context) {
        WindowManager windowManager;
        try {
            windowManager = (WindowManager)context.getSystemService("window");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            windowManager = null;
        }
        if (windowManager == null) {
            return new int[]{0, 0};
        }
        Display display = windowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT < 13) {
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            return new int[]{dm.widthPixels, dm.heightPixels};
        }
        try {
            Point size = new Point();
            Method method = display.getClass().getMethod("getRealSize", Point.class);
            method.setAccessible(true);
            method.invoke((Object)display, size);
            return new int[]{size.x, size.y};
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return new int[]{0, 0};
        }
    }

    public static int getScreenWidth(Context context) {
        return ResHelper.getScreenSize(context)[0];
    }

    public static int getScreenHeight(Context context) {
        return ResHelper.getScreenSize(context)[1];
    }

    public static void setResourceProvider(Object rp) {
        try {
            Method mth = rp.getClass().getMethod("getResId", Context.class, String.class, String.class);
            if (mth != null) {
                ResHelper.rp = rp;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public static int getResId(Context context, String resType, String resName) {
        int resId = 0;
        if (context == null || TextUtils.isEmpty((CharSequence)resType) || TextUtils.isEmpty((CharSequence)resName)) {
            return resId;
        }
        if (rp != null) {
            try {
                Method mth = rp.getClass().getMethod("getResId", Context.class, String.class, String.class);
                mth.setAccessible(true);
                resId = (Integer)mth.invoke(rp, context, resType, resName);
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        if (resId <= 0) {
            String pck = context.getPackageName();
            if (TextUtils.isEmpty((CharSequence)pck)) {
                return resId;
            }
            if (resId <= 0 && (resId = context.getResources().getIdentifier(resName, resType, pck)) <= 0) {
                resId = context.getResources().getIdentifier(resName.toLowerCase(), resType, pck);
            }
            if (resId <= 0) {
                MobLog.getInstance().w("failed to parse " + resType + " resource \"" + resName + "\"");
            }
        }
        return resId;
    }

    public static int getBitmapRes(Context context, String resName) {
        int resId = ResHelper.getResId(context, "drawable", resName);
        if (resId <= 0) {
            resId = ResHelper.getResId(context, "mipmap", resName);
        }
        return resId;
    }

    public static int getStringRes(Context context, String resName) {
        return ResHelper.getResId(context, "string", resName);
    }

    public static int getStringArrayRes(Context context, String resName) {
        return ResHelper.getResId(context, "array", resName);
    }

    public static int getLayoutRes(Context context, String resName) {
        return ResHelper.getResId(context, "layout", resName);
    }

    public static int getStyleRes(Context context, String resName) {
        return ResHelper.getResId(context, "style", resName);
    }

    public static int getIdRes(Context context, String resName) {
        return ResHelper.getResId(context, "id", resName);
    }

    public static int getColorRes(Context context, String resName) {
        return ResHelper.getResId(context, "color", resName);
    }

    public static int getRawRes(Context context, String resName) {
        return ResHelper.getResId(context, "raw", resName);
    }

    public static int getPluralsRes(Context context, String resName) {
        return ResHelper.getResId(context, "plurals", resName);
    }

    public static int getAnimRes(Context context, String resName) {
        return ResHelper.getResId(context, "anim", resName);
    }

    public static int[] getStyleableRes(Context context, String resName) {
        try {
            String className = ReflectHelper.importClass(context.getPackageName() + ".R$styleable");
            Object res = ReflectHelper.getStaticField(className, resName);
            if (res == null) {
                return new int[0];
            }
            if (res.getClass().isArray()) {
                return (int[])res;
            }
            return new int[]{(Integer)res};
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return new int[0];
        }
    }

    public static File getCacheRootFile(Context context, String name) {
        File file = new File(ResHelper.getCacheRoot(context), name);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public static String getCacheRoot(Context context) {
        File file;
        String sdcardPath;
        String appDir = context.getFilesDir().getAbsolutePath() + "/Mob/";
        DeviceHelper helper = DeviceHelper.getInstance(context);
        if (helper.getSdcardState() && (sdcardPath = helper.getSdcardPath()) != null) {
            appDir = sdcardPath + "/Mob/";
        }
        if (!(file = new File(appDir)).exists()) {
            file.mkdirs();
        }
        return appDir;
    }

    public static String getDataCache(Context context) {
        String appDir = context.getFilesDir().getAbsolutePath() + "/Mob/";
        File file = new File(appDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        return appDir;
    }

    public static String getCachePath(Context context, String category) {
        File file;
        String appDir = context.getFilesDir().getAbsolutePath() + "/Mob/cache/";
        DeviceHelper helper = DeviceHelper.getInstance(context);
        try {
            String sdcardPath;
            if (helper.getSdcardState() && (sdcardPath = helper.getSdcardPath()) != null) {
                appDir = sdcardPath + "/Mob/" + helper.getPackageName() + "/cache/";
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        if (!TextUtils.isEmpty((CharSequence)category)) {
            appDir = appDir + category + "/";
        }
        if (!(file = new File(appDir)).exists()) {
            file.mkdirs();
        }
        return appDir;
    }

    public static String getImageCachePath(Context context) {
        return ResHelper.getCachePath(context, "images");
    }

    public static void clearCache(Context context) throws Throwable {
        String path = ResHelper.getCachePath(context, null);
        File cacheFolder = new File(path);
        ResHelper.deleteFileAndFolder(cacheFolder);
    }

    public static void deleteFilesInFolder(File folder) throws Throwable {
        if (folder == null || !folder.exists()) {
            return;
        }
        if (folder.isFile()) {
            folder.delete();
            return;
        }
        String[] names = folder.list();
        if (names == null || names.length <= 0) {
            return;
        }
        for (String name : names) {
            File f = new File(folder, name);
            if (f.isDirectory()) {
                ResHelper.deleteFilesInFolder(f);
                continue;
            }
            f.delete();
        }
    }

    public static void deleteFileAndFolder(File folder) throws Throwable {
        if (folder == null || !folder.exists()) {
            return;
        }
        if (folder.isFile()) {
            folder.delete();
            return;
        }
        String[] names = folder.list();
        if (names == null || names.length <= 0) {
            folder.delete();
            return;
        }
        for (String name : names) {
            File f = new File(folder, name);
            if (f.isDirectory()) {
                ResHelper.deleteFileAndFolder(f);
                continue;
            }
            f.delete();
        }
        folder.delete();
    }

    public static String toWordText(String text, int lenInWord) {
        char[] cText = text.toCharArray();
        int count = lenInWord * 2;
        StringBuilder sb = new StringBuilder();
        for (char ch : cText) {
            if ((count -= ch < '\u0100' ? 1 : 2) < 0) {
                return sb.toString();
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static int getTextLengthInWord(String text) {
        char[] cText = text == null ? new char[]{} : text.toCharArray();
        int count = 0;
        for (int i = 0; i < cText.length; ++i) {
            count += cText[i] < '\u0100' ? 1 : 2;
        }
        return count;
    }

    public static long strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate.getTime();
    }

    public static long dateStrToLong(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate.getTime();
    }

    public static Date longToDate(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        return cal.getTime();
    }

    public static String longToTime(long time, int level) {
        String format = "yyyy-MM-dd kk:mm:ss";
        switch (level) {
            case 12: {
                format = "yyyy-MM-dd kk:mm";
                break;
            }
            case 10: {
                format = "yyyy-MM-dd kk";
                break;
            }
            case 5: {
                format = "yyyy-MM-dd";
                break;
            }
            case 2: {
                format = "yyyy-MM";
                break;
            }
            case 1: {
                format = "yyyy";
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(time);
    }

    public static long dateToLong(String date) {
        try {
            Date d = new Date(date);
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            return cal.getTimeInMillis();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return 0L;
        }
    }

    public static int[] covertTimeInYears(long time) {
        long delta = System.currentTimeMillis() - time;
        if (delta <= 0L) {
            return new int[]{0, 0};
        }
        if ((delta /= 1000L) < 60L) {
            return new int[]{(int)delta, 0};
        }
        if ((delta /= 60L) < 60L) {
            return new int[]{(int)delta, 1};
        }
        if ((delta /= 60L) < 24L) {
            return new int[]{(int)delta, 2};
        }
        if ((delta /= 24L) < 30L) {
            return new int[]{(int)delta, 3};
        }
        if ((delta /= 30L) < 12L) {
            return new int[]{(int)delta, 4};
        }
        return new int[]{(int)(delta /= 12L), 5};
    }

    public static Uri pathToContentUri(Context context, String imagePath) {
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{imagePath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/images/media");
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id));
        }
        File imageFile = new File(imagePath);
        if (imageFile.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", imagePath);
            Uri baseUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            return context.getContentResolver().insert(baseUri, values);
        }
        return null;
    }

    public static String contentUriToPath(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (new File(uri.getPath()).exists()) {
            return uri.getPath();
        }
        String path = null;
        try {
            Cursor c = null;
            if (Build.VERSION.SDK_INT >= 19) {
                Class<?> clzDocumentsContract = Class.forName("android.provider.DocumentsContract");
                Method isDocumentUri = clzDocumentsContract.getMethod("isDocumentUri", Context.class, Uri.class);
                isDocumentUri.setAccessible(true);
                if (Boolean.TRUE.equals(isDocumentUri.invoke(null, context, uri))) {
                    Method getDocumentId = clzDocumentsContract.getMethod("getDocumentId", Uri.class);
                    getDocumentId.setAccessible(true);
                    String wholeID = String.valueOf(getDocumentId.invoke(null, uri));
                    String id = wholeID.split(":")[1];
                    String[] column = new String[]{"_data"};
                    String sel = "_id=?";
                    String[] args = new String[]{id};
                    c = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, column, sel, args, null);
                }
            }
            if (c == null) {
                c = context.getContentResolver().query(uri, null, null, null, null);
            }
            if (c != null) {
                if (c.moveToFirst()) {
                    path = c.getString(c.getColumnIndex("_data"));
                }
                c.close();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            path = null;
        }
        return path;
    }

    public static Uri videoPathToContentUri(Context context, String videoPath) {
        Cursor cursor = context.getContentResolver().query(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{videoPath}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id = cursor.getInt(cursor.getColumnIndex("_id"));
            Uri baseUri = Uri.parse((String)"content://media/external/video/media");
            return Uri.withAppendedPath((Uri)baseUri, (String)("" + id));
        }
        File videoFile = new File(videoPath);
        if (videoFile.exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", videoPath);
            Uri baseUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
            return context.getContentResolver().insert(baseUri, values);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Uri getMediaUri(Context context, String filePath, String mimeType) {
        Uri result;
        block5: {
            final Object object = new Object();
            result = null;
            mediaUri = null;
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{filePath}, (String[])new String[]{mimeType}, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onScanCompleted(String path, Uri uri) {
                    mediaUri = uri;
                    Object object2 = object;
                    synchronized (object2) {
                        object.notifyAll();
                    }
                }
            });
            try {
                if (mediaUri != null) break block5;
                Object object2 = object;
                synchronized (object2) {
                    object.wait(10000L);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        result = mediaUri;
        mediaUri = null;
        return result;
    }

    public static String encodeUrl(Bundle parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            if (value == null) {
                value = "";
            }
            if (first) {
                first = false;
            } else {
                sb.append("&");
            }
            sb.append(Data.urlEncode(key) + "=" + Data.urlEncode(String.valueOf(value)));
        }
        return sb.toString();
    }

    public static String encodeUrl(ArrayList<KVPair<String>> values) {
        if (values == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (KVPair<String> pair : values) {
            if (i > 0) {
                sb.append('&');
            }
            String key = pair.name;
            String value = (String)pair.value;
            if (key == null) continue;
            if (value == null) {
                value = "";
            }
            sb.append(Data.urlEncode(key) + "=" + Data.urlEncode(value));
            ++i;
        }
        return sb.toString();
    }

    public static Bundle urlToBundle(String url) {
        int index = url.indexOf("://");
        url = index >= 0 ? "http://" + url.substring(index + 1) : "http://" + url;
        try {
            URL u = new URL(url);
            Bundle b = ResHelper.decodeUrl(u.getQuery());
            b.putAll(ResHelper.decodeUrl(u.getRef()));
            return b;
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
            return new Bundle();
        }
    }

    public static Bundle decodeUrl(String s) {
        Bundle params = new Bundle();
        if (s != null) {
            String[] array;
            for (String parameter : array = s.split("&")) {
                String[] v = parameter.split("=");
                if (v.length < 2 || v[1] == null) {
                    params.putString(URLDecoder.decode(v[0]), "");
                    continue;
                }
                params.putString(URLDecoder.decode(v[0]), URLDecoder.decode(v[1]));
            }
        }
        return params;
    }

    public static int parseInt(String string) throws Throwable {
        return ResHelper.parseInt(string, 10);
    }

    public static int parseInt(String string, int radix) throws Throwable {
        return Integer.parseInt(string, radix);
    }

    public static long parseLong(String string) throws Throwable {
        return ResHelper.parseLong(string, 10);
    }

    public static long parseLong(String string, int radix) throws Throwable {
        return Long.parseLong(string, radix);
    }

    public static String toString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static <T> T forceCast(Object obj) {
        return ResHelper.forceCast(obj, null);
    }

    public static <T> T forceCast(Object obj, T defValue) {
        if (obj == null) {
            return defValue;
        }
        if (obj instanceof Byte) {
            byte value = (Byte)obj;
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(value != 0);
            }
            if (defValue instanceof Short) {
                return (T)Short.valueOf(value);
            }
            if (defValue instanceof Character) {
                return (T)Character.valueOf((char)value);
            }
            if (defValue instanceof Integer) {
                return (T)Integer.valueOf(value);
            }
            if (defValue instanceof Float) {
                return (T)Float.valueOf(value);
            }
            if (defValue instanceof Long) {
                return (T)Long.valueOf(value);
            }
            if (defValue instanceof Double) {
                return (T)Double.valueOf(value);
            }
        } else if (obj instanceof Character) {
            char value = ((Character)obj).charValue();
            if (defValue instanceof Byte) {
                return (T)Byte.valueOf((byte)value);
            }
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(value != '\u0000');
            }
            if (defValue instanceof Short) {
                return (T)Short.valueOf((short)value);
            }
            if (defValue instanceof Integer) {
                return (T)Integer.valueOf(value);
            }
            if (defValue instanceof Float) {
                return (T)Float.valueOf(value);
            }
            if (defValue instanceof Long) {
                return (T)Long.valueOf(value);
            }
            if (defValue instanceof Double) {
                return (T)Double.valueOf(value);
            }
        } else if (obj instanceof Short) {
            short value = (Short)obj;
            if (defValue instanceof Byte) {
                return (T)Byte.valueOf((byte)value);
            }
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(value != 0);
            }
            if (defValue instanceof Character) {
                return (T)Character.valueOf((char)value);
            }
            if (defValue instanceof Integer) {
                return (T)Integer.valueOf(value);
            }
            if (defValue instanceof Float) {
                return (T)Float.valueOf(value);
            }
            if (defValue instanceof Long) {
                return (T)Long.valueOf(value);
            }
            if (defValue instanceof Double) {
                return (T)Double.valueOf(value);
            }
        } else if (obj instanceof Integer) {
            int value = (Integer)obj;
            if (defValue instanceof Byte) {
                return (T)Byte.valueOf((byte)value);
            }
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(value != 0);
            }
            if (defValue instanceof Character) {
                return (T)Character.valueOf((char)value);
            }
            if (defValue instanceof Short) {
                return (T)Short.valueOf((short)value);
            }
            if (defValue instanceof Float) {
                return (T)Float.valueOf(value);
            }
            if (defValue instanceof Long) {
                return (T)Long.valueOf(value);
            }
            if (defValue instanceof Double) {
                return (T)Double.valueOf(value);
            }
        } else if (obj instanceof Float) {
            float value = ((Float)obj).floatValue();
            if (defValue instanceof Byte) {
                return (T)Byte.valueOf((byte)value);
            }
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(value != 0.0f);
            }
            if (defValue instanceof Character) {
                return (T)Character.valueOf((char)value);
            }
            if (defValue instanceof Short) {
                return (T)Short.valueOf((short)value);
            }
            if (defValue instanceof Integer) {
                return (T)Integer.valueOf((int)value);
            }
            if (defValue instanceof Long) {
                return (T)Long.valueOf((long)value);
            }
            if (defValue instanceof Double) {
                return (T)Double.valueOf(value);
            }
        } else if (obj instanceof Long) {
            long value = (Long)obj;
            if (defValue instanceof Byte) {
                return (T)Byte.valueOf((byte)value);
            }
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(value != 0L);
            }
            if (defValue instanceof Character) {
                return (T)Character.valueOf((char)value);
            }
            if (defValue instanceof Short) {
                return (T)Short.valueOf((short)value);
            }
            if (defValue instanceof Integer) {
                return (T)Integer.valueOf((int)value);
            }
            if (defValue instanceof Float) {
                return (T)Float.valueOf(value);
            }
            if (defValue instanceof Double) {
                return (T)Double.valueOf(value);
            }
        } else if (obj instanceof Double) {
            double value = (Double)obj;
            if (defValue instanceof Byte) {
                return (T)Byte.valueOf((byte)value);
            }
            if (defValue instanceof Boolean) {
                return (T)Boolean.valueOf(value != 0.0);
            }
            if (defValue instanceof Character) {
                return (T)Character.valueOf((char)value);
            }
            if (defValue instanceof Short) {
                return (T)Short.valueOf((short)value);
            }
            if (defValue instanceof Integer) {
                return (T)Integer.valueOf((int)value);
            }
            if (defValue instanceof Float) {
                return (T)Float.valueOf((float)value);
            }
            if (defValue instanceof Long) {
                return (T)Long.valueOf((long)value);
            }
        }
        try {
            return (T)obj;
        }
        catch (Throwable throwable) {
            return defValue;
        }
    }

    public static boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public static <T> boolean isEqual(T o1, T o2) {
        boolean notEqual = o1 == null && o2 != null || o1 != null && !o1.equals(o2);
        return !notEqual;
    }

    public static boolean copyFile(String fromFilePath, String toFilePath) {
        if (TextUtils.isEmpty((CharSequence)fromFilePath) || TextUtils.isEmpty((CharSequence)toFilePath)) {
            return false;
        }
        if (!new File(fromFilePath).exists()) {
            return false;
        }
        try {
            FileInputStream fisfrom = new FileInputStream(fromFilePath);
            FileOutputStream fosto = new FileOutputStream(toFilePath);
            ResHelper.copyFile(fisfrom, fosto);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static void copyFile(FileInputStream src, FileOutputStream dst) throws Throwable {
        byte[] buf = new byte[65536];
        int len = src.read(buf);
        while (len > 0) {
            dst.write(buf, 0, len);
            len = src.read(buf);
        }
        src.close();
        dst.close();
    }

    public static long getFileSize(String path) throws Throwable {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return 0L;
        }
        File file = new File(path);
        return ResHelper.getFileSize(file);
    }

    public static long getFileSize(File file) throws Throwable {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isDirectory()) {
            String[] names = file.list();
            int size = 0;
            for (int i = 0; i < names.length; ++i) {
                File f = new File(file, names[i]);
                size = (int)((long)size + ResHelper.getFileSize(f));
            }
            return size;
        }
        return file.length();
    }

    public static boolean saveObjectToFile(String filePath, Object object) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File cacheFile = null;
            try {
                cacheFile = new File(filePath);
                if (cacheFile.exists()) {
                    cacheFile.delete();
                }
                if (!cacheFile.getParentFile().exists()) {
                    cacheFile.getParentFile().mkdirs();
                }
                cacheFile.createNewFile();
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                cacheFile = null;
            }
            if (cacheFile != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(cacheFile);
                    GZIPOutputStream gzos = new GZIPOutputStream(fos);
                    ObjectOutputStream oos = new ObjectOutputStream(gzos);
                    oos.writeObject(object);
                    oos.flush();
                    oos.close();
                    return true;
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                }
            }
        }
        return false;
    }

    public static Object readObjectFromFile(String filePath) {
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            File cacheFile = null;
            try {
                cacheFile = new File(filePath);
                if (!cacheFile.exists()) {
                    cacheFile = null;
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                cacheFile = null;
            }
            if (cacheFile != null) {
                try {
                    FileInputStream fis = new FileInputStream(cacheFile);
                    GZIPInputStream gzis = new GZIPInputStream(fis);
                    ObjectInputStream ois = new ObjectInputStream(gzis);
                    Object object = ois.readObject();
                    ois.close();
                    return object;
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                }
            }
        }
        return null;
    }

    public static <T> T getStringValue(Context context, String name, T defaultValue) {
        try {
            String value = context.getString(ResHelper.getStringRes(context, name)).trim();
            if (defaultValue == null) {
                return (T)String.valueOf(value);
            }
            Class<?> clazz = defaultValue.getClass();
            if (clazz.equals(String.class)) {
                return (T)String.valueOf(value);
            }
            if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
                return (T)Integer.valueOf(String.valueOf(value));
            }
            if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
                return (T)Long.valueOf(String.valueOf(value));
            }
            if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
                return (T)Boolean.valueOf(value);
            }
            if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
                return (T)Float.valueOf(String.valueOf(value));
            }
            if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
                return (T)Double.valueOf(String.valueOf(value));
            }
            if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
                return (T)Character.valueOf(String.valueOf(value).charAt(0));
            }
            if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
                return (T)Byte.valueOf(String.valueOf(value));
            }
            if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
                return (T)Short.valueOf(String.valueOf(value));
            }
            return (T)new Hashon().fromJson(value, clazz);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return defaultValue;
        }
    }
}

