/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.app.Activity;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.location.Location;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.mob.tools.MobLog;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.LocationHelper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.ResHelper;
import com.mob.tools.utils.Strings;
import com.mob.tools.utils.UIHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class DeviceHelper {
    private Context context;
    private String advertiseID;
    private String imei;
    private String serialno;
    private String mac;
    private static DeviceHelper deviceHelper;

    public static synchronized DeviceHelper getInstance(Context c) {
        if (deviceHelper == null && c != null) {
            deviceHelper = new DeviceHelper(c);
        }
        return deviceHelper;
    }

    private DeviceHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    public boolean isRooted() {
        try {
            File f = new File(Strings.getString(0));
            if (f.exists() && f.canExecute()) {
                return true;
            }
            f = new File(Strings.getString(1));
            return f.exists() && f.canExecute();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    public String getSSID() {
        try {
            if (this.checkPermission("android.permission.ACCESS_WIFI_STATE")) {
                Object wifi = this.getSystemServiceSave("wifi");
                if (wifi == null) {
                    return null;
                }
                Object info = ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(2), new Object[0]);
                if (info != null) {
                    String ssid = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(3), new Object[0]);
                    return ssid == null ? null : ssid.replace("\"", "");
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public String getBssid() {
        try {
            if (this.checkPermission("android.permission.ACCESS_WIFI_STATE")) {
                Object wifi = this.getSystemServiceSave("wifi");
                if (wifi == null) {
                    return null;
                }
                Object info = ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(2), new Object[0]);
                if (info != null) {
                    String bssid = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(4), new Object[0]);
                    return bssid == null ? null : bssid;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    private String getLocalWifiMac() {
        try {
            File file = new File(ResHelper.getCacheRoot(this.context), ".mcw");
            String wifiMac = Data.AES128Decode("1234567890abcdfg", (byte[])ResHelper.readObjectFromFile(file.getPath()));
            if (!TextUtils.isEmpty((CharSequence)wifiMac) && wifiMac.trim().matches("^[a-fA-F0-9]{2}(:[a-fA-F0-9]{2}){5}$")) {
                return wifiMac.trim();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    private void saveLocalWifiMac(String mac) {
        try {
            if (!TextUtils.isEmpty((CharSequence)mac) && mac.trim().matches("^[a-fA-F0-9]{2}(:[a-fA-F0-9]{2}){5}$")) {
                File file = new File(ResHelper.getCacheRoot(this.context), ".mcw");
                byte[] string = Data.AES128Encode("1234567890abcdfg", mac.trim());
                ResHelper.saveObjectToFile(file.getPath(), string);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    private String getLocalSerial() {
        try {
            File file = new File(ResHelper.getCacheRoot(this.context), ".slw");
            String wifiMac = Data.AES128Decode("1234567890abcdfi", (byte[])ResHelper.readObjectFromFile(file.getPath()));
            if (!TextUtils.isEmpty((CharSequence)wifiMac)) {
                return wifiMac.trim();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    private void saveLocalSerial(String serialNo) {
        try {
            if (!TextUtils.isEmpty((CharSequence)serialNo) && !serialNo.trim().equals("")) {
                File file = new File(ResHelper.getCacheRoot(this.context), ".slw");
                byte[] string = Data.AES128Encode("1234567890abcdfi", serialNo.trim());
                ResHelper.saveObjectToFile(file.getPath(), string);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    public String getMacAddress() {
        if (!TextUtils.isEmpty((CharSequence)this.mac)) {
            return this.mac;
        }
        String localWifiMac = this.getLocalWifiMac();
        if (!TextUtils.isEmpty((CharSequence)localWifiMac)) {
            this.mac = localWifiMac;
            return localWifiMac;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            String hd = null;
            try {
                hd = this.getHardwareAddressFromShell("wlan0");
                if (hd != null) {
                    this.saveLocalWifiMac(hd);
                    return hd;
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                hd = null;
            }
            if (hd == null) {
                try {
                    hd = this.getCurrentNetworkHardwareAddress();
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                    hd = null;
                }
            }
            if (hd == null) {
                try {
                    String[] hds = this.listNetworkHardwareAddress();
                    if (hds.length > 0) {
                        hd = hds[0];
                    }
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t);
                    hd = null;
                }
            }
            if (hd != null) {
                if ("wifi".equals(this.getNetworkType())) {
                    this.saveLocalWifiMac(hd.trim());
                }
                this.mac = hd.trim();
                return hd.trim();
            }
        }
        try {
            String mac;
            Object wifi = this.getSystemServiceSave("wifi");
            if (wifi == null) {
                return null;
            }
            Object info = ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(2), new Object[0]);
            if (info != null && (mac = (String)ReflectHelper.invokeInstanceMethod(info, Strings.getString(5), new Object[0])) != null) {
                this.mac = mac.trim();
                this.saveLocalWifiMac(mac.trim());
                return mac.trim();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    private String getCurrentNetworkHardwareAddress() throws Throwable {
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis == null) {
            return null;
        }
        ArrayList<NetworkInterface> interfaces = Collections.list(nis);
        for (NetworkInterface intf : interfaces) {
            Enumeration<InetAddress> ias = intf.getInetAddresses();
            if (ias == null) continue;
            ArrayList<InetAddress> addrs = Collections.list(ias);
            for (InetAddress add : addrs) {
                if (add.isLoopbackAddress() || !(add instanceof Inet4Address)) continue;
                byte[] mac = null;
                if (Build.VERSION.SDK_INT >= 9) {
                    mac = intf.getHardwareAddress();
                }
                if (mac == null) continue;
                StringBuilder buf = new StringBuilder();
                for (byte aMac : mac) {
                    buf.append(String.format("%02x:", aMac));
                }
                if (buf.length() > 0) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                return buf.toString();
            }
        }
        return null;
    }

    private String[] listNetworkHardwareAddress() throws Throwable {
        HashMap<String, String> macs = this.listNetworkHardware();
        if (macs == null || macs.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>(macs.keySet());
        ArrayList<String> wlans = new ArrayList<String>();
        ArrayList<String> eths = new ArrayList<String>();
        ArrayList<String> rmnets = new ArrayList<String>();
        ArrayList<String> dummys = new ArrayList<String>();
        ArrayList<String> usbs = new ArrayList<String>();
        ArrayList<String> rmnetUsbs = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        while (names.size() > 0) {
            String name = names.remove(0);
            if (name.startsWith("wlan")) {
                wlans.add(name);
                continue;
            }
            if (name.startsWith("eth")) {
                eths.add(name);
                continue;
            }
            if (name.startsWith("rev_rmnet")) {
                rmnets.add(name);
                continue;
            }
            if (name.startsWith("dummy")) {
                dummys.add(name);
                continue;
            }
            if (name.startsWith("usbnet")) {
                usbs.add(name);
                continue;
            }
            if (name.startsWith("rmnet_usb")) {
                rmnetUsbs.add(name);
                continue;
            }
            others.add(name);
        }
        Collections.sort(wlans);
        Collections.sort(eths);
        Collections.sort(rmnets);
        Collections.sort(dummys);
        Collections.sort(usbs);
        Collections.sort(rmnetUsbs);
        Collections.sort(others);
        names.addAll(wlans);
        names.addAll(eths);
        names.addAll(rmnets);
        names.addAll(dummys);
        names.addAll(usbs);
        names.addAll(rmnetUsbs);
        names.addAll(others);
        String[] macArr = new String[names.size()];
        for (int i = 0; i < macArr.length; ++i) {
            macArr[i] = macs.get(names.get(i));
        }
        return macArr;
    }

    public HashMap<String, String> listNetworkHardware() throws Throwable {
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis == null) {
            return null;
        }
        ArrayList<NetworkInterface> interfaces = Collections.list(nis);
        HashMap<String, String> macs = new HashMap<String, String>();
        for (NetworkInterface intf : interfaces) {
            byte[] mac = null;
            if (Build.VERSION.SDK_INT >= 9) {
                mac = intf.getHardwareAddress();
            }
            if (mac == null) continue;
            StringBuilder buf = new StringBuilder();
            for (byte aMac : mac) {
                buf.append(String.format("%02x:", aMac));
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }
            macs.put(intf.getName(), buf.toString());
        }
        return macs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHardwareAddressFromShell(String networkCard) {
        String line = null;
        BufferedReader br = null;
        try {
            String clz = ReflectHelper.importClass(Strings.getString(42));
            Object rt = ReflectHelper.invokeStaticMethod(clz, Strings.getString(43), new Object[0]);
            String c = Strings.getString(6) + networkCard + Strings.getString(7);
            Object p = ReflectHelper.invokeInstanceMethod(rt, Strings.getString(44), c);
            InputStream is = (InputStream)ReflectHelper.invokeInstanceMethod(p, Strings.getString(45), new Object[0]);
            InputStreamReader isr = new InputStreamReader(is);
            br = new BufferedReader(isr);
            line = br.readLine();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Throwable clz) {}
            }
        }
        return TextUtils.isEmpty(line) ? null : line;
    }

    public String getModel() {
        String model = Build.MODEL;
        if (!TextUtils.isEmpty((CharSequence)model)) {
            model = model.trim();
        }
        return model;
    }

    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getDeviceId() {
        String deviceId = this.getIMEI();
        if (TextUtils.isEmpty((CharSequence)deviceId) && Build.VERSION.SDK_INT >= 9) {
            return this.getSerialno();
        }
        return deviceId;
    }

    public String getIMEI() {
        if (!TextUtils.isEmpty((CharSequence)this.imei)) {
            return this.imei;
        }
        Object phone = this.getSystemServiceSave("phone");
        if (phone == null) {
            return null;
        }
        String deviceId = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                deviceId = (String)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(8), new Object[0]);
            }
            if (TextUtils.isEmpty(deviceId)) {
                File keyFile = new File(ResHelper.getCacheRoot(this.context), "comm/.di");
                if (!keyFile.exists()) {
                    return null;
                }
                FileInputStream fis = new FileInputStream(keyFile);
                ObjectInputStream ois = new ObjectInputStream(fis);
                Object key = ois.readObject();
                String strKey = null;
                if (key != null && key instanceof char[]) {
                    char[] cKey = (char[])key;
                    strKey = String.valueOf(cKey);
                }
                ois.close();
                return strKey;
            }
            this.imei = deviceId;
            File keyFile = new File(ResHelper.getCacheRoot(this.context), "comm/.di");
            if (keyFile.exists()) {
                keyFile.delete();
            }
            FileOutputStream fos = new FileOutputStream(keyFile);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            char[] cKey = deviceId.toCharArray();
            oos.writeObject(cKey);
            oos.flush();
            oos.close();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return deviceId;
    }

    public String[] queryIMEI() {
        try {
            String[] parts = Strings.getString(54).split(";");
            String[][] keys = new String[parts.length][];
            for (int i = 0; i < parts.length; ++i) {
                keys[i] = parts[i].split(",");
            }
            for (String[] key : keys) {
                ArrayList<String> values = new ArrayList<String>();
                for (String name : key) {
                    String[] props;
                    String prop = this.getSystemProperties(name);
                    for (String p : props = prop.split(",")) {
                        if (TextUtils.isEmpty((CharSequence)p) || values.contains(p)) continue;
                        values.add(p);
                    }
                }
                if (values.size() <= 0) continue;
                return values.toArray(new String[values.size()]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    private String getSystemProperties(String key) {
        try {
            String cls = ReflectHelper.importClass(Strings.getString(9));
            Object o = ReflectHelper.invokeStaticMethod(cls, Strings.getString(10), key);
            if (o != null) {
                return String.valueOf(o);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return "";
    }

    public String getSerialno() {
        String local;
        if (!TextUtils.isEmpty((CharSequence)this.serialno)) {
            return this.serialno;
        }
        String serialno = null;
        if (Build.VERSION.SDK_INT >= 9 && Build.VERSION.SDK_INT < 26) {
            try {
                String clzName = ReflectHelper.importClass(Strings.getString(9));
                serialno = (String)ReflectHelper.invokeStaticMethod(clzName, Strings.getString(10), Strings.getString(11), "unknown");
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                serialno = null;
            }
        }
        if (TextUtils.isEmpty(serialno) || "unknown".equalsIgnoreCase(serialno)) {
            serialno = Build.SERIAL;
        }
        if (TextUtils.isEmpty((CharSequence)serialno) || "unknown".equalsIgnoreCase(serialno)) {
            try {
                if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                    String buildClass = ReflectHelper.importClass("android.os.Build");
                    serialno = (String)ReflectHelper.invokeStaticMethod(buildClass, "getSerial", new Object[0]);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
                serialno = null;
            }
        }
        if (TextUtils.isEmpty((CharSequence)serialno) && !TextUtils.isEmpty((CharSequence)(local = this.getLocalSerial()))) {
            return local;
        }
        if (!TextUtils.isEmpty((CharSequence)serialno)) {
            this.serialno = serialno;
            serialno = serialno.trim();
            this.saveLocalSerial(serialno);
        }
        return serialno;
    }

    public String getDeviceData() {
        String data = this.getModel() + "|" + this.getOSVersionInt() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize();
        String deviString = this.getDeviceKey();
        return this.Base64AES(data, deviString.substring(0, 16));
    }

    public String getDeviceDataNotAES() {
        return this.getModel() + "|" + this.getOSVersionInt() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize();
    }

    public String Base64AES(String msg, String key) {
        String result = null;
        try {
            result = Base64.encodeToString((byte[])Data.AES128Encode(key, msg), (int)0);
            if (result.contains("\n")) {
                result = result.replace("\n", "");
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return result;
    }

    public int getOSVersionInt() {
        return Build.VERSION.SDK_INT;
    }

    public String getOSVersionName() {
        return Build.VERSION.RELEASE;
    }

    public String getOSLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getAppLanguage() {
        return this.context.getResources().getConfiguration().locale.getLanguage();
    }

    public String getOSCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getScreenSize() {
        int[] size = ResHelper.getScreenSize(this.context);
        if (this.context.getResources().getConfiguration().orientation == 1) {
            return size[0] + "x" + size[1];
        }
        return size[1] + "x" + size[0];
    }

    public String getCarrier() {
        try {
            Object tm = this.getSystemServiceSave("phone");
            if (tm == null) {
                return "-1";
            }
            String operator = (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(12), new Object[0]);
            if (TextUtils.isEmpty((CharSequence)operator)) {
                operator = "-1";
            }
            return operator;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return "-1";
        }
    }

    public String getCarrierName() {
        Object tm = this.getSystemServiceSave("phone");
        if (tm == null) {
            return null;
        }
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                String operator = (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(13), new Object[0]);
                if (TextUtils.isEmpty((CharSequence)operator)) {
                    operator = null;
                }
                return operator;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    public String getMCC() {
        String imsi = this.getIMSI();
        if (imsi != null && imsi.length() >= 3) {
            return imsi.substring(0, 3);
        }
        return null;
    }

    public String getMNC() {
        String imsi = this.getIMSI();
        if (imsi != null && imsi.length() >= 5) {
            return imsi.substring(3, 5);
        }
        return null;
    }

    public String getSimSerialNumber() {
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                Object tm = this.getSystemServiceSave("phone");
                if (tm == null) {
                    return "-1";
                }
                return (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(14), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return "-1";
    }

    public String getLine1Number() {
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                Object tm = this.getSystemServiceSave("phone");
                if (tm == null) {
                    return "-1";
                }
                return (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(15), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return "-1";
    }

    public String getBluetoothName() {
        try {
            String adapterClass;
            Object myDevice;
            if (this.checkPermission("android.permission.BLUETOOTH") && (myDevice = ReflectHelper.invokeStaticMethod(adapterClass = ReflectHelper.importClass(Strings.getString(16)), Strings.getString(17), new Object[0])) != null) {
                return (String)ReflectHelper.invokeInstanceMethod(myDevice, Strings.getString(18), new Object[0]);
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().d(e);
        }
        return null;
    }

    public String getSignMD5() {
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.getPackageName(), 64);
            Signature[] signs = packageInfo.signatures;
            return Data.MD5(signs[0].toByteArray());
        }
        catch (Exception e) {
            MobLog.getInstance().w(e);
            return null;
        }
    }

    private Object getSystemServiceSave(String name) {
        try {
            return this.context.getSystemService(name);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public String getNetworkType() {
        try {
            NetworkInfo network;
            Object conn;
            if (this.checkPermission("android.permission.ACCESS_NETWORK_STATE") && (conn = this.getSystemServiceSave("connectivity")) != null && (network = ((ConnectivityManager)conn).getActiveNetworkInfo()) != null && network.isAvailable()) {
                int type = network.getType();
                switch (type) {
                    case 1: {
                        return "wifi";
                    }
                    case 0: {
                        if (this.is4GMobileNetwork()) {
                            return "4G";
                        }
                        return this.isFastMobileNetwork() ? "3G" : "2G";
                    }
                    case 7: {
                        return "bluetooth";
                    }
                    case 8: {
                        return "dummy";
                    }
                    case 9: {
                        return "ethernet";
                    }
                    case 6: {
                        return "wimax";
                    }
                }
                return String.valueOf(type);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return "none";
    }

    public String getNetworkTypeForStatic() {
        String networkType = this.getNetworkType().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)networkType) || "none".equals(networkType)) {
            return "none";
        }
        if (networkType.startsWith("4g") || networkType.startsWith("3g") || networkType.startsWith("2g")) {
            return "cell";
        }
        if (networkType.startsWith("wifi")) {
            return "wifi";
        }
        return "other";
    }

    public String getDetailNetworkTypeForStatic() {
        String networkType = this.getNetworkType().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)networkType) || "none".equals(networkType)) {
            return "none";
        }
        if (networkType.startsWith("wifi")) {
            return "wifi";
        }
        if (networkType.startsWith("4g")) {
            return "4g";
        }
        if (networkType.startsWith("3g")) {
            return "3g";
        }
        if (networkType.startsWith("2g")) {
            return "2g";
        }
        if (networkType.startsWith("bluetooth")) {
            return "bluetooth";
        }
        return networkType;
    }

    public int getPlatformCode() {
        return 1;
    }

    private boolean is4GMobileNetwork() {
        Object phone = this.getSystemServiceSave("phone");
        if (phone == null) {
            return false;
        }
        try {
            int type = (Integer)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(19), new Object[0]);
            return type == 13;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    private boolean isFastMobileNetwork() {
        Object phone = this.getSystemServiceSave("phone");
        if (phone == null) {
            return false;
        }
        try {
            int type = (Integer)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(19), new Object[0]);
            switch (type) {
                case 7: {
                    return false;
                }
                case 4: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return true;
                }
                case 6: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 8: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 11: {
                    return false;
                }
                case 13: {
                    return true;
                }
                case 0: {
                    return false;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    public String getDeviceKey() {
        String deviceKey = null;
        try {
            deviceKey = this.getDeviceKeyWithDuid("comm/dbs/.duid");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if (TextUtils.isEmpty((CharSequence)deviceKey) || deviceKey.length() < 40) {
            deviceKey = this.genDeviceKey();
        }
        if (!TextUtils.isEmpty((CharSequence)deviceKey) && deviceKey.length() >= 40) {
            return deviceKey.trim();
        }
        try {
            deviceKey = this.getLocalDeviceKey();
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            deviceKey = null;
        }
        if (!TextUtils.isEmpty((CharSequence)deviceKey) && deviceKey.length() >= 40) {
            return deviceKey.trim();
        }
        if (TextUtils.isEmpty((CharSequence)deviceKey) || deviceKey.length() < 40) {
            deviceKey = this.getCharAndNumr(40);
        }
        if (deviceKey != null) {
            try {
                deviceKey = deviceKey.trim();
                this.saveLocalDeviceKey(deviceKey);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return deviceKey;
    }

    private String genDeviceKey() {
        String newKey = null;
        try {
            String mac = this.getMacAddress();
            String udid = this.getDeviceId();
            String model = this.getModel();
            String data = mac + ":" + udid + ":" + model;
            byte[] bytes = Data.SHA1(data);
            newKey = Data.byteToHex(bytes);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            newKey = null;
        }
        return newKey;
    }

    public String getCharAndNumr(int length) {
        long currentTime = System.currentTimeMillis();
        long elapseTime = SystemClock.elapsedRealtime();
        long realTime = currentTime ^ elapseTime;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(realTime);
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                char charValue = (char)(97 + random.nextInt(26));
                stringBuffer.insert(i + 1, charValue);
                continue;
            }
            stringBuffer.insert(stringBuffer.length(), random.nextInt(10));
        }
        return stringBuffer.toString().substring(0, 40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeviceKeyWithDuid(String duidFilePath) throws Throwable {
        HashMap map;
        block19: {
            map = null;
            try {
                File file = new File(ResHelper.getCacheRoot(this.context), duidFilePath);
                if (!file.exists() || !file.isFile()) break block19;
                ObjectInputStream ois = null;
                try {
                    FileInputStream fis = new FileInputStream(file);
                    ois = new ObjectInputStream(fis);
                    map = (HashMap)ois.readObject();
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Throwable fis) {}
                    }
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        if (map == null) {
            return null;
        }
        HashMap deviceInfo = (HashMap)map.get("deviceInfo");
        if (deviceInfo == null) {
            return null;
        }
        String deviceKey = "";
        try {
            String mac = (String)deviceInfo.get("mac");
            String deviceId = (String)deviceInfo.get("imei");
            if (TextUtils.isEmpty((CharSequence)deviceId) && Build.VERSION.SDK_INT >= 9) {
                deviceId = (String)deviceInfo.get("serialno");
            }
            String model = (String)deviceInfo.get("model");
            String data = mac + ":" + deviceId + ":" + model;
            byte[] bytes = Data.SHA1(data);
            deviceKey = Data.byteToHex(bytes);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            deviceKey = null;
        }
        return deviceKey;
    }

    private String getLocalDeviceKey() throws Throwable {
        boolean success;
        File keyFile;
        if (!this.getSdcardState()) {
            return null;
        }
        String sdPath = this.getSdcardPath();
        File cacheRoot = new File(sdPath, "ShareSDK");
        if (cacheRoot.exists() && (keyFile = new File(cacheRoot, ".dk")).exists() && (success = keyFile.renameTo(new File(ResHelper.getCacheRoot(this.context), ".dk")))) {
            keyFile.delete();
        }
        if (!(keyFile = new File(ResHelper.getCacheRoot(this.context), ".dk")).exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(keyFile);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object key = ois.readObject();
        String strKey = null;
        if (key != null && key instanceof char[]) {
            char[] cKey = (char[])key;
            strKey = String.valueOf(cKey);
        }
        ois.close();
        return strKey;
    }

    private void saveLocalDeviceKey(String key) throws Throwable {
        if (!this.getSdcardState()) {
            return;
        }
        File keyFile = new File(ResHelper.getCacheRoot(this.context), ".dk");
        if (keyFile.exists()) {
            keyFile.delete();
        }
        FileOutputStream fos = new FileOutputStream(keyFile);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        char[] cKey = key.toCharArray();
        oos.writeObject(cKey);
        oos.flush();
        oos.close();
    }

    public String getPackageName() {
        return this.context.getPackageName();
    }

    public String getAppName() {
        int appLbl;
        String appName = this.context.getApplicationInfo().name;
        if (appName != null) {
            if (Build.VERSION.SDK_INT >= 25 && !appName.endsWith(".*")) {
                try {
                    ReflectHelper.importClass(appName);
                    appName = null;
                }
                catch (Throwable throwable) {}
            } else {
                return appName;
            }
        }
        appName = (appLbl = this.context.getApplicationInfo().labelRes) > 0 ? this.context.getString(appLbl) : String.valueOf(this.context.getApplicationInfo().nonLocalizedLabel);
        return appName;
    }

    public int getAppVersion() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            return pi.versionCode;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return 0;
        }
    }

    public String getAppVersionName() {
        try {
            PackageManager pm = this.context.getPackageManager();
            PackageInfo pi = pm.getPackageInfo(this.context.getPackageName(), 0);
            return pi.versionName;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return "1.0";
        }
    }

    public ArrayList<HashMap<String, String>> getInstalledApp(boolean includeSystemApp) {
        try {
            ArrayList<String> packages = new ArrayList<String>();
            try {
                String clz = ReflectHelper.importClass(Strings.getString(42));
                Object rt = ReflectHelper.invokeStaticMethod(clz, Strings.getString(43), new Object[0]);
                Object p = ReflectHelper.invokeInstanceMethod(rt, Strings.getString(44), Strings.getString(20));
                InputStream is = (InputStream)ReflectHelper.invokeInstanceMethod(p, Strings.getString(45), new Object[0]);
                InputStreamReader isr = new InputStreamReader(is, "utf-8");
                BufferedReader br = new BufferedReader(isr);
                String line = br.readLine();
                while (line != null) {
                    String prefix;
                    if ((line = line.trim()).length() > 8 && (prefix = line.substring(0, 8)).equalsIgnoreCase("package:")) {
                        line = line.substring(8).trim();
                        packages.add(line);
                    }
                    line = br.readLine();
                }
                br.close();
                ReflectHelper.invokeInstanceMethod(p, Strings.getString(51), new Object[0]);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
            ArrayList<HashMap<String, String>> apps = new ArrayList<HashMap<String, String>>();
            PackageManager pm = this.context.getPackageManager();
            for (String pkg : packages) {
                PackageInfo pi = null;
                try {
                    pi = pm.getPackageInfo(pkg, 0);
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
                if (pi == null || !includeSystemApp && this.isSystemApp(pi)) continue;
                HashMap<String, String> app = new HashMap<String, String>();
                app.put("pkg", pi.packageName);
                String appName = pi.applicationInfo.name;
                if (appName == null) {
                    CharSequence label;
                    int appLbl = pi.applicationInfo.labelRes;
                    if (appLbl > 0 && (label = pm.getText(pi.packageName, appLbl, pi.applicationInfo)) != null) {
                        appName = label.toString().trim();
                    }
                    if (appName == null) {
                        appName = String.valueOf(pi.applicationInfo.nonLocalizedLabel);
                    }
                }
                app.put("name", appName);
                app.put("version", pi.versionName);
                apps.add(app);
            }
            return apps;
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return new ArrayList<HashMap<String, String>>();
        }
    }

    private boolean isSystemApp(PackageInfo pi) {
        boolean isSysApp = (pi.applicationInfo.flags & 1) == 1;
        boolean isSysUpd = (pi.applicationInfo.flags & 0x80) == 1;
        return isSysApp || isSysUpd;
    }

    public String getNetworkOperator() {
        Object tm = this.getSystemServiceSave("phone");
        if (tm == null) {
            return null;
        }
        try {
            return (String)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(21), new Object[0]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return null;
        }
    }

    public boolean checkPermission(String permission) throws Throwable {
        int res;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                ReflectHelper.importClass("android.content.Context");
                Integer ret = (Integer)ReflectHelper.invokeInstanceMethod(this.context, Strings.getString(22), permission);
                res = ret == null ? -1 : ret;
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
                res = -1;
            }
        } else {
            res = this.context.getPackageManager().checkPermission(permission, this.getPackageName());
        }
        return res == 0;
    }

    public boolean amIOnForeground() {
        try {
            Object thread = DeviceHelper.currentActivityThread();
            Map activities = (Map)ReflectHelper.getInstanceField(thread, Strings.getString(23));
            for (Object activity : activities.values()) {
                Boolean stopped = (Boolean)ReflectHelper.getInstanceField(activity, Strings.getString(24));
                if (stopped.booleanValue()) continue;
                return true;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    public boolean getSdcardState() {
        try {
            return this.checkPermission("android.permission.WRITE_EXTERNAL_STORAGE") && "mounted".equals(Environment.getExternalStorageState());
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
            return false;
        }
    }

    public String getSdcardPath() {
        try {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getAndroidID() {
        String androidId = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        MobLog.getInstance().i("getAndroidID === " + androidId, new Object[0]);
        return androidId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAdvertisingID() throws Throwable {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new Throwable("Do not call this function from the main thread !");
        }
        if (!TextUtils.isEmpty((CharSequence)this.advertiseID)) {
            return this.advertiseID;
        }
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        GSConnection gsc = new GSConnection();
        try {
            this.context.bindService(intent, (ServiceConnection)gsc, 1);
            IBinder binder = gsc.takeBinder();
            if (binder == null) {
                String string = this.advertiseID;
                return string;
            }
            Parcel input = Parcel.obtain();
            Parcel output = Parcel.obtain();
            input.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
            binder.transact(1, input, output, 0);
            output.readException();
            this.advertiseID = output.readString();
            output.recycle();
            input.recycle();
            String string = this.advertiseID;
            return string;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            String string = this.advertiseID;
            return string;
        }
        finally {
            this.context.unbindService((ServiceConnection)gsc);
        }
    }

    public void hideSoftInput(View view) {
        Object service = this.getSystemServiceSave("input_method");
        if (service == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)service;
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public void showSoftInput(View view) {
        Object service = this.getSystemServiceSave("input_method");
        if (service == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)service;
        imm.toggleSoftInputFromWindow(view.getWindowToken(), 2, 0);
    }

    public String getIMSI() {
        String[] queryIMSI;
        Object phone = this.getSystemServiceSave("phone");
        if (phone == null) {
            return null;
        }
        String imsi = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                imsi = (String)ReflectHelper.invokeInstanceMethod(phone, Strings.getString(25), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        if ((imsi == null || imsi.length() < 15) && (queryIMSI = this.queryIMSI()) != null && queryIMSI.length > 0 && queryIMSI[0].length() >= 15) {
            imsi = queryIMSI[0];
        }
        if (TextUtils.isEmpty((CharSequence)imsi)) {
            return null;
        }
        return imsi;
    }

    public String[] queryIMSI() {
        try {
            String[] props;
            String prop = this.getSystemProperties(Strings.getString(55));
            ArrayList<String> values = new ArrayList<String>();
            for (String p : props = prop.split(",")) {
                if (TextUtils.isEmpty((CharSequence)p) || values.contains(p)) continue;
                values.add(p);
            }
            if (values.size() > 0) {
                return values.toArray(new String[values.size()]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    public String getIPAddress() {
        try {
            if (this.checkPermission("android.permission.INTERNET")) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface intf = en.nextElement();
                    Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        InetAddress inetAddress = enumIpAddr.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                        return inetAddress.getHostAddress();
                    }
                }
            }
        }
        catch (Throwable e) {
            MobLog.getInstance().w(e);
        }
        return "0.0.0.0";
    }

    public Location getLocation(int GPSTimeout, int networkTimeout, boolean useLastKnown) {
        try {
            if (this.checkPermission("android.permission.ACCESS_FINE_LOCATION")) {
                LocationHelper helper = new LocationHelper();
                return helper.getLocation(this.context, GPSTimeout, networkTimeout, useLastKnown);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public HashMap<String, String> ping(String address, int count, int packetsize) {
        ArrayList<Float> sucRes = new ArrayList<Float>();
        try {
            String cmd = "ping -c " + count + " -s " + packetsize + " " + address;
            int bytes = packetsize + 8;
            Process p = Runtime.getRuntime().exec(cmd);
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith(bytes + " bytes from")) {
                    if (line.endsWith("ms")) {
                        line = line.substring(0, line.length() - 2).trim();
                    } else if (line.endsWith("s")) {
                        line = line.substring(0, line.length() - 1).trim() + "000";
                    }
                    int i = line.indexOf("time=");
                    if (i > 0) {
                        line = line.substring(i + 5).trim();
                        try {
                            sucRes.add(Float.valueOf(Float.parseFloat(line)));
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().w(t);
                        }
                    }
                }
                line = br.readLine();
            }
            p.waitFor();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        int sucCount = sucRes.size();
        int fldCount = count - sucRes.size();
        float min = 0.0f;
        float max = 0.0f;
        float average = 0.0f;
        if (sucCount > 0) {
            min = Float.MAX_VALUE;
            for (int i = 0; i < sucCount; ++i) {
                float item = ((Float)sucRes.get(i)).floatValue();
                if (item < min) {
                    min = item;
                }
                if (item > max) {
                    max = item;
                }
                average += item;
            }
            average /= (float)sucCount;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("address", address);
        map.put("transmitted", String.valueOf(count));
        map.put("received", String.valueOf(sucCount));
        map.put("loss", String.valueOf(fldCount));
        map.put("min", String.valueOf(min));
        map.put("max", String.valueOf(max));
        map.put("avg", String.valueOf(average));
        return map;
    }

    public int getCellId() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && !"CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(27), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCellLac() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && !"CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(28), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getPsc() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && !"CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(63), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCdmaLat() {
        int lat = -1;
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                lat = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(56), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        if (lat == Integer.MAX_VALUE) {
            lat = -1;
        }
        return lat;
    }

    public int getCdmaLon() {
        int lon = -1;
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                lon = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(57), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        if (lon == Integer.MAX_VALUE) {
            lon = -1;
        }
        return lon;
    }

    public int getCdmaBid() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(56), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCdmaSid() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(59), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public int getCdmaNid() {
        try {
            Object loc;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (loc = ReflectHelper.invokeInstanceMethod(tm, Strings.getString(26), new Object[0])) != null && "CdmaCellLocation".equals(loc.getClass().getSimpleName())) {
                return ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(loc, Strings.getString(60), new Object[0]), -1);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return -1;
    }

    public ArrayList<HashMap<String, Object>> getNeighboringCellInfo() {
        try {
            List list;
            Object tm;
            if (this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") && (tm = this.getSystemServiceSave("phone")) != null && (list = (List)ReflectHelper.invokeInstanceMethod(tm, Strings.getString(61), new Object[0])) != null && list.size() > 0) {
                ArrayList<HashMap<String, Object>> resultList = new ArrayList<HashMap<String, Object>>();
                for (Object obj : list) {
                    int cid = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(27), new Object[0]), -1);
                    int lac = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(28), new Object[0]), -1);
                    int rssi = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(62), new Object[0]), -1);
                    int psc = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(63), new Object[0]), -1);
                    int networkType = ResHelper.forceCast(ReflectHelper.invokeInstanceMethod(obj, Strings.getString(19), new Object[0]), -1);
                    if (cid == -1 || lac == -1) continue;
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    map.put("cell", cid);
                    map.put("lac", lac);
                    map.put("rssi", rssi);
                    map.put("psc", psc);
                    map.put("networkType", networkType);
                    resultList.add(map);
                }
                if (resultList.size() > 0) {
                    return resultList;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return null;
    }

    public String getDeviceType() {
        try {
            UiModeManager um = (UiModeManager)this.getSystemServiceSave("uimode");
            if (um != null) {
                int type = um.getCurrentModeType();
                switch (type) {
                    case 1: {
                        return "NO_UI";
                    }
                    case 2: {
                        return "DESK";
                    }
                    case 3: {
                        return "CAR";
                    }
                    case 4: {
                        return "TELEVISION";
                    }
                    case 5: {
                        return "APPLIANCE";
                    }
                    case 6: {
                        return "WATCH";
                    }
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return "UNDEFINED";
    }

    public Activity getTopActivity() {
        try {
            Object thread = DeviceHelper.currentActivityThread();
            Map activities = (Map)ReflectHelper.getInstanceField(thread, Strings.getString(23));
            for (Object activity : activities.values()) {
                Boolean paused = (Boolean)ReflectHelper.getInstanceField(activity, Strings.getString(29));
                if (paused.booleanValue()) continue;
                return (Activity)ReflectHelper.getInstanceField(activity, Strings.getString(30));
            }
            for (Object activity : activities.values()) {
                Boolean stopped = (Boolean)ReflectHelper.getInstanceField(activity, Strings.getString(24));
                if (stopped.booleanValue()) continue;
                return (Activity)ReflectHelper.getInstanceField(activity, Strings.getString(30));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object currentActivityThread() {
        final ReflectHelper.ReflectRunnable<Void, Object> mainThreadAct = new ReflectHelper.ReflectRunnable<Void, Object>(){

            @Override
            public Object run(Void arg) {
                try {
                    String clzName = ReflectHelper.importClass(Strings.getString(31));
                    return ReflectHelper.invokeStaticMethod(clzName, Strings.getString(32), new Object[0]);
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                    return null;
                }
            }
        };
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
            return mainThreadAct.run(null);
        }
        final Object lock = new Object();
        final Object[] output = new Object[1];
        Object object = lock;
        synchronized (object) {
            UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean handleMessage(Message msg) {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            output[0] = mainThreadAct.run(null);
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().w(t);
                        }
                        finally {
                            lock.notify();
                        }
                    }
                    return false;
                }
            });
            try {
                lock.wait();
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return output[0];
    }

    public static Context getApplication() {
        try {
            Object actThread = DeviceHelper.currentActivityThread();
            if (actThread != null) {
                return (Context)ReflectHelper.invokeInstanceMethod(actThread, Strings.getString(33), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return null;
    }

    public ArrayList<HashMap<String, Object>> getAvailableWifiList() {
        block18: {
            try {
                if (!this.checkPermission("android.permission.ACCESS_WIFI_STATE")) break block18;
                Object wifi = this.getSystemServiceSave("wifi");
                if (wifi == null) {
                    return null;
                }
                List list = (List)ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(34), new Object[0]);
                if (list == null) {
                    return null;
                }
                String[] fields = TextUtils.split((String)Strings.getString(35), (String)",");
                String[] fldsToString = TextUtils.split((String)Strings.getString(36), (String)",");
                ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
                for (Object sr : list) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    String ssid = null;
                    for (String fld : fields) {
                        try {
                            if ("SSID".equals(fld)) {
                                ssid = (String)ReflectHelper.getInstanceField(sr, fld);
                                if (TextUtils.isEmpty((CharSequence)ssid)) break;
                                map.put(fld, ssid);
                                continue;
                            }
                            if ("capabilities".equals(fld)) {
                                String capabilities = (String)ReflectHelper.getInstanceField(sr, fld);
                                if (capabilities != null && capabilities.contains("[IBSS]")) {
                                    ssid = null;
                                    break;
                                }
                                map.put(fld, capabilities);
                                continue;
                            }
                            map.put(fld, ReflectHelper.getInstanceField(sr, fld));
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().w(t);
                        }
                    }
                    if (TextUtils.isEmpty(ssid)) continue;
                    for (String fld : fldsToString) {
                        try {
                            Object o = ReflectHelper.getInstanceField(sr, fld);
                            map.put(fld, o == null ? null : o.toString());
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().w(t);
                        }
                    }
                    try {
                        Object o = ReflectHelper.invokeInstanceMethod(sr, Strings.getString(37), new Object[0]);
                        map.put(Strings.getString(39), o);
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().w(t);
                    }
                    try {
                        List anqpLines = (List)ReflectHelper.getInstanceField(sr, Strings.getString(38));
                        map.put(Strings.getString(38), anqpLines == null ? null : new ArrayList(anqpLines));
                    }
                    catch (Throwable t) {
                        MobLog.getInstance().w(t);
                    }
                    result.add(map);
                }
                return result;
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return null;
    }

    private int getWifiSecurity(String capabilities) {
        if (capabilities != null) {
            if (capabilities.contains("WEP")) {
                return 1;
            }
            if (capabilities.contains("PSK")) {
                return 2;
            }
            if (capabilities.contains("EAP")) {
                return 3;
            }
        }
        return 0;
    }

    public boolean scanWifiList() {
        try {
            if (this.checkPermission("android.permission.CHANGE_WIFI_STATE")) {
                Object wifi = this.getSystemServiceSave("wifi");
                if (wifi == null) {
                    return false;
                }
                return (Boolean)ReflectHelper.invokeInstanceMethod(wifi, Strings.getString(40), new Object[0]);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return false;
    }

    public int getStatusBarHeight() {
        try {
            String clzName = ReflectHelper.importClass("com.android.internal.R$dimen");
            int resId = (Integer)ReflectHelper.getStaticField(clzName, "status_bar_height");
            return this.context.getResources().getDimensionPixelSize(resId);
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
            return -1;
        }
    }

    public boolean isPackageInstalled(String packageName) {
        try {
            return this.context.getPackageManager().getPackageInfo(packageName, 0) != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public HashMap<String, Object> getCPUInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            String line;
            FileReader fr = new FileReader(Strings.getString(41));
            BufferedReader br = new BufferedReader(fr);
            ArrayList processors = new ArrayList();
            map.put("processors", processors);
            HashMap<String, String> processor = null;
            while ((line = br.readLine()) != null) {
                String[] parts;
                if (TextUtils.isEmpty((CharSequence)line)) {
                    if (processor != null) {
                        processors.add(processor);
                    }
                    processor = null;
                    continue;
                }
                if ((line = line.trim()).startsWith("processor")) {
                    if (processor != null) {
                        processors.add(processor);
                    }
                    processor = new HashMap<String, String>();
                }
                if ((parts = line.split(":")) == null || parts.length <= 1) continue;
                if (processor == null) {
                    map.put(parts[0].trim(), parts[1].trim());
                    continue;
                }
                processor.put(parts[0].trim(), parts[1].trim());
            }
            br.close();
            fr.close();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return map;
    }

    public ArrayList<ArrayList<String>> getTTYDriversInfo() {
        ArrayList<ArrayList<String>> list = new ArrayList<ArrayList<String>>();
        try {
            String line;
            FileReader fr = new FileReader(Strings.getString(52));
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                String[] parts;
                if (TextUtils.isEmpty((CharSequence)line) || (parts = (line = line.trim()).split(" ")).length <= 1) continue;
                ArrayList<String> temp = new ArrayList<String>();
                for (String item : parts) {
                    if (TextUtils.isEmpty((CharSequence)item)) continue;
                    temp.add(item.trim());
                }
                list.add(temp);
            }
            br.close();
            fr.close();
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return list;
    }

    public void getBatteryState(final ReflectHelper.ReflectRunnable<HashMap<String, Object>, Void> callback) {
        block2: {
            try {
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.BATTERY_CHANGED");
                this.context.registerReceiver(new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (String key : intent.getExtras().keySet()) {
                            map.put(key, intent.getExtras().get(key));
                        }
                        if (callback != null) {
                            callback.run(map);
                        }
                        try {
                            context.unregisterReceiver((BroadcastReceiver)this);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }, intentFilter);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
                if (callback == null) break block2;
                callback.run(null);
            }
        }
    }

    public int getScreenBrightness() {
        int brightness = -1;
        try {
            ContentResolver resolver = this.context.getContentResolver();
            brightness = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return brightness;
    }

    public int getScreenBrightnessMode() {
        int brightnessMode = -1;
        try {
            ContentResolver resolver = this.context.getContentResolver();
            brightnessMode = Settings.System.getInt((ContentResolver)resolver, (String)"screen_brightness_mode");
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return brightnessMode;
    }

    public String getQemuKernel() {
        String qemuKernel = "0";
        try {
            String clzName = ReflectHelper.importClass(Strings.getString(9));
            qemuKernel = (String)ReflectHelper.invokeStaticMethod(clzName, Strings.getString(10), Strings.getString(53), "0");
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return qemuKernel;
    }

    private class GSConnection
    implements ServiceConnection {
        boolean got = false;
        private final BlockingQueue<IBinder> iBinders = new LinkedBlockingQueue<IBinder>();

        private GSConnection() {
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                this.iBinders.put(service);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }

        public IBinder takeBinder() throws InterruptedException {
            if (this.got) {
                throw new IllegalStateException();
            }
            this.got = true;
            return this.iBinders.poll(1500L, TimeUnit.MILLISECONDS);
        }
    }
}

