/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.app.Activity;
import android.app.Application;
import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.mob.tools.MobLog;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.ReflectHelper;
import java.util.HashSet;

public class ActivityTracker {
    private static ActivityTracker instance;
    private HashSet<Tracker> trackers = new HashSet();

    private ActivityTracker(Context context) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.initLevel14(context);
        } else {
            this.init(context);
        }
    }

    public static synchronized ActivityTracker getInstance(Context context) {
        if (instance == null) {
            instance = new ActivityTracker(context);
        }
        return instance;
    }

    private void initLevel14(Context context) {
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                ActivityTracker.this.onCreated(activity, savedInstanceState);
            }

            public void onActivityStarted(Activity activity) {
                ActivityTracker.this.onStarted(activity);
            }

            public void onActivityResumed(Activity activity) {
                ActivityTracker.this.onResumed(activity);
            }

            public void onActivityPaused(Activity activity) {
                ActivityTracker.this.onPaused(activity);
            }

            public void onActivityStopped(Activity activity) {
                ActivityTracker.this.onStopped(activity);
            }

            public void onActivityDestroyed(Activity activity) {
                ActivityTracker.this.onDestroyed(activity);
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                ActivityTracker.this.onSaveInstanceState(activity, outState);
            }
        });
    }

    private void init(Context context) {
        try {
            DeviceHelper.getInstance(context);
            Object thread = DeviceHelper.currentActivityThread();
            final Object origin = ReflectHelper.getInstanceField(thread, "mInstrumentation");
            ReflectHelper.setInstanceField(thread, "mInstrumentation", new Instrumentation(){

                public void callActivityOnCreate(Activity activity, Bundle icicle) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnCreate", activity, icicle);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnCreate(activity, icicle);
                    ActivityTracker.this.onCreated(activity, icicle);
                }

                public void callActivityOnStart(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnStart", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnStart(activity);
                    ActivityTracker.this.onStarted(activity);
                }

                public void callActivityOnResume(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnResume", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnResume(activity);
                    ActivityTracker.this.onResumed(activity);
                }

                public void callActivityOnPause(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnPause", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnPause(activity);
                    ActivityTracker.this.onPaused(activity);
                }

                public void callActivityOnStop(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnStop", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnStop(activity);
                    ActivityTracker.this.onStopped(activity);
                }

                public void callActivityOnDestroy(Activity activity) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnDestroy", activity);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnDestroy(activity);
                    ActivityTracker.this.onDestroyed(activity);
                }

                public void callActivityOnSaveInstanceState(Activity activity, Bundle outState) {
                    if (origin != null) {
                        try {
                            ReflectHelper.invokeInstanceMethod(origin, "callActivityOnSaveInstanceState", activity, outState);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    super.callActivityOnSaveInstanceState(activity, outState);
                    ActivityTracker.this.onSaveInstanceState(activity, outState);
                }
            });
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    public synchronized void addTracker(Tracker tracker) {
        this.trackers.add(tracker);
    }

    public synchronized void removeTracker(Tracker tracker) {
        this.trackers.remove(tracker);
    }

    private void onCreated(Activity activity, Bundle savedInstanceState) {
        for (Tracker t : this.trackers) {
            if (t == null) continue;
            t.onCreated(activity, savedInstanceState);
        }
    }

    private void onStarted(Activity activity) {
        for (Tracker t : this.trackers) {
            if (t == null) continue;
            t.onStarted(activity);
        }
    }

    private void onResumed(Activity activity) {
        for (Tracker t : this.trackers) {
            if (t == null) continue;
            t.onResumed(activity);
        }
    }

    private void onPaused(Activity activity) {
        for (Tracker t : this.trackers) {
            if (t == null) continue;
            t.onPaused(activity);
        }
    }

    private void onStopped(Activity activity) {
        for (Tracker t : this.trackers) {
            if (t == null) continue;
            t.onStopped(activity);
        }
    }

    private void onDestroyed(Activity activity) {
        for (Tracker t : this.trackers) {
            if (t == null) continue;
            t.onDestroyed(activity);
        }
    }

    private void onSaveInstanceState(Activity activity, Bundle outState) {
        for (Tracker t : this.trackers) {
            if (t == null) continue;
            t.onSaveInstanceState(activity, outState);
        }
    }

    public static interface Tracker {
        public void onCreated(Activity var1, Bundle var2);

        public void onStarted(Activity var1);

        public void onResumed(Activity var1);

        public void onPaused(Activity var1);

        public void onStopped(Activity var1);

        public void onDestroyed(Activity var1);

        public void onSaveInstanceState(Activity var1, Bundle var2);
    }
}

