/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.mob.tools.gui.PullToRequestAdatper;

public class PullToRequestView
extends RelativeLayout {
    private static final long MIN_REF_TIME = 1000L;
    private static final int FAULT_TOLERANCE_RANGE = 10;
    private PullToRequestAdatper adapter;
    private View headerView;
    private View bodyView;
    private View footerView;
    private int headerHeight;
    private int footerHeight;
    private int top;
    private float downY;
    private int state;
    private boolean pullingDownLock;
    private boolean pullingUpLock;
    private Runnable stopAct;
    private long pullTime;

    public PullToRequestView(Context context) {
        super(context);
        this.init();
    }

    public PullToRequestView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PullToRequestView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.stopAct = new Runnable(){

            @Override
            public void run() {
                PullToRequestView.this.reversePulling();
            }
        };
    }

    public void setAdapter(PullToRequestAdatper adapter) {
        this.adapter = adapter;
        this.removeAllViews();
        this.bodyView = (View)adapter.getBodyView();
        RelativeLayout.LayoutParams lpBody = new RelativeLayout.LayoutParams(-1, -1);
        lpBody.addRule(9);
        lpBody.addRule(11);
        lpBody.addRule(10);
        this.addView(this.bodyView, (ViewGroup.LayoutParams)lpBody);
        this.headerView = adapter.getHeaderView();
        this.headerView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        this.headerView.measure(0, 0);
        this.headerHeight = this.headerView.getMeasuredHeight();
        RelativeLayout.LayoutParams lpHead = new RelativeLayout.LayoutParams(-2, this.headerHeight);
        lpHead.addRule(9);
        lpHead.addRule(11);
        lpHead.addRule(10);
        lpHead.topMargin = -this.headerHeight;
        this.addView(this.headerView, (ViewGroup.LayoutParams)lpHead);
        this.footerView = adapter.getFooterView();
        this.footerView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        this.footerView.measure(0, 0);
        this.footerHeight = this.footerView.getMeasuredHeight();
        RelativeLayout.LayoutParams lpFooter = new RelativeLayout.LayoutParams(-2, this.headerHeight);
        lpFooter.addRule(9);
        lpFooter.addRule(11);
        lpFooter.addRule(12);
        lpFooter.bottomMargin = -this.headerHeight;
        this.addView(this.footerView, (ViewGroup.LayoutParams)lpFooter);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        block33: {
            block0 : switch (ev.getAction()) {
                case 0: {
                    this.downY = ev.getY();
                    break;
                }
                case 2: {
                    float curY = ev.getY();
                    switch (this.state) {
                        case 1: {
                            this.top = (int)((float)this.top + (curY - this.downY) / 2.0f);
                            if (this.top < 0) {
                                this.top = 0;
                            }
                            this.scrollTo(0, -this.top);
                            ev = this.getCancelEvent(ev);
                            break;
                        }
                        case -1: {
                            this.top = (int)((float)this.top + (curY - this.downY) / 2.0f);
                            if (this.top > 0) {
                                this.top = 0;
                            }
                            this.scrollTo(0, -this.top);
                            ev = this.getCancelEvent(ev);
                            break;
                        }
                        default: {
                            if (this.top > 0) {
                                this.top = (int)((float)this.top + (curY - this.downY) / 2.0f);
                                if (this.top < 0) {
                                    this.top = 0;
                                }
                                this.scrollTo(0, -this.top);
                                if (this.adapter != null && this.headerHeight != 0) {
                                    this.adapter.onPullDown(this.top * 100 / this.headerHeight);
                                }
                                ev = this.getCancelEvent(ev);
                                break;
                            }
                            if (this.top < 0) {
                                this.top = (int)((float)this.top + (curY - this.downY) / 2.0f);
                                if (this.top > 0) {
                                    this.top = 0;
                                }
                                this.scrollTo(0, -this.top);
                                if (this.adapter != null && this.footerHeight != 0) {
                                    this.adapter.onPullUp(-this.top * 100 / this.footerHeight);
                                }
                                ev = this.getCancelEvent(ev);
                                break;
                            }
                            if (curY - this.downY > 10.0f) {
                                if (!this.canPullDown()) break;
                                this.top = (int)((float)this.top + (curY - this.downY) / 2.0f);
                                this.scrollTo(0, -this.top);
                                if (this.adapter != null && this.headerHeight != 0) {
                                    this.adapter.onPullUp(-this.top * 100 / this.headerHeight);
                                }
                                ev = this.getCancelEvent(ev);
                                break;
                            }
                            if (!(this.downY - curY > 10.0f) || !this.canPullUp()) break;
                            this.top = (int)((float)this.top + (curY - this.downY) / 2.0f);
                            this.scrollTo(0, -this.top);
                            if (this.adapter != null && this.footerHeight != 0) {
                                this.adapter.onPullUp(-this.top * 100 / this.footerHeight);
                            }
                            ev = this.getCancelEvent(ev);
                        }
                    }
                    this.downY = curY;
                    break;
                }
                case 1: 
                case 3: {
                    switch (this.state) {
                        case 0: {
                            if (this.top > this.headerHeight) {
                                this.top = this.headerHeight;
                                this.scrollTo(0, -this.top);
                                if (this.adapter != null) {
                                    this.adapter.onPullDown(100);
                                }
                                this.performFresh();
                                ev = this.getCancelEvent(ev);
                                break block0;
                            }
                            if (this.top < -this.footerHeight) {
                                this.top = -this.footerHeight;
                                this.scrollTo(0, -this.top);
                                if (this.adapter != null) {
                                    this.adapter.onPullUp(100);
                                }
                                this.performRequestNext();
                                ev = this.getCancelEvent(ev);
                                break block0;
                            }
                            if (this.top != 0) {
                                this.scrollTo(0, 0);
                                if (this.adapter != null) {
                                    if (this.top > 0) {
                                        this.adapter.onPullDown(0);
                                    } else {
                                        this.adapter.onPullUp(0);
                                    }
                                }
                                this.top = 0;
                                break block0;
                            }
                            break block33;
                        }
                        case 1: {
                            this.top = this.headerHeight;
                            this.scrollTo(0, -this.top);
                            break block0;
                        }
                        case -1: {
                            this.top = -this.footerHeight;
                            this.scrollTo(0, -this.top);
                        }
                    }
                }
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private MotionEvent getCancelEvent(MotionEvent ev) {
        return MotionEvent.obtain((long)ev.getDownTime(), (long)ev.getEventTime(), (int)3, (float)ev.getX(), (float)ev.getY(), (int)ev.getMetaState());
    }

    public void performPullingDown(boolean request) {
        this.top = this.headerHeight;
        this.scrollTo(0, -this.top);
        if (request) {
            this.performFresh();
        }
    }

    protected void performFresh() {
        this.pullTime = System.currentTimeMillis();
        this.state = 1;
        if (this.adapter != null) {
            this.adapter.onRefresh();
        }
    }

    public void performPullingUp(boolean request) {
        this.top = -this.footerHeight;
        this.scrollTo(0, -this.top);
        if (request) {
            this.performRequestNext();
        }
    }

    private void performRequestNext() {
        this.pullTime = System.currentTimeMillis();
        this.state = -1;
        if (this.adapter != null) {
            this.adapter.onRequestNext();
        }
    }

    private void reversePulling() {
        this.top = 0;
        this.scrollTo(0, 0);
        this.state = 0;
        if (this.adapter != null) {
            this.adapter.onReversed();
        }
    }

    public void stopPulling() {
        long curTime = System.currentTimeMillis();
        long delta = curTime - this.pullTime;
        if (delta < 1000L) {
            this.postDelayed(this.stopAct, 1000L - delta);
        } else {
            this.post(this.stopAct);
        }
    }

    public void lockPullingDown() {
        this.pullingDownLock = true;
    }

    public void lockPullingUp() {
        this.pullingUpLock = true;
    }

    public void releasePullingDownLock() {
        this.pullingDownLock = false;
    }

    public void releasePullingUpLock() {
        this.pullingUpLock = false;
    }

    private boolean canPullDown() {
        return !this.pullingDownLock && this.adapter.isPullDownReady() && this.state == 0;
    }

    private boolean canPullUp() {
        return !this.pullingUpLock && this.adapter.isPullUpReady() && this.state == 0;
    }
}

