/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import com.mob.tools.gui.ViewPagerAdapter;

public class MobViewPager
extends ViewGroup {
    private static final int SNAP_VELOCITY = 500;
    private static final int DECELERATION = 10;
    private int touchSlop;
    private int maximumVelocity;
    private ViewPagerAdapter adapter;
    private int currentScreen;
    private int screenCount;
    private View previousPage;
    private View currentPage;
    private View nextPage;
    private boolean scrolling;
    private int flingVelocity;
    private boolean moving;
    private VelocityTracker velocityTracker;
    private float lastMotionX;
    private float lastMotionY;

    public MobViewPager(Context context) {
        this(context, null);
    }

    public MobViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MobViewPager(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.maximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void setAdapter(ViewPagerAdapter adapter) {
        if (this.adapter != null) {
            this.adapter.setMobViewPager(null);
        }
        this.removeAllViews();
        this.adapter = adapter;
        if (adapter == null) {
            this.screenCount = 0;
            this.currentScreen = 0;
            return;
        }
        adapter.setMobViewPager(this);
        this.screenCount = adapter.getCount();
        if (this.screenCount <= 0) {
            this.currentScreen = 0;
            return;
        }
        if (this.screenCount <= this.currentScreen) {
            this.currentScreen = this.screenCount - 1;
        }
        if (this.currentScreen > 0) {
            this.previousPage = adapter.getView(this.currentScreen - 1, this.previousPage, this);
            this.addView(this.previousPage);
        }
        this.currentPage = adapter.getView(this.currentScreen, this.currentPage, this);
        this.addView(this.currentPage);
        if (this.currentScreen < this.screenCount - 1) {
            this.nextPage = adapter.getView(this.currentScreen + 1, this.nextPage, this);
            this.addView(this.nextPage);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int count = this.getChildCount();
        if (count <= 0) {
            return;
        }
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int adjustedWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int adjustedHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.measure(adjustedWidthMeasureSpec, adjustedHeightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.screenCount <= 0) {
            return;
        }
        int width = r - l;
        int height = b - t;
        if (this.currentScreen > 0 && this.previousPage != null) {
            this.previousPage.layout(-width, 0, 0, height);
        }
        this.currentPage.layout(0, 0, width, height);
        if (this.currentScreen < this.screenCount - 1 && this.nextPage != null) {
            this.nextPage.layout(width, 0, width + width, height);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.screenCount <= 0) {
            return;
        }
        long drawingTime = this.getDrawingTime();
        if (this.currentScreen > 0) {
            this.drawChild(canvas, this.previousPage, drawingTime);
        }
        this.drawChild(canvas, this.currentPage, drawingTime);
        if (this.currentScreen < this.screenCount - 1) {
            this.drawChild(canvas, this.nextPage, drawingTime);
        }
    }

    public boolean dispatchUnhandledMove(View focused, int direction) {
        if (this.screenCount > 0) {
            if (direction == 17) {
                this.scrollLeft(false);
                return true;
            }
            if (direction == 66) {
                this.scrollRight(false);
                return true;
            }
        }
        return super.dispatchUnhandledMove(focused, direction);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.moving) {
            return true;
        }
        switch (action) {
            case 0: {
                this.lastMotionX = ev.getX();
                this.lastMotionY = ev.getY();
                this.moving = this.scrolling;
                break;
            }
            case 2: {
                float x = ev.getX();
                float y = ev.getY();
                int xDiff = (int)Math.abs(x - this.lastMotionX);
                int yDiff = (int)Math.abs(y - this.lastMotionY) * 3;
                if (yDiff >= xDiff || xDiff <= this.touchSlop) break;
                this.moving = true;
                this.lastMotionX = x;
                break;
            }
            case 1: 
            case 3: {
                this.moving = false;
            }
        }
        return this.moving;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.screenCount > 0) {
            if (this.velocityTracker == null) {
                this.velocityTracker = VelocityTracker.obtain();
            }
            this.velocityTracker.addMovement(ev);
            int action = ev.getAction();
            float x = ev.getX();
            switch (action) {
                case 0: {
                    if (!this.moving) break;
                    this.lastMotionX = x;
                    break;
                }
                case 2: {
                    if (this.moving) {
                        this.handleScrollMove(ev);
                        break;
                    }
                    if (!this.onInterceptTouchEvent(ev) || !this.moving) break;
                    this.handleScrollMove(ev);
                    break;
                }
                case 1: {
                    if (this.moving) {
                        this.velocityTracker.computeCurrentVelocity(1000, (float)this.maximumVelocity);
                        this.flingVelocity = (int)this.velocityTracker.getXVelocity();
                        if (this.flingVelocity > 500 && this.currentScreen > 0) {
                            this.scrollToScreen(this.currentScreen - 1, false);
                        } else if (this.flingVelocity < -500 && this.currentScreen < this.screenCount - 1) {
                            this.scrollToScreen(this.currentScreen + 1, false);
                        } else {
                            long width = this.getWidth();
                            int left = this.currentPage.getLeft();
                            long from = (long)(-this.currentScreen) * width + (long)left;
                            long to = (long)(-this.currentScreen) * width;
                            if (left > 0 && (long)(left * 2) > width) {
                                to += width;
                            } else if (left < 0 && (long)(left * 2) < -width) {
                                to -= width;
                            }
                            if (from != to) {
                                int duration = this.getScrollDuration(from, to);
                                long startTime = System.currentTimeMillis();
                                long stopTime = startTime + (long)duration;
                                this.scroll(from, to, startTime, stopTime);
                            }
                        }
                        if (this.velocityTracker != null) {
                            this.velocityTracker.recycle();
                            this.velocityTracker = null;
                        }
                    }
                    this.moving = false;
                    break;
                }
                case 3: {
                    this.moving = false;
                }
            }
            return true;
        }
        return super.onTouchEvent(ev);
    }

    private void handleScrollMove(MotionEvent ev) {
        if (this.screenCount > 0) {
            float x1 = ev.getX();
            int deltaX = (int)(x1 - this.lastMotionX);
            this.lastMotionX = x1;
            if (deltaX == 0) {
                return;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            int left = this.currentPage.getLeft() + deltaX;
            if (left > 0 && this.currentScreen == 0) {
                left = 0;
            } else if (left < 0 && this.currentScreen == this.screenCount - 1) {
                left = 0;
            }
            if (left != this.currentPage.getLeft()) {
                this.currentPage.layout(left, 0, left + width, height);
                if (left > 0) {
                    if (this.previousPage == null) {
                        this.removeView(this.nextPage);
                        this.previousPage = this.adapter.getView(this.currentScreen - 1, this.nextPage, this);
                        this.addView(this.previousPage);
                    }
                    this.previousPage.layout(left - width, 0, left, height);
                } else {
                    if (this.nextPage == null) {
                        this.removeView(this.previousPage);
                        this.nextPage = this.adapter.getView(this.currentScreen + 1, this.previousPage, this);
                        this.addView(this.nextPage);
                    }
                    this.nextPage.layout(left + width, 0, left + width * 2, height);
                }
            }
        }
    }

    public int getCurrentScreen() {
        return this.currentScreen;
    }

    public void scrollLeft(boolean immediate) {
        if (this.currentScreen > 0) {
            this.scrollToScreen(this.currentScreen - 1, immediate);
        }
    }

    public void scrollRight(boolean immediate) {
        if (this.currentScreen < this.screenCount - 1) {
            this.scrollToScreen(this.currentScreen + 1, immediate);
        }
    }

    public void scrollToScreen(int whichScreen, boolean immediate, boolean skip) {
        this.scrollToScreen(whichScreen, immediate);
    }

    public void scrollToScreen(int whichScreen, boolean immediate) {
        if (this.screenCount <= 0) {
            return;
        }
        if (whichScreen < 0) {
            whichScreen = 0;
        }
        if (whichScreen >= this.screenCount) {
            whichScreen = this.screenCount - 1;
        }
        if (whichScreen == this.currentScreen) {
            return;
        }
        if (this.currentPage != null && this.getFocusedChild() == this.currentPage) {
            this.currentPage.clearFocus();
        }
        if (immediate) {
            this.jumpToScreen(whichScreen);
        } else {
            long width = this.getWidth();
            long from = (long)(-this.currentScreen) * width + (long)this.currentPage.getLeft();
            long to = (long)(-whichScreen) * width;
            int duration = this.getScrollDuration(from, to);
            long startTime = System.currentTimeMillis();
            long stopTime = startTime + (long)duration;
            this.scroll(from, to, startTime, stopTime);
        }
    }

    private void jumpToScreen(int whichScreen) {
        View v;
        int width = this.getWidth();
        int height = this.getHeight();
        if (whichScreen == this.currentScreen - 1) {
            v = this.nextPage;
            if (this.screenCount >= 3) {
                this.removeView(v);
            }
            this.nextPage = this.currentPage;
            this.nextPage.layout(width, 0, width + width, height);
            this.currentPage = this.previousPage;
            this.currentPage.layout(0, 0, width, height);
            if (whichScreen > 0) {
                this.previousPage = this.adapter.getView(whichScreen - 1, v, this);
                this.addView(this.previousPage);
                this.previousPage.layout(-width, 0, 0, height);
            }
        } else if (whichScreen == this.currentScreen + 1) {
            v = this.previousPage;
            if (this.screenCount >= 3) {
                this.removeView(v);
            }
            this.previousPage = this.currentPage;
            this.previousPage.layout(-width, 0, 0, height);
            this.currentPage = this.nextPage;
            this.currentPage.layout(0, 0, width, height);
            if (whichScreen < this.screenCount - 1) {
                this.nextPage = this.adapter.getView(whichScreen + 1, v, this);
                this.addView(this.nextPage);
                this.nextPage.layout(width, 0, width + width, height);
            }
        } else {
            this.removeAllViews();
            if (whichScreen > 0) {
                this.previousPage = this.adapter.getView(whichScreen - 1, this.previousPage, this);
                this.addView(this.previousPage);
                this.previousPage.layout(-width, 0, 0, height);
            }
            this.currentPage = this.adapter.getView(whichScreen, this.currentPage, this);
            this.addView(this.currentPage);
            this.currentPage.layout(0, 0, width, height);
            if (whichScreen < this.screenCount - 1) {
                this.nextPage = this.adapter.getView(whichScreen + 1, this.nextPage, this);
                this.addView(this.nextPage);
                this.nextPage.layout(width, 0, width + width, height);
            }
        }
        int cs = this.currentScreen;
        this.currentScreen = whichScreen;
        this.adapter.onScreenChange(this.currentScreen, cs);
    }

    private int getScrollDuration(long from, long to) {
        int duration;
        int delta = (int)(to - from);
        int defDur = Math.abs(this.getWidth()) / 2;
        if (this.flingVelocity == 0) {
            duration = Math.abs(delta) / 2;
        } else {
            int v = Math.abs(this.flingVelocity);
            int s = Math.abs(delta);
            duration = (int)(1000.0 * ((double)v - Math.sqrt(v * v - 20 * s)) / 10.0);
        }
        if (duration == 0 || duration > defDur) {
            duration = defDur;
        }
        return duration;
    }

    private void scroll(final long from, final long to, final long startTime, final long stopTime) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                MobViewPager.this.scrolling = true;
                long currentTime = System.currentTimeMillis();
                if (currentTime > stopTime) {
                    currentTime = stopTime;
                }
                float interpolation = MobViewPager.this.getInterpolation(startTime, stopTime, currentTime);
                long offset = (long)((float)(to - from) * interpolation) + from;
                int width = MobViewPager.this.getWidth();
                int height = MobViewPager.this.getHeight();
                int screen = (int)(-offset / (long)width);
                int left = (int)(offset % (long)width);
                if (MobViewPager.this.currentScreen != screen) {
                    View convertView;
                    if (screen == MobViewPager.this.currentScreen + 1) {
                        convertView = MobViewPager.this.previousPage;
                        MobViewPager.this.previousPage = MobViewPager.this.currentPage;
                        MobViewPager.this.currentPage = MobViewPager.this.nextPage;
                        MobViewPager.this.nextPage = convertView;
                        if (screen < MobViewPager.this.screenCount - 1) {
                            MobViewPager.this.nextPage = MobViewPager.this.replaceView(screen + 1, MobViewPager.this.nextPage);
                        }
                    } else if (screen > MobViewPager.this.currentScreen) {
                        MobViewPager.this.currentPage = MobViewPager.this.replaceView(screen, MobViewPager.this.currentPage);
                        if (screen < MobViewPager.this.screenCount - 1) {
                            MobViewPager.this.nextPage = MobViewPager.this.replaceView(screen + 1, MobViewPager.this.nextPage);
                        }
                    } else if (screen == MobViewPager.this.currentScreen - 1) {
                        convertView = MobViewPager.this.nextPage;
                        MobViewPager.this.nextPage = MobViewPager.this.currentPage;
                        MobViewPager.this.currentPage = MobViewPager.this.previousPage;
                        MobViewPager.this.previousPage = convertView;
                        if (screen > 0) {
                            MobViewPager.this.previousPage = MobViewPager.this.replaceView(screen - 1, MobViewPager.this.previousPage);
                        }
                    } else {
                        MobViewPager.this.currentPage = MobViewPager.this.replaceView(screen, MobViewPager.this.currentPage);
                        if (screen > 0) {
                            MobViewPager.this.previousPage = MobViewPager.this.replaceView(screen - 1, MobViewPager.this.previousPage);
                        }
                    }
                    int lastScreen = MobViewPager.this.currentScreen;
                    MobViewPager.this.currentScreen = screen;
                    MobViewPager.this.adapter.onScreenChange(MobViewPager.this.currentScreen, lastScreen);
                }
                MobViewPager.this.adapter.onScreenChanging(-1.0f * (float)offset / (float)width);
                if (MobViewPager.this.previousPage != null) {
                    MobViewPager.this.previousPage.layout(left - width, 0, left, height);
                }
                MobViewPager.this.currentPage.layout(left, 0, left + width, height);
                if (MobViewPager.this.nextPage != null) {
                    MobViewPager.this.nextPage.layout(left + width, 0, left + width * 2, height);
                }
                if (currentTime < stopTime) {
                    MobViewPager.this.scroll(from, to, startTime, stopTime);
                } else {
                    MobViewPager.this.scrolling = false;
                }
            }
        }, 10L);
    }

    private View replaceView(int screen, View target) {
        View view = this.adapter.getView(screen, target, this);
        if (!view.equals(target) || !((Object)((Object)this)).equals(view.getParent())) {
            this.removeView(target);
            this.addView(view);
            target = view;
        }
        return target;
    }

    private float getInterpolation(long startTime, long stopTime, long currentTime) {
        float duration = stopTime - startTime;
        float progress = currentTime - startTime;
        float input = progress / duration;
        return (2.0f - input) * input;
    }
}

