/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import com.mob.tools.MobLog;

public class CachePool<K, V> {
    private int capacity;
    private int size;
    private Node<K, V> head;
    private Node<K, V> tail;

    public CachePool(int capacity) {
        this.capacity = capacity;
    }

    public synchronized boolean put(K key, V value) {
        if (key == null || this.capacity <= 0) {
            return false;
        }
        Node<K, V> n = null;
        while (this.size >= this.capacity) {
            n = this.tail;
            if (n == null) {
                MobLog.getInstance().w("size != 0 but tail == null, this must meet any mistake! fix me!!");
                Node<K, V> n1 = this.head;
                if (n1 == null) {
                    this.size = 0;
                    this.tail = null;
                    continue;
                }
                this.size = 1;
                while (n1.next != null) {
                    ++this.size;
                    n1 = n1.next;
                }
                this.tail = n1;
                continue;
            }
            this.tail = this.tail.previous;
            this.tail.next = null;
            --this.size;
        }
        if (n == null) {
            n = new Node();
        }
        ((Node)n).cacheTime = System.currentTimeMillis();
        n.key = key;
        n.value = value;
        n.previous = null;
        n.next = this.head;
        if (this.size == 0) {
            this.tail = n;
        } else if (this.head != null) {
            this.head.previous = n;
        } else {
            MobLog.getInstance().w("size != 0 but head == null, this must meet any mistake! fix me!!");
            this.tail = n;
            this.size = 0;
        }
        this.head = n;
        ++this.size;
        return true;
    }

    public synchronized V get(K key) {
        if (this.head == null) {
            this.size = 0;
            this.tail = null;
            return null;
        }
        if (this.head.key.equals(key)) {
            return this.head.value;
        }
        Node<K, V> n = this.head;
        while (n.next != null) {
            n = n.next;
            if (!n.key.equals(key)) continue;
            if (n.next == null) {
                n.previous.next = null;
                this.tail = n.previous;
            } else {
                n.previous.next = n.next;
                n.next.previous = n.previous;
            }
            n.previous = null;
            n.next = this.head;
            this.head.previous = n;
            this.head = n;
            return n.value;
        }
        return null;
    }

    public synchronized void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public synchronized void trimBeforeTime(long time) {
        if (this.capacity <= 0) {
            return;
        }
        Node<K, V> n = this.head;
        while (n != null) {
            if (((Node)n).cacheTime < time) {
                if (n.previous != null) {
                    n.previous.next = n.next;
                }
                if (n.next != null) {
                    n.next.previous = n.previous;
                }
                if (n.equals(this.head)) {
                    this.head = this.head.next;
                }
                --this.size;
            }
            n = n.next;
        }
    }

    public int size() {
        return this.size;
    }

    private static class Node<K, V> {
        public K key;
        public V value;
        public Node<K, V> previous;
        public Node<K, V> next;
        private long cacheTime;

        private Node() {
        }
    }
}

