/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import com.mob.tools.MobHandlerThread;
import com.mob.tools.MobLog;
import com.mob.tools.gui.CachePool;
import com.mob.tools.network.NetworkHelper;
import com.mob.tools.network.RawNetworkCallback;
import com.mob.tools.utils.BitmapHelper;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.ResHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Locale;

public class BitmapProcessor {
    private static final int CAPACITY = 3;
    private static final int SCAN_INTERVAL = 20000;
    private static final int MAX_CACHE_TIME = 60000;
    private static final int MAX_REQ_TIME = 20000;
    private static final int MAX_SIZE = 100;
    private static final int OVERFLOW_SIZE = 120;
    private static final int MAX_CACHE_SIZE = 50;
    private static NetworkHelper.NetworkTimeOut timeout = new NetworkHelper.NetworkTimeOut();
    private static CachePool<String, SoftReference<Bitmap>> cachePool;
    private static ArrayList<ImageReq> reqList;
    private static WorkerThread[] workerList;
    private static ArrayList<ImageReq> netReqTPS;
    private static File cacheDir;
    private static boolean work;
    private static ManagerThread manager;

    public static synchronized void prepare(Context context) {
        cacheDir = new File(ResHelper.getImageCachePath(context));
    }

    public static synchronized void start() {
        if (!work) {
            work = true;
            manager = new ManagerThread();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stop() {
        if (work) {
            work = false;
            ArrayList<ImageReq> arrayList = reqList;
            synchronized (arrayList) {
                reqList.clear();
                cachePool.clear();
            }
            manager.quit();
        }
    }

    public static synchronized void process(String url, BitmapCallback callback) {
        BitmapProcessor.process(url, null, callback);
    }

    public static synchronized void process(String url, BitmapDesiredOptions bmOpt, BitmapCallback callback) {
        BitmapProcessor.process(url, bmOpt, true, callback);
    }

    public static synchronized void process(String url, BitmapDesiredOptions bmOpt, boolean useRamCache, BitmapCallback callback) {
        BitmapProcessor.process(url, bmOpt, useRamCache, true, callback);
    }

    public static synchronized void process(String url, BitmapDesiredOptions bmOpt, boolean useRamCache, boolean useDiskCache, BitmapCallback callback) {
        BitmapProcessor.process(url, bmOpt, useRamCache, useDiskCache, 0L, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void process(String url, BitmapDesiredOptions bmOpt, boolean useRamCache, boolean useDiskCache, long diskCacheTime, BitmapCallback callback) {
        if (url == null) {
            return;
        }
        ArrayList<ImageReq> arrayList = reqList;
        synchronized (arrayList) {
            int size = reqList.size();
            for (int i = 0; i < size; ++i) {
                boolean sameOpt;
                ImageReq req = reqList.get(i);
                boolean sameUrl = req.url.equals(url);
                boolean bl = sameOpt = req.bitmapDesiredOptions == null && bmOpt == null || req.bitmapDesiredOptions != null && req.bitmapDesiredOptions.equals(bmOpt);
                if (!sameUrl || !sameOpt) continue;
                if (callback != null && req.callbacks.indexOf(callback) == -1) {
                    req.callbacks.add(callback);
                }
                BitmapProcessor.start();
                return;
            }
        }
        ImageReq req = new ImageReq();
        req.url = url;
        req.bitmapDesiredOptions = bmOpt;
        req.useRamCache = useRamCache;
        req.diskCacheTime = diskCacheTime;
        req.useDiskCache = useDiskCache;
        if (callback != null) {
            req.callbacks.add(callback);
        }
        ArrayList<ImageReq> arrayList2 = reqList;
        synchronized (arrayList2) {
            reqList.add(req);
            if (reqList.size() > 120) {
                while (reqList.size() > 100) {
                    reqList.remove(0);
                }
            }
        }
        BitmapProcessor.start();
    }

    private static String getCacheKey(String url, BitmapDesiredOptions bitmapDesiredOptions) {
        return bitmapDesiredOptions == null ? url : url + bitmapDesiredOptions.toString();
    }

    public static Bitmap getBitmapFromCache(String url) {
        return BitmapProcessor.getBitmapFromCache(url, null);
    }

    public static Bitmap getBitmapFromCache(String url, BitmapDesiredOptions bitmapDesiredOptions) {
        if (cachePool == null || url == null || cachePool.get(BitmapProcessor.getCacheKey(url, bitmapDesiredOptions)) == null) {
            return null;
        }
        return cachePool.get(BitmapProcessor.getCacheKey(url, bitmapDesiredOptions)).get();
    }

    public static void removeBitmapFromRamCache(String url, BitmapDesiredOptions bitmapDesiredOptions) {
        if (cachePool != null) {
            cachePool.put(BitmapProcessor.getCacheKey(url, bitmapDesiredOptions), null);
        }
    }

    public static void deleteCachedFile(String url, BitmapDesiredOptions bitmapDesiredOptions) {
        BitmapProcessor.removeBitmapFromRamCache(url, bitmapDesiredOptions);
        try {
            File cachedFile = new File(cacheDir, Data.MD5(url));
            cachedFile.delete();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void deleteCacheDir(boolean sync) {
        if (sync) {
            BitmapProcessor.deleteCacheDir();
        } else {
            new Thread(){

                @Override
                public void run() {
                    BitmapProcessor.deleteCacheDir();
                }
            }.start();
        }
    }

    private static synchronized void deleteCacheDir() {
        File dir = new File(cacheDir.getPath());
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                new File(dir, children[i]).delete();
            }
        }
    }

    public static long getCacheSizeInByte() {
        File[] files;
        File dir = new File(cacheDir.getPath());
        long size = 0L;
        for (File f : files = dir.listFiles()) {
            size += f.length();
        }
        return size;
    }

    public static String getCacheSizeText() {
        float size = BitmapProcessor.getCacheSizeInByte();
        if (size < 1024.0f) {
            return String.format(Locale.CHINA, "%.02f", Float.valueOf(size)) + " B";
        }
        if (size / 1024.0f < 1000.0f) {
            return String.format(Locale.CHINA, "%.02f", Float.valueOf(size / 1024.0f)) + " KB";
        }
        return String.format(Locale.CHINA, "%.02f", Float.valueOf(size / 1024.0f / 1204.0f)) + " MB";
    }

    static {
        BitmapProcessor.timeout.connectionTimeout = 5000;
        BitmapProcessor.timeout.readTimout = 20000 - BitmapProcessor.timeout.connectionTimeout;
        reqList = new ArrayList();
        netReqTPS = new ArrayList();
        workerList = new WorkerThread[3];
        cachePool = new CachePool(50);
    }

    public static class BitmapDesiredOptions {
        public int desiredWidth = 0;
        public int desiredHeight = 0;
        public long maxBytes = 0L;
        public int quality = 0;

        public boolean equals(Object o) {
            return super.equals(o) || o != null && o.toString().equals(this.toString());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.desiredWidth > 0) {
                sb.append(this.desiredWidth);
            }
            if (this.desiredHeight > 0) {
                sb.append(this.desiredHeight);
            }
            if (this.maxBytes > 0L) {
                sb.append(this.maxBytes);
            }
            if (this.quality > 0) {
                sb.append(this.quality);
            }
            return sb.toString();
        }
    }

    public static class ImageReq {
        private String url;
        private BitmapDesiredOptions bitmapDesiredOptions;
        private boolean useRamCache = true;
        private boolean useDiskCache = true;
        private long diskCacheTime = 0L;
        private ArrayList<BitmapCallback> callbacks;
        private WorkerThread worker;
        private long reqTime = System.currentTimeMillis();

        public ImageReq() {
            this.callbacks = new ArrayList();
        }

        private void throwComplete(Bitmap bitmap) {
            for (BitmapCallback cb : this.callbacks) {
                cb.onImageGot(this.url, bitmap);
            }
        }

        private void throwError() {
            for (BitmapCallback cb : this.callbacks) {
                cb.onImageGot(this.url, null);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("url=").append(this.url);
            sb.append("time=").append(this.reqTime);
            sb.append("worker=").append(this.worker.getName()).append(" (").append(this.worker.getId()).append("");
            return sb.toString();
        }
    }

    public static interface BitmapCallback {
        public void onImageGot(String var1, Bitmap var2);
    }

    private static class PatchInputStream
    extends FilterInputStream {
        InputStream in;

        protected PatchInputStream(InputStream in) {
            super(in);
            this.in = in;
        }

        @Override
        public long skip(long n) throws IOException {
            long m;
            long mm;
            for (m = 0L; m < n && (mm = this.in.skip(n - m)) != 0L; m += mm) {
            }
            return m;
        }
    }

    private static class WorkerThread
    extends Thread {
        private boolean localType;
        private ImageReq curReq;

        private WorkerThread() {
        }

        @Override
        public void run() {
            while (work) {
                try {
                    if (this.localType) {
                        this.doLocalTask();
                        continue;
                    }
                    this.doNetworkTask();
                }
                catch (Throwable t) {
                    MobLog.getInstance().w(t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doLocalTask() throws Throwable {
            ImageReq req = null;
            ArrayList arrayList = reqList;
            synchronized (arrayList) {
                if (reqList.size() > 0) {
                    req = (ImageReq)reqList.remove(0);
                }
            }
            if (req != null) {
                Bitmap bm = null;
                if (req.useRamCache) {
                    SoftReference ref = (SoftReference)cachePool.get(BitmapProcessor.getCacheKey(req.url, req.bitmapDesiredOptions));
                    Bitmap bitmap = bm = ref == null ? null : (Bitmap)ref.get();
                }
                if (bm != null) {
                    this.curReq = req;
                    this.curReq.worker = this;
                    req.throwComplete(bm);
                } else if (req.useDiskCache && cacheDir != null && new File(cacheDir, Data.MD5(req.url)).exists()) {
                    this.doTask(req);
                } else {
                    ArrayList arrayList2 = reqList;
                    synchronized (arrayList2) {
                        if (netReqTPS.size() > 100) {
                            ArrayList arrayList3 = reqList;
                            synchronized (arrayList3) {
                                while (reqList.size() > 0) {
                                    reqList.remove(0);
                                }
                            }
                            netReqTPS.remove(0);
                        }
                    }
                    netReqTPS.add(req);
                }
            } else {
                try {
                    Thread.sleep(30L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doNetworkTask() throws Throwable {
            ImageReq req = null;
            ArrayList arrayList = netReqTPS;
            synchronized (arrayList) {
                if (netReqTPS.size() > 0) {
                    req = (ImageReq)netReqTPS.remove(0);
                }
            }
            if (req == null) {
                arrayList = reqList;
                synchronized (arrayList) {
                    if (reqList.size() > 0) {
                        req = (ImageReq)reqList.remove(0);
                    }
                }
            }
            if (req != null) {
                Bitmap bm = null;
                if (req.useRamCache) {
                    SoftReference ref = (SoftReference)cachePool.get(BitmapProcessor.getCacheKey(req.url, req.bitmapDesiredOptions));
                    Bitmap bitmap = bm = ref == null ? null : (Bitmap)ref.get();
                }
                if (bm != null) {
                    this.curReq = req;
                    this.curReq.worker = this;
                    req.throwComplete(bm);
                } else {
                    this.doTask(req);
                }
            } else {
                try {
                    Thread.sleep(30L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void doTask(final ImageReq req) throws Throwable {
            try {
                this.curReq = req;
                this.curReq.worker = this;
                Bitmap bm = null;
                final String md5 = Data.MD5(req.url);
                File cacheFile = new File(cacheDir, md5);
                if (req.useDiskCache && req.diskCacheTime > 0L && cacheFile.exists()) {
                    long lastModified = cacheFile.lastModified();
                    long currentTime = System.currentTimeMillis();
                    if (lastModified + req.diskCacheTime < currentTime) {
                        cacheFile.delete();
                    }
                }
                if (req.useDiskCache && cacheDir != null && cacheFile.exists()) {
                    if (req.bitmapDesiredOptions == null || req.bitmapDesiredOptions.equals("")) {
                        bm = BitmapHelper.getBitmap(cacheFile.getAbsolutePath());
                    } else {
                        String path = new File(cacheDir, md5).getAbsolutePath();
                        int desiredWidth = ((ImageReq)req).bitmapDesiredOptions.desiredWidth;
                        int desiredHeight = ((ImageReq)req).bitmapDesiredOptions.desiredHeight;
                        int quality = ((ImageReq)req).bitmapDesiredOptions.quality;
                        long maxBytes = ((ImageReq)req).bitmapDesiredOptions.maxBytes;
                        bm = BitmapHelper.getBitmapByCompressQuality(path, desiredWidth, desiredHeight, quality, maxBytes);
                    }
                    if (bm != null) {
                        if (req.useRamCache) {
                            cachePool.put(BitmapProcessor.getCacheKey(req.url, req.bitmapDesiredOptions), new SoftReference<Bitmap>(bm));
                        }
                        req.throwComplete(bm);
                    } else {
                        req.throwError();
                    }
                    this.curReq = null;
                } else {
                    NetworkHelper helper = new NetworkHelper();
                    helper.rawGet(req.url, new RawNetworkCallback(){

                        @Override
                        public void onResponse(InputStream is) throws Throwable {
                            PatchInputStream pis = new PatchInputStream(is);
                            Bitmap bitmap = null;
                            if (cacheDir != null) {
                                File file = new File(cacheDir, md5);
                                WorkerThread.this.saveFile(pis, file);
                                bitmap = req.bitmapDesiredOptions == null || req.bitmapDesiredOptions.equals("") ? BitmapHelper.getBitmap(file, 1) : BitmapHelper.getBitmapByCompressQuality(file.getAbsolutePath(), ((ImageReq)req).bitmapDesiredOptions.desiredWidth, ((ImageReq)req).bitmapDesiredOptions.desiredHeight, ((ImageReq)req).bitmapDesiredOptions.quality, ((ImageReq)req).bitmapDesiredOptions.maxBytes);
                                if (!req.useDiskCache) {
                                    file.delete();
                                }
                            } else {
                                bitmap = BitmapHelper.getBitmap(pis, 1);
                            }
                            if (bitmap == null || bitmap.isRecycled()) {
                                req.throwError();
                            } else {
                                if (req.useRamCache) {
                                    cachePool.put(BitmapProcessor.getCacheKey(req.url, req.bitmapDesiredOptions), new SoftReference<Bitmap>(bitmap));
                                }
                                req.throwComplete(bitmap);
                            }
                            WorkerThread.this.curReq = null;
                        }
                    }, timeout);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
                req.throwError();
                this.curReq = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveFile(InputStream is, File file) {
            FileOutputStream fos = null;
            try {
                if (file.exists()) {
                    file.delete();
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
                fos = new FileOutputStream(file);
                byte[] tmp = new byte[256];
                int len = is.read(tmp);
                while (len > 0) {
                    fos.write(tmp, 0, len);
                    len = is.read(tmp);
                }
                fos.flush();
            }
            catch (Throwable t) {
                if (file.exists()) {
                    file.delete();
                }
            }
            finally {
                try {
                    fos.close();
                    is.close();
                }
                catch (Throwable tmp) {}
            }
        }

        @Override
        public void interrupt() {
            try {
                super.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class ManagerThread
    implements Handler.Callback {
        private Handler handler = MobHandlerThread.newHandler(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < workerList.length; ++i) {
                    if (workerList[i] != null) continue;
                    workerList[i] = new WorkerThread();
                    workerList[i].setName("worker " + i);
                    workerList[i].localType = i == 0;
                    workerList[i].start();
                }
            }
        }, this);

        public ManagerThread() {
            this.handler.sendEmptyMessageDelayed(1, 20000L);
        }

        public boolean handleMessage(Message msg) {
            if (cachePool != null) {
                cachePool.trimBeforeTime(System.currentTimeMillis() - 60000L);
            }
            int cacheMapSize = cachePool == null ? 0 : cachePool.size();
            MobLog.getInstance().d(">>>> BitmapProcessor.cachePool: " + cacheMapSize, new Object[0]);
            int reqListSize = reqList == null ? 0 : reqList.size();
            MobLog.getInstance().d(">>>> BitmapProcessor.reqList: " + reqListSize, new Object[0]);
            if (work) {
                this.handler.sendEmptyMessageDelayed(1, 20000L);
            }
            return false;
        }

        public void quit() {
            this.handler.removeMessages(1);
            this.handler.getLooper().quit();
            for (int i = 0; i < workerList.length; ++i) {
                if (workerList[i] == null) continue;
                workerList[i].interrupt();
                workerList[i] = null;
            }
        }
    }
}

