/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.mob.tools.MobLog;
import com.mob.tools.gui.BitmapProcessor;
import com.mob.tools.utils.BitmapHelper;
import com.mob.tools.utils.UIHandler;
import java.lang.ref.WeakReference;
import java.util.Random;

public class AsyncImageView
extends ImageView
implements BitmapProcessor.BitmapCallback,
Handler.Callback {
    private static final int MSG_IMG_GOT = 1;
    private static final Random RND = new Random();
    private float[] rect;
    private boolean scaleToCrop;
    private String url;
    private int defaultRes;
    private int errorRes = 0;
    private Bitmap defaultBm;
    private Bitmap errorBm = null;
    private Path path;
    private boolean lastReqIsOk;
    private Bitmap result;
    private WeakReference<AsyncImageView> refAiv = null;
    private boolean useRamCache = true;
    private boolean useDiskCache = true;
    private long diskCacheTime = 0L;
    private int desiredWidth = 0;
    private int desiredHeight = 0;
    private long maxBytes = 0L;
    private int quality = 0;

    public AsyncImageView(Context context) {
        super(context);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        if (this.isInEditMode()) {
            this.setBackgroundColor(-16777216);
            return;
        }
        BitmapProcessor.prepare(context);
    }

    public void setRound(float radius) {
        this.setRound(radius, radius, radius, radius);
    }

    public void setRound(float leftTop, float rightTop, float rightBottom, float leftBottom) {
        this.rect = new float[]{leftTop, leftTop, rightTop, rightTop, rightBottom, rightBottom, leftBottom, leftBottom};
    }

    public void setScaleToCropCenter(boolean scaleToCrop) {
        this.scaleToCrop = scaleToCrop;
    }

    public void setCompressOptions(int desiredWidth, int desiredHeight, int quality, long maxBytes) {
        this.desiredWidth = desiredWidth;
        this.desiredHeight = desiredHeight;
        this.quality = quality;
        this.maxBytes = maxBytes;
    }

    public void setUseCacheOption(boolean useRamCache, boolean useDiskCache) {
        this.setUseCacheOption(useRamCache, useDiskCache, 0L);
    }

    public void setUseCacheOption(boolean useRamCache, boolean useDiskCache, long diskCacheTime) {
        this.useRamCache = useRamCache;
        this.useDiskCache = useDiskCache;
        if (useDiskCache) {
            this.diskCacheTime = diskCacheTime;
        }
    }

    public void removeRamCache(String url) {
        if (this.useRamCache) {
            BitmapProcessor.removeBitmapFromRamCache(url, this.getBitmapDesiredOptions());
        }
    }

    public void deleteCachedFile(String url) {
        BitmapProcessor.deleteCachedFile(url, this.getBitmapDesiredOptions());
    }

    public void execute(String url, int defaultRes) {
        this.execute(url, defaultRes, 0);
    }

    public void execute(String url, int defaultRes, int errorRes) {
        Bitmap bm;
        if ((this.useRamCache || this.useDiskCache) && this.lastReqIsOk && !TextUtils.isEmpty((CharSequence)url) && url.equals(this.url)) {
            return;
        }
        this.lastReqIsOk = false;
        this.url = url;
        this.result = null;
        this.defaultRes = defaultRes;
        this.errorRes = errorRes;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.setImageResource(errorRes == 0 ? defaultRes : errorRes);
            return;
        }
        BitmapProcessor.BitmapDesiredOptions options = this.getBitmapDesiredOptions();
        if (this.useRamCache && (bm = BitmapProcessor.getBitmapFromCache(url, options)) != null && !bm.isRecycled()) {
            this.setBitmap(bm);
            this.lastReqIsOk = true;
            return;
        }
        if (defaultRes > 0) {
            this.setImageResource(defaultRes);
        }
        if (this.refAiv == null || this.refAiv.get() == null) {
            this.refAiv = new WeakReference<AsyncImageView>(this);
        }
        BitmapProcessor.process(url, options, this.useRamCache, this.useDiskCache, this.diskCacheTime, this);
    }

    public void execute(String url, Bitmap defaultBm) {
        this.execute(url, defaultBm, null);
    }

    public void execute(String url, Bitmap defaultBm, Bitmap errorBm) {
        Bitmap bm;
        if ((this.useRamCache || this.useDiskCache) && this.lastReqIsOk && !TextUtils.isEmpty((CharSequence)url) && url.equals(this.url)) {
            return;
        }
        this.lastReqIsOk = false;
        this.url = url;
        this.result = null;
        this.defaultBm = defaultBm;
        this.errorBm = errorBm;
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.setImageBitmap(errorBm == null ? defaultBm : errorBm);
            return;
        }
        BitmapProcessor.BitmapDesiredOptions options = this.getBitmapDesiredOptions();
        if (this.useRamCache && (bm = BitmapProcessor.getBitmapFromCache(url, options)) != null && !bm.isRecycled()) {
            this.setBitmap(bm);
            this.lastReqIsOk = true;
            return;
        }
        if (defaultBm != null && !defaultBm.isRecycled()) {
            this.setImageBitmap(defaultBm);
        }
        if (this.refAiv == null || this.refAiv.get() == null) {
            this.refAiv = new WeakReference<AsyncImageView>(this);
        }
        BitmapProcessor.process(url, options, this.useRamCache, this.useDiskCache, this.diskCacheTime, this);
    }

    private BitmapProcessor.BitmapDesiredOptions getBitmapDesiredOptions() {
        BitmapProcessor.BitmapDesiredOptions options = null;
        if (this.desiredWidth > 1 && this.desiredHeight > 1 || this.maxBytes >= 10240L || this.quality > 0) {
            options = new BitmapProcessor.BitmapDesiredOptions();
            options.desiredWidth = this.desiredWidth;
            options.desiredHeight = this.desiredHeight;
            options.maxBytes = this.maxBytes;
            options.quality = this.quality;
        }
        return options;
    }

    public void setBitmap(Bitmap bm) {
        if (this.scaleToCrop) {
            bm = this.goCrop(bm);
        }
        this.setImageBitmap(bm);
        this.result = bm;
    }

    @Override
    public void onImageGot(String url, Bitmap bm) {
        if (this.refAiv == null || this.refAiv.get() == null) {
            return;
        }
        Bitmap shownImage = null;
        if (url != null && url.trim().length() > 0 && url.equals(this.url)) {
            shownImage = bm;
        }
        if (shownImage != null && this.scaleToCrop) {
            shownImage = this.goCrop(shownImage);
        }
        Message msg = new Message();
        msg.what = 1;
        msg.obj = new Object[]{url, shownImage};
        int delay = RND.nextInt(300);
        UIHandler.sendMessageDelayed(msg, delay, this);
    }

    private Bitmap goCrop(Bitmap bm) {
        float width = bm.getWidth();
        float height = bm.getHeight();
        if (width == 0.0f || height == 0.0f) {
            return bm;
        }
        int[] size = this.getSize();
        if (size[0] == 0 || size[1] == 0) {
            return bm;
        }
        float respHeight = (float)size[1] * width / (float)size[0];
        if (respHeight == height) {
            return bm;
        }
        int[] rect = new int[4];
        if (respHeight < height) {
            rect[1] = (int)((height - respHeight) / 2.0f);
            rect[3] = rect[1];
        } else {
            float respWidth = (float)size[0] * height / (float)size[1];
            rect[0] = (int)((width - respWidth) / 2.0f);
            rect[2] = rect[0];
        }
        try {
            bm = BitmapHelper.cropBitmap(bm, rect[0], rect[1], rect[2], rect[3]);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return bm;
    }

    private int[] getSize() {
        ViewGroup.LayoutParams lp;
        int width = this.getWidth();
        int height = this.getHeight();
        if ((width == 0 || height == 0) && (lp = this.getLayoutParams()) != null) {
            width = lp.width;
            height = lp.height;
        }
        if (width == 0 || height == 0) {
            this.measure(0, 0);
            width = this.getMeasuredWidth();
            height = this.getMeasuredHeight();
        }
        return new int[]{width, height};
    }

    public void setPadding(int left, int top, int right, int bottom) {
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 1) {
            if (this.refAiv == null || this.refAiv.get() == null) {
                return false;
            }
            try {
                Object url = ((Object[])msg.obj)[0];
                Object bm = ((Object[])msg.obj)[1];
                if (bm != null && url != null && url.equals(this.url)) {
                    this.result = (Bitmap)bm;
                    ((AsyncImageView)this.refAiv.get()).setImageBitmap(this.result);
                    this.lastReqIsOk = true;
                } else if (this.errorRes > 0) {
                    ((AsyncImageView)this.refAiv.get()).setImageResource(this.errorRes);
                } else if (this.errorBm != null && !this.errorBm.isRecycled()) {
                    ((AsyncImageView)this.refAiv.get()).setImageBitmap(this.errorBm);
                } else if (this.defaultBm != null && !this.defaultBm.isRecycled()) {
                    ((AsyncImageView)this.refAiv.get()).setImageBitmap(this.defaultBm);
                } else {
                    ((AsyncImageView)this.refAiv.get()).setImageResource(this.defaultRes);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        if (this.getDrawable() == null) {
            return;
        }
        if (this.getDrawable().getIntrinsicWidth() == 0 || this.getDrawable().getIntrinsicHeight() == 0) {
            return;
        }
        Matrix drawMatrix = this.getImageMatrix();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int saveCount = canvas.getSaveCount();
        canvas.save();
        if (this.result != null) {
            this.myClip(canvas);
            canvas.drawBitmap(this.result, drawMatrix, new Paint(6));
        } else {
            if (drawMatrix != null || paddingLeft != 0 || paddingTop != 0) {
                if (Build.VERSION.SDK_INT >= 19 && this.getCropToPadding()) {
                    int scrollX = this.getScrollX();
                    int scrollY = this.getScrollY();
                    canvas.clipRect(scrollX + paddingLeft, scrollY + paddingTop, scrollX + this.getRight() - this.getLeft() - this.getPaddingRight(), scrollY + this.getBottom() - this.getTop() - this.getPaddingBottom());
                }
                canvas.translate((float)paddingLeft, (float)paddingTop);
                if (drawMatrix != null) {
                    canvas.concat(drawMatrix);
                }
            }
            this.getDrawable().draw(canvas);
        }
        canvas.restoreToCount(saveCount);
    }

    private void myClip(Canvas canvas) {
        if (this.rect != null) {
            if (this.path == null) {
                int width = this.getWidth();
                int height = this.getHeight();
                this.path = new Path();
                RectF bound = new RectF(0.0f, 0.0f, (float)width, (float)height);
                this.path.addRoundRect(bound, this.rect, Path.Direction.CW);
            }
            canvas.clipPath(this.path);
        }
    }
}

