/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import com.mob.tools.MobLog;

public class MobHandlerThread
extends Thread {
    private int priority;
    private int tid = -1;
    private Looper looper;

    public MobHandlerThread() {
        this.priority = 0;
    }

    public MobHandlerThread(int priority) {
        this.priority = priority;
    }

    protected void onLooperPrepared() {
    }

    protected void onLooperPrepared(Looper looper) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.realRun();
            this.tid = Process.myTid();
            Looper.prepare();
            MobHandlerThread mobHandlerThread = this;
            synchronized (mobHandlerThread) {
                this.looper = Looper.myLooper();
                this.notifyAll();
            }
            Process.setThreadPriority((int)this.priority);
            this.onLooperPrepared(this.looper);
            this.onLooperPrepared();
            Looper.loop();
            this.tid = -1;
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
    }

    @Deprecated
    public void realRun() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        MobHandlerThread mobHandlerThread = this;
        synchronized (mobHandlerThread) {
            while (this.isAlive() && this.looper == null) {
                try {
                    this.wait();
                }
                catch (Throwable throwable) {}
            }
        }
        return this.looper;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    public int getThreadId() {
        return this.tid;
    }

    public static Handler newHandler(Handler.Callback callback) {
        return MobHandlerThread.newHandler(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Handler newHandler(final Runnable beforeRun, final Handler.Callback callback) {
        final Handler[] handler = new Handler[1];
        MobHandlerThread thread = new MobHandlerThread(){

            @Override
            public void run() {
                if (beforeRun != null) {
                    beforeRun.run();
                }
                super.run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onLooperPrepared(Looper looper) {
                Handler[] handlerArray = handler;
                synchronized (handler) {
                    handler[0] = new Handler(looper, callback);
                    handler.notifyAll();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        };
        Handler[] handlerArray = handler;
        synchronized (handler) {
            thread.start();
            try {
                handler.wait();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return handler[0];
        }
    }
}

