/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.mob.tools.MobLog;
import com.mob.tools.MobUIShell;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.ResHelper;
import com.mob.tools.utils.UIHandler;
import java.lang.reflect.Method;
import java.util.HashMap;

public class FakeActivity {
    private static Class<? extends Activity> shellClass;
    protected Activity activity;
    private FakeActivity resultReceiver;
    private HashMap<String, Object> result;
    private View contentView;

    public static void setShell(Class<? extends Activity> shellClass) {
        FakeActivity.shellClass = shellClass;
    }

    public static void registerExecutor(String scheme, Object executor) {
        if (shellClass != null) {
            try {
                Method registerExecutor = shellClass.getMethod("registerExecutor", String.class, Object.class);
                registerExecutor.setAccessible(true);
                registerExecutor.invoke(null, scheme, executor);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        } else {
            MobUIShell.registerExecutor(scheme, executor);
        }
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }

    protected int onSetTheme(int resid, boolean atLaunch) {
        return resid;
    }

    protected boolean disableScreenCapture() {
        if (this.activity != null && Build.VERSION.SDK_INT >= 11) {
            this.activity.getWindow().setFlags(8192, 8192);
            return true;
        }
        return false;
    }

    public void setContentViewLayoutResName(String name) {
        if (this.activity == null) {
            return;
        }
        int resId = ResHelper.getLayoutRes((Context)this.activity, name);
        if (resId > 0) {
            this.activity.setContentView(resId);
        }
    }

    public void setContentView(View view) {
        this.contentView = view;
    }

    public View getContentView() {
        return this.contentView;
    }

    public <T extends View> T findViewById(int id) {
        if (this.activity == null) {
            return null;
        }
        return (T)this.activity.findViewById(id);
    }

    public <T extends View> T findViewByResName(View view, String name) {
        if (this.activity == null) {
            return null;
        }
        int resId = ResHelper.getIdRes((Context)this.activity, name);
        if (resId > 0) {
            return (T)view.findViewById(resId);
        }
        return null;
    }

    public <T extends View> T findViewByResName(String name) {
        if (this.activity == null) {
            return null;
        }
        int resId = ResHelper.getIdRes((Context)this.activity, name);
        if (resId > 0) {
            return this.findViewById(resId);
        }
        return null;
    }

    public void onCreate() {
    }

    public void onNewIntent(Intent intent) {
    }

    public void onStart() {
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void onStop() {
    }

    public void onRestart() {
    }

    public boolean onFinish() {
        return false;
    }

    public void onDestroy() {
    }

    public final void finish() {
        if (this.activity != null) {
            this.activity.finish();
        }
    }

    public boolean onKeyEvent(int keyCode, KeyEvent event) {
        return false;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }

    public void startActivity(Intent intent) {
        this.startActivityForResult(intent, -1);
    }

    public void startActivityForResult(Intent intent, int requestCode) {
        if (this.activity == null) {
            return;
        }
        this.activity.startActivityForResult(intent, requestCode);
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
    }

    public Context getContext() {
        return this.activity;
    }

    public void show(Context context, Intent i) {
        this.showForResult(context, i, null);
    }

    public void showForResult(final Context context, Intent i, FakeActivity resultReceiver) {
        Intent iExec;
        this.resultReceiver = resultReceiver;
        String launchTime = null;
        if (shellClass != null) {
            iExec = new Intent(context, shellClass);
            try {
                Method registerExecutor = shellClass.getMethod("registerExecutor", Object.class);
                registerExecutor.setAccessible(true);
                launchTime = (String)registerExecutor.invoke(null, this);
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        } else {
            iExec = new Intent(context, MobUIShell.class);
            launchTime = MobUIShell.registerExecutor(this);
        }
        iExec.putExtra("launch_time", launchTime);
        iExec.putExtra("executor_name", this.getClass().getName());
        if (i != null) {
            iExec.putExtras(i);
        }
        if (Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
            this.showActivity(context, iExec);
        } else {
            final Intent finalIExec = iExec;
            UIHandler.sendEmptyMessage(0, new Handler.Callback(){

                public boolean handleMessage(Message msg) {
                    FakeActivity.this.showActivity(context, finalIExec);
                    return false;
                }
            });
        }
    }

    private void showActivity(Context cxt, Intent i) {
        if (!(cxt instanceof Activity)) {
            Activity act = DeviceHelper.getInstance(cxt).getTopActivity();
            if (act == null) {
                i.addFlags(0x10000000);
            } else {
                cxt = act;
            }
        }
        cxt.startActivity(i);
    }

    public FakeActivity getParent() {
        return this.resultReceiver;
    }

    public final void setResult(HashMap<String, Object> result) {
        this.result = result;
    }

    public void sendResult() {
        if (this.resultReceiver != null) {
            this.resultReceiver.onResult(this.result);
        }
    }

    public void onResult(HashMap<String, Object> data) {
    }

    public void runOnUIThread(final Runnable r) {
        UIHandler.sendEmptyMessage(0, new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                r.run();
                return false;
            }
        });
    }

    public void runOnUIThread(final Runnable r, long delayMillis) {
        UIHandler.sendEmptyMessageDelayed(0, delayMillis, new Handler.Callback(){

            public boolean handleMessage(Message msg) {
                r.run();
                return false;
            }
        });
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (this.activity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 26) {
            this.activity.setRequestedOrientation(requestedOrientation);
        }
    }

    public void requestPortraitOrientation() {
        this.setRequestedOrientation(1);
    }

    public void requestLandscapeOrientation() {
        this.setRequestedOrientation(0);
    }

    public void requestSensorPortraitOrientation() {
        this.setRequestedOrientation(7);
    }

    public void requestSensorLandscapeOrientation() {
        this.setRequestedOrientation(6);
    }

    public int getOrientation() {
        return this.activity.getResources().getConfiguration().orientation;
    }

    public void requestFullScreen(boolean fullScreen) {
        if (this.activity == null) {
            return;
        }
        if (fullScreen) {
            this.activity.getWindow().addFlags(1024);
            this.activity.getWindow().clearFlags(2048);
        } else {
            this.activity.getWindow().addFlags(2048);
            this.activity.getWindow().clearFlags(1024);
        }
        this.activity.getWindow().getDecorView().requestLayout();
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        return false;
    }

    public void requestPermissions(String[] permissions, int requestCode) {
        if (this.activity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                ReflectHelper.invokeInstanceMethod(this.activity, "requestPermissions", permissions, requestCode);
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
    }

    public void beforeStartActivityForResult(Intent intent, int requestCode, Bundle options) {
    }
}

